/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.playeranimator.nms.v1_19_R3.entity;

import com.mojang.datafixers.util.Pair;
import com.ticxo.playeranimator.api.PlayerAnimator;
import com.ticxo.playeranimator.api.model.player.LimbType;
import com.ticxo.playeranimator.api.model.player.PlayerBone;
import com.ticxo.playeranimator.api.nms.IRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Vector3f;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.EulerAngle;

public class RendererImpl
implements IRenderer {
    private final List<Pair<EnumItemSlot, net.minecraft.world.item.ItemStack>> equipments = new ArrayList<Pair<EnumItemSlot, net.minecraft.world.item.ItemStack>>();
    private EntityArmorStand armorStand;
    private EntityAreaEffectCloud cloud;
    private PlayerBone limb;

    @Override
    public void setLimb(PlayerBone limb) {
        this.limb = limb;
        WorldServer nmsWorld = ((CraftWorld)limb.getModel().getBase().getWorld()).getHandle();
        if (this.armorStand == null) {
            this.armorStand = new EntityArmorStand(EntityTypes.d, (World)nmsWorld);
        }
        this.armorStand.j(true);
        this.armorStand.d(new Vector3f(0.0f, 0.0f, 0.0f));
        this.armorStand.c(new Vector3f(0.0f, 0.0f, 0.0f));
        if (this.cloud == null) {
            this.cloud = new EntityAreaEffectCloud(EntityTypes.c, (World)nmsWorld);
        }
        this.cloud.a(0.0f);
        this.cloud.j(true);
        this.armorStand.k((net.minecraft.world.entity.Entity)this.cloud);
        if (limb.getType().isItem()) {
            Entity entity = limb.getModel().getBase();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity living = (LivingEntity)entity;
            if (limb.getType() == LimbType.RIGHT_ITEM) {
                item = living.getEquipment().getItemInMainHand();
                this.equipments.add((Pair<EnumItemSlot, net.minecraft.world.item.ItemStack>)Pair.of((Object)EnumItemSlot.a, (Object)CraftItemStack.asNMSCopy((ItemStack)item)));
            } else {
                item = living.getEquipment().getItemInOffHand();
                this.equipments.add((Pair<EnumItemSlot, net.minecraft.world.item.ItemStack>)Pair.of((Object)EnumItemSlot.b, (Object)CraftItemStack.asNMSCopy((ItemStack)item)));
            }
        } else {
            ItemStack playerHead = PlayerAnimator.api.getNms().setSkullTexture(null, limb.getModel().getTexture());
            ItemMeta meta = playerHead.getItemMeta();
            meta.setCustomModelData(Integer.valueOf(limb.getModel().getTexture().isSlim() ? limb.getType().getSlimId() : limb.getType().getModelId()));
            playerHead.setItemMeta(meta);
            this.equipments.add((Pair<EnumItemSlot, net.minecraft.world.item.ItemStack>)Pair.of((Object)EnumItemSlot.a, (Object)CraftItemStack.asNMSCopy((ItemStack)playerHead)));
        }
    }

    @Override
    public void spawn() {
        List<Packet<?>> packets = this.getSpawnPackets();
        for (Player player : this.limb.getModel().getSeenBy()) {
            this.sendPackets(player, packets);
        }
    }

    @Override
    public void spawn(Player player) {
        this.sendPackets(player, this.getSpawnPackets());
    }

    @Override
    public void despawn() {
        List<Packet<?>> packets = this.getDespawnPackets();
        for (Player player : this.limb.getModel().getSeenBy()) {
            this.sendPackets(player, packets);
        }
    }

    @Override
    public void despawn(Player player) {
        this.sendPackets(player, this.getDespawnPackets());
    }

    @Override
    public void update() {
        List<Packet<?>> packets = this.getMovePackets();
        for (Player player : this.limb.getModel().getSeenBy()) {
            this.sendPackets(player, packets);
        }
    }

    private void sendPackets(Player player, List<Packet<?>> packets) {
        PlayerConnection packetListener = ((CraftPlayer)player).getHandle().b;
        for (Packet<?> packet : packets) {
            packetListener.a(packet);
        }
    }

    private List<Packet<?>> getSpawnPackets() {
        Location finalLocation = this.limb.getPosition().toLocation(this.limb.getModel().getBase().getWorld());
        this.cloud.e(finalLocation.getX(), finalLocation.getY(), finalLocation.getZ());
        this.armorStand.b(finalLocation.getX(), finalLocation.getY() + this.cloud.bv() + this.armorStand.bu(), finalLocation.getZ(), this.limb.getModel().getBaseYaw(), 0.0f);
        PacketPlayOutSpawnEntity asSpawn = new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)this.armorStand);
        PacketPlayOutEntityMetadata asMeta = new PacketPlayOutEntityMetadata(this.armorStand.af(), this.armorStand.aj().c());
        PacketPlayOutEntityEquipment asEquip = new PacketPlayOutEntityEquipment(this.armorStand.af(), this.equipments);
        PacketPlayOutSpawnEntity aecSpawn = new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)this.cloud);
        PacketPlayOutEntityMetadata aecMeta = new PacketPlayOutEntityMetadata(this.cloud.af(), this.cloud.aj().c());
        PacketPlayOutMount mount = new PacketPlayOutMount((net.minecraft.world.entity.Entity)this.cloud);
        return Arrays.asList(asSpawn, asMeta, asEquip, aecSpawn, aecMeta, mount);
    }

    private List<Packet<?>> getDespawnPackets() {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.armorStand.af(), this.cloud.af()});
        return List.of(remove);
    }

    private List<Packet<?>> getMovePackets() {
        Location finalLocation = this.limb.getPosition().toLocation(this.limb.getModel().getBase().getWorld());
        EulerAngle finalRotation = this.limb.getRotation();
        this.cloud.e(finalLocation.getX(), finalLocation.getY(), finalLocation.getZ());
        if (this.limb.getType() == LimbType.LEFT_ITEM) {
            this.armorStand.c(this.toNMS(finalRotation));
        } else {
            this.armorStand.d(this.toNMS(finalRotation));
        }
        PacketPlayOutEntityTeleport teleport = new PacketPlayOutEntityTeleport((net.minecraft.world.entity.Entity)this.cloud);
        PacketPlayOutEntity.PacketPlayOutEntityLook rotate = new PacketPlayOutEntity.PacketPlayOutEntityLook(this.armorStand.af(), IRenderer.rotByte(this.limb.getModel().getBaseYaw()), 0, false);
        PacketPlayOutEntityMetadata meta = new PacketPlayOutEntityMetadata(this.armorStand.af(), this.armorStand.aj().c());
        return Arrays.asList(teleport, rotate, meta);
    }

    private Vector3f toNMS(EulerAngle angle) {
        return new Vector3f((float)Math.toDegrees(angle.getX()), (float)Math.toDegrees(angle.getY()), (float)Math.toDegrees(angle.getZ()));
    }
}

