/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.playeranimator.nms.v1_19_R1.network;

import com.ticxo.playeranimator.api.PlayerAnimator;
import com.ticxo.playeranimator.api.model.player.PlayerModel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PAChannelHandler
extends ChannelDuplexHandler {
    private final EntityPlayer player;

    public PAChannelHandler(EntityPlayer player) {
        this.player = player;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        Object object = msg;
        if (object instanceof PacketPlayOutSpawnEntity) {
            PacketPlayOutSpawnEntity packet = (PacketPlayOutSpawnEntity)object;
            this.handleEntitySpawn(packet.b());
        } else {
            object = msg;
            if (object instanceof PacketPlayOutNamedEntitySpawn) {
                PacketPlayOutNamedEntitySpawn packet = (PacketPlayOutNamedEntitySpawn)object;
                this.handleEntitySpawn(packet.b());
            } else {
                object = msg;
                if (object instanceof PacketPlayOutEntityDestroy) {
                    PacketPlayOutEntityDestroy packet = (PacketPlayOutEntityDestroy)object;
                    object = packet.b().iterator();
                    while (object.hasNext()) {
                        int id = (Integer)object.next();
                        this.handleEntityDespawn(id);
                    }
                }
            }
        }
        super.write(ctx, msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        super.channelRead(ctx, msg);
    }

    private void handleEntitySpawn(int id) {
        Entity entity = this.getEntityAsync(this.player.x(), id);
        PlayerModel model = PlayerAnimator.api.getModelManager().getPlayerModel(entity);
        if (model == null) {
            return;
        }
        model.spawn((Player)this.player.getBukkitEntity());
    }

    private void handleEntityDespawn(int id) {
        Entity entity = this.getEntityAsync(this.player.x(), id);
        PlayerModel model = PlayerAnimator.api.getModelManager().getPlayerModel(entity);
        if (model == null) {
            return;
        }
        model.despawn((Player)this.player.getBukkitEntity());
    }

    private Entity getEntityAsync(WorldServer world, int id) {
        PersistentEntitySectionManager entityManager = world.P;
        net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)entityManager.d().a(id);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }
}

