/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.playeranimator.api.model.player;

import com.ticxo.playeranimator.api.animation.pack.Bone;
import com.ticxo.playeranimator.api.model.player.LimbType;
import com.ticxo.playeranimator.api.model.player.PlayerBone;
import com.ticxo.playeranimator.api.model.player.PlayerModel;
import com.ticxo.playeranimator.api.utils.math.Offset;
import com.ticxo.playeranimator.api.utils.math.TMath;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class PlayerItemBone
extends PlayerBone {
    private static final Vector left = new Vector(-0.616, 0.0, 0.0);
    private boolean isLeft = false;

    public PlayerItemBone(PlayerModel model, Bone bone, LimbType type) {
        super(model, bone, type);
        if (type == LimbType.LEFT_ITEM) {
            this.isLeft = true;
        }
    }

    @Override
    public void update() {
        Vector fPosition = this.model.getAnimationProperty().getPositionFrame(this.bone.getName());
        EulerAngle fRotation = this.model.getAnimationProperty().getRotationFrame(this.bone.getName());
        Vector pPosition = this.parent == null ? this.getModel().getBaseVector() : this.parent.getPosition();
        EulerAngle pRotation = this.parent == null ? EulerAngle.ZERO : this.parent.getRotation();
        fPosition = Offset.getRelativeLocation(pRotation, fPosition.add(this.getBone().getOrigin()));
        fRotation = TMath.globalRotate(this.getBone().getRotation(), fRotation);
        if (this.parent == null) {
            fPosition.add(LimbType.base);
        }
        if (this.isLeft) {
            fPosition.add(left);
        }
        fPosition = Offset.rotateYaw(fPosition, Math.toRadians(this.getModel().getBase().getLocation().getYaw()));
        this.position = pPosition.add(fPosition);
        this.rotation = TMath.localRotate(pRotation, fRotation);
        for (PlayerBone bone : this.children.values()) {
            bone.update();
        }
    }
}

