/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.playeranimator.api.model.player;

import com.ticxo.playeranimator.api.animation.pack.Bone;
import com.ticxo.playeranimator.api.model.player.LimbType;
import com.ticxo.playeranimator.api.model.player.PlayerModel;
import com.ticxo.playeranimator.api.utils.math.Offset;
import com.ticxo.playeranimator.api.utils.math.TMath;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class PlayerBone {
    protected final Map<String, PlayerBone> children = new HashMap<String, PlayerBone>();
    protected final PlayerModel model;
    protected final Bone bone;
    protected final LimbType type;
    protected PlayerBone parent;
    protected Vector position = new Vector();
    protected EulerAngle rotation = EulerAngle.ZERO;

    public PlayerBone(PlayerModel model, Bone bone) {
        this(model, bone, null);
    }

    public PlayerBone(PlayerModel model, Bone bone, LimbType type) {
        this.model = model;
        this.bone = bone;
        this.type = type;
    }

    public void update() {
        Vector fPosition = this.model.getAnimationProperty().getPositionFrame(this.bone.getName());
        EulerAngle fRotation = this.model.getAnimationProperty().getRotationFrame(this.bone.getName());
        Vector pPosition = this.parent == null ? this.getModel().getBaseVector() : this.parent.getPosition();
        EulerAngle pRotation = this.parent == null ? EulerAngle.ZERO : this.parent.getRotation();
        fPosition = Offset.getRelativeLocation(pRotation, fPosition.add(this.getBone().getOrigin()));
        fRotation = TMath.globalRotate(this.getBone().getRotation(), fRotation);
        if (this.parent == null) {
            fPosition.add(LimbType.base);
        }
        fPosition = Offset.rotateYaw(fPosition, Math.toRadians(this.getModel().getBaseYaw()));
        this.position = pPosition.add(fPosition);
        this.rotation = TMath.localRotate(pRotation, fRotation);
        for (PlayerBone bone : this.children.values()) {
            bone.update();
        }
    }

    public void addChild(PlayerBone bone) {
        bone.setParent(this);
        this.children.put(bone.getBone().getName(), bone);
    }

    public Vector getPosition() {
        return this.position.clone();
    }

    public PlayerModel getModel() {
        return this.model;
    }

    public Bone getBone() {
        return this.bone;
    }

    public LimbType getType() {
        return this.type;
    }

    public PlayerBone getParent() {
        return this.parent;
    }

    public void setParent(PlayerBone parent) {
        this.parent = parent;
    }

    public EulerAngle getRotation() {
        return this.rotation;
    }
}

