/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.playeranimator.api.animation.pack;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.ticxo.playeranimator.api.animation.animation.Animation;
import com.ticxo.playeranimator.api.animation.animation.LoopMode;
import com.ticxo.playeranimator.api.animation.animation.Timeline;
import com.ticxo.playeranimator.api.animation.keyframe.KeyframeType;
import com.ticxo.playeranimator.api.animation.pack.AnimationPack;
import com.ticxo.playeranimator.api.animation.pack.Bone;
import com.ticxo.playeranimator.api.utils.math.TMath;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class AnimationPackDeserializer
implements JsonDeserializer<AnimationPack> {
    public AnimationPack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jObj = json.getAsJsonObject();
        AnimationPack pack = new AnimationPack();
        if (jObj.has("outliner")) {
            for (JsonElement element : jObj.getAsJsonArray("outliner")) {
                if (!element.isJsonObject()) continue;
                Bone bone = this.getBone(null, element);
                pack.getBones().add(bone);
            }
        }
        if (jObj.has("animations")) {
            for (JsonElement element : jObj.getAsJsonArray("animations")) {
                Animation animation = this.getAnimation(element);
                pack.registerAnimation(animation);
            }
        }
        return pack;
    }

    private Bone getBone(Bone parent, JsonElement json) {
        EulerAngle rotation;
        Vector origin;
        JsonArray array;
        JsonObject jObj = json.getAsJsonObject();
        String name = jObj.get("name").getAsString();
        if (jObj.has("origin")) {
            array = jObj.get("origin").getAsJsonArray();
            origin = new Vector(-array.get(0).getAsDouble(), array.get(1).getAsDouble(), -array.get(2).getAsDouble()).multiply(0.0625);
        } else {
            origin = new Vector();
        }
        if (jObj.has("rotation")) {
            array = jObj.get("rotation").getAsJsonArray();
            rotation = TMath.makeAngle(array.get(0).getAsDouble(), array.get(1).getAsDouble(), array.get(2).getAsDouble());
        } else {
            rotation = EulerAngle.ZERO;
        }
        Bone bone = new Bone(name, origin, rotation);
        for (JsonElement element : jObj.getAsJsonArray("children")) {
            if (!element.isJsonObject()) continue;
            Bone child = this.getBone(bone, element);
            bone.getChildren().add(child);
        }
        if (parent != null) {
            bone.getOrigin().subtract(parent.getOrigin());
        }
        return bone;
    }

    private Animation getAnimation(JsonElement element) {
        JsonObject jObj = element.getAsJsonObject();
        String name = jObj.get("name").getAsString();
        Animation animation = new Animation(name);
        if (jObj.has("loop")) {
            animation.setLoopMode(LoopMode.get(jObj.get("loop").getAsString()));
        }
        if (jObj.has("override")) {
            animation.setOverride(jObj.get("override").getAsBoolean());
        }
        if (jObj.has("length")) {
            animation.setLength(jObj.get("length").getAsFloat());
        }
        if (jObj.has("animators")) {
            JsonObject animators = jObj.get("animators").getAsJsonObject();
            for (Map.Entry entry : animators.entrySet()) {
                JsonObject bone = ((JsonElement)entry.getValue()).getAsJsonObject();
                String type = bone.get("type").getAsString();
                if (!"bone".equals(type)) continue;
                String boneName = bone.get("name").getAsString();
                Timeline timeline = animation.getOrCreateTimeline(boneName);
                this.configureTimeline(timeline, bone.get("keyframes"));
            }
        }
        return animation;
    }

    private void configureTimeline(Timeline timeline, JsonElement element) {
        JsonArray keyframes = element.getAsJsonArray();
        for (JsonElement ele : keyframes) {
            JsonObject key = ele.getAsJsonObject();
            if (!key.has("channel") || !key.has("data_points") || !key.has("time")) continue;
            String channel = key.get("channel").getAsString();
            JsonObject data = key.get("data_points").getAsJsonArray().get(0).getAsJsonObject();
            double[] values = new double[]{Double.parseDouble(data.get("x").getAsString()), Double.parseDouble(data.get("y").getAsString()), Double.parseDouble(data.get("z").getAsString())};
            double time = key.get("time").getAsDouble();
            KeyframeType type = this.getType(key.get("interpolation").getAsString());
            switch (channel) {
                case "rotation": {
                    timeline.addRotationFrame(time, TMath.makeAngle(values[0], values[1], values[2]), type);
                    break;
                }
                case "position": {
                    timeline.addPositionFrame(time, new Vector(values[0], values[1], -values[2]).multiply(0.0625), type);
                }
            }
        }
    }

    private KeyframeType getType(String type) {
        switch (type.toLowerCase(Locale.ENGLISH)) {
            case "linear": {
                return KeyframeType.LINEAR;
            }
            case "catmullrom": {
                return KeyframeType.SMOOTH;
            }
            case "step": {
                return KeyframeType.STEP;
            }
        }
        return KeyframeType.LINEAR;
    }
}

