/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.playeranimator.api.animation.animation;

import com.ticxo.playeranimator.api.animation.keyframe.AbstractKeyframe;
import com.ticxo.playeranimator.api.animation.keyframe.KeyframeType;
import com.ticxo.playeranimator.api.animation.keyframe.PositionKeyframe;
import com.ticxo.playeranimator.api.animation.keyframe.RotationKeyframe;
import com.ticxo.playeranimator.api.utils.math.TMath;
import java.util.TreeMap;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class Timeline {
    private final TreeMap<Double, PositionKeyframe> position = new TreeMap();
    private final TreeMap<Double, RotationKeyframe> rotation = new TreeMap();

    public void addPositionFrame(double frame, Vector vector, KeyframeType type) {
        this.position.put(frame, new PositionKeyframe(vector, type));
    }

    public void addRotationFrame(double frame, EulerAngle angle, KeyframeType type) {
        this.rotation.put(frame, new RotationKeyframe(angle, type));
    }

    public Vector getPositionFrame(double time) {
        double lastTime;
        if (this.position.isEmpty()) {
            return new Vector();
        }
        if (this.position.containsKey(time)) {
            return ((Vector)this.position.get(time).getValue()).clone();
        }
        double nextTime = this.getHigherKey(this.position, time);
        if (nextTime == (lastTime = this.getLowerKey(this.position, time))) {
            return ((Vector)this.position.get(lastTime).getValue()).clone();
        }
        double t = (time - lastTime) / (nextTime - lastTime);
        PositionKeyframe nextVector = this.position.get(nextTime);
        PositionKeyframe lastVector = this.position.get(lastTime);
        switch (this.getType(lastVector, nextVector)) {
            case LINEAR: {
                return TMath.lerp((Vector)lastVector.getValue(), (Vector)nextVector.getValue(), t);
            }
            case SMOOTH: {
                double nextControlTime = this.getHigherKey(this.position, nextTime);
                double lastControlTime = this.getLowerKey(this.position, lastTime);
                PositionKeyframe nextControlVector = this.position.get(nextControlTime);
                PositionKeyframe lastControlVector = this.position.get(lastControlTime);
                return TMath.smoothLerp((Vector)lastControlVector.getValue(), (Vector)lastVector.getValue(), (Vector)nextVector.getValue(), (Vector)nextControlVector.getValue(), t);
            }
            case STEP: {
                return ((Vector)lastVector.getValue()).clone();
            }
        }
        return TMath.lerp((Vector)lastVector.getValue(), (Vector)nextVector.getValue(), t);
    }

    public EulerAngle getRotationFrame(double time) {
        double lastTime;
        if (this.rotation.isEmpty()) {
            return EulerAngle.ZERO;
        }
        if (this.rotation.containsKey(time)) {
            return (EulerAngle)this.rotation.get(time).getValue();
        }
        double nextTime = this.getHigherKey(this.rotation, time);
        if (nextTime == (lastTime = this.getLowerKey(this.rotation, time))) {
            return (EulerAngle)this.rotation.get(lastTime).getValue();
        }
        double t = (time - lastTime) / (nextTime - lastTime);
        RotationKeyframe nextAngle = this.rotation.get(nextTime);
        RotationKeyframe lastAngle = this.rotation.get(lastTime);
        switch (this.getType(lastAngle, nextAngle)) {
            case LINEAR: {
                return TMath.lerp((EulerAngle)lastAngle.getValue(), (EulerAngle)nextAngle.getValue(), t);
            }
            case SMOOTH: {
                double nextControlTime = this.getHigherKey(this.rotation, nextTime);
                double lastControlTime = this.getLowerKey(this.rotation, lastTime);
                RotationKeyframe nextControlAngle = this.rotation.get(nextControlTime);
                RotationKeyframe lastControlAngle = this.rotation.get(lastControlTime);
                return TMath.smoothLerp((EulerAngle)lastControlAngle.getValue(), (EulerAngle)lastAngle.getValue(), (EulerAngle)nextAngle.getValue(), (EulerAngle)nextControlAngle.getValue(), t);
            }
            case STEP: {
                return (EulerAngle)lastAngle.getValue();
            }
        }
        return TMath.lerp((EulerAngle)lastAngle.getValue(), (EulerAngle)nextAngle.getValue(), t);
    }

    private double getHigherKey(TreeMap<Double, ?> map, double time) {
        Double high = map.higherKey(time);
        if (high == null) {
            return map.lastKey();
        }
        return high;
    }

    private double getLowerKey(TreeMap<Double, ?> map, double time) {
        Double low = map.lowerKey(time);
        if (low == null) {
            return map.firstKey();
        }
        return low;
    }

    private KeyframeType getType(AbstractKeyframe<?> last, AbstractKeyframe<?> next) {
        if (last.getType() == KeyframeType.STEP) {
            return KeyframeType.STEP;
        }
        if (last.getType() == KeyframeType.SMOOTH || next.getType() == KeyframeType.SMOOTH) {
            return KeyframeType.SMOOTH;
        }
        return KeyframeType.LINEAR;
    }
}

