/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.playeranimator.api.model;

import com.ticxo.playeranimator.api.PlayerAnimatorPlugin;
import com.ticxo.playeranimator.api.model.player.PlayerModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ModelManager {
    private final Map<Entity, PlayerModel> models = new HashMap<Entity, PlayerModel>();
    private BukkitRunnable ticker;

    public void activate() {
        if (this.ticker != null) {
            this.ticker.cancel();
        }
        this.ticker = new BukkitRunnable(){

            public void run() {
                Iterator<Entity> i = ModelManager.this.models.keySet().iterator();
                while (i.hasNext()) {
                    PlayerModel model = ModelManager.this.models.get(i.next());
                    if (model.update()) continue;
                    i.remove();
                    model.despawn();
                }
            }
        };
        this.ticker.runTaskTimerAsynchronously((Plugin)PlayerAnimatorPlugin.plugin, 0L, 1L);
    }

    public void registerModel(PlayerModel model) {
        this.models.put(model.getBase(), model);
    }

    public void unregisterModel(PlayerModel model) {
        this.unregisterModel(model.getBase());
    }

    public void unregisterModel(Entity entity) {
        this.models.remove(entity);
    }

    public PlayerModel getPlayerModel(Entity entity) {
        return this.models.get(entity);
    }
}

