/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.playeranimator.api.animation.time;

import com.ticxo.playeranimator.api.animation.animation.Animation;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class AnimationProperty {
    private final Animation animation;
    private double time = 0.0;
    private double speed;

    public AnimationProperty(Animation animation) {
        this(animation, 1.0);
    }

    public AnimationProperty(Animation animation, double speed) {
        this.animation = animation;
        this.speed = speed;
    }

    public boolean updateTime() {
        switch (this.animation.getLoopMode()) {
            case ONCE: {
                if (!(this.time < this.animation.getLength())) break;
                this.time = Math.min(this.time + this.speed / 20.0, this.animation.getLength());
                return true;
            }
            case HOLD: {
                this.time = Math.min(this.time + this.speed / 20.0, this.animation.getLength());
                return true;
            }
            case LOOP: {
                this.time = (this.time + this.speed / 20.0) % this.animation.getLength();
                return true;
            }
        }
        return false;
    }

    public Vector getPositionFrame(String bone) {
        return this.animation.getPosition(bone, this.time);
    }

    public EulerAngle getRotationFrame(String bone) {
        return this.animation.getRotation(bone, this.time);
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public double getTime() {
        return this.time;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }
}

