/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.playeranimator.api.animation.animation;

import com.ticxo.playeranimator.api.animation.animation.LoopMode;
import com.ticxo.playeranimator.api.animation.animation.Timeline;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class Animation {
    private final Map<String, Timeline> timelines = new HashMap<String, Timeline>();
    private final String name;
    private double length;
    private LoopMode loopMode;
    private boolean override;

    public Animation(String name) {
        this.name = name;
    }

    public Timeline getOrCreateTimeline(String bone) {
        if (this.timelines.containsKey(bone)) {
            return this.timelines.get(bone);
        }
        Timeline timeline = new Timeline();
        this.timelines.put(bone, timeline);
        return timeline;
    }

    public Vector getPosition(String bone, double time) {
        if (!this.timelines.containsKey(bone)) {
            return new Vector();
        }
        return this.timelines.get(bone).getPositionFrame(time);
    }

    public EulerAngle getRotation(String bone, double time) {
        if (!this.timelines.containsKey(bone)) {
            return EulerAngle.ZERO;
        }
        return this.timelines.get(bone).getRotationFrame(time);
    }

    public String getName() {
        return this.name;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public LoopMode getLoopMode() {
        return this.loopMode;
    }

    public void setLoopMode(LoopMode loopMode) {
        this.loopMode = loopMode;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }
}

