/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.services;

import io.leangen.geantyref.TypeToken;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.services.PipelineException;
import org.incendo.cloud.services.ServiceFilterHandler;
import org.incendo.cloud.services.ServicePipeline;
import org.incendo.cloud.services.ServicePump;
import org.incendo.cloud.services.ServiceRepository;
import org.incendo.cloud.services.State;
import org.incendo.cloud.services.type.ConsumerService;
import org.incendo.cloud.services.type.Service;
import org.incendo.cloud.services.type.SideEffectService;

public final class ServiceSpigot<Context, Result> {
    private final Context context;
    private final ServicePipeline pipeline;
    private final ServiceRepository<Context, Result> repository;

    ServiceSpigot(@NonNull ServicePipeline pipeline, @NonNull Context context, @NonNull TypeToken<? extends Service<@NonNull Context, @NonNull Result>> type) {
        this.context = context;
        this.pipeline = pipeline;
        this.repository = pipeline.getRepository(type);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Result complete() throws IllegalStateException, PipelineException {
        ServiceRepository.ServiceWrapper<Service<Context, Result>> wrapper;
        LinkedList<@NonNull @NonNull ServiceRepository. @NonNull @NonNull ServiceWrapper<Service<Context, Result>>> queue = this.repository.queue();
        queue.sort(null);
        boolean consumerService = false;
        while ((wrapper = queue.pollLast()) != null) {
            Result result;
            consumerService = wrapper.implementation() instanceof ConsumerService;
            if (!ServiceFilterHandler.INSTANCE.passes(wrapper, this.context)) continue;
            try {
                result = wrapper.implementation().handle(this.context);
            }
            catch (Exception e) {
                throw new PipelineException(String.format("Failed to retrieve result from %s", wrapper), e);
            }
            if (wrapper.implementation() instanceof SideEffectService) {
                if (result == null) {
                    throw new IllegalStateException(String.format("SideEffectService '%s' returned null", wrapper));
                }
                if (result != State.ACCEPTED) continue;
                return result;
            }
            if (result == null) continue;
            return result;
        }
        if (consumerService) {
            return (Result)((Object)State.ACCEPTED);
        }
        throw new IllegalStateException("No service consumed the context. This means that the pipeline was not constructed properly.");
    }

    public void complete(@NonNull BiConsumer<Result, Throwable> consumer) {
        try {
            consumer.accept(this.complete(), null);
        }
        catch (PipelineException pipelineException) {
            consumer.accept(null, pipelineException.getCause());
        }
        catch (Exception e) {
            consumer.accept(null, e);
        }
    }

    public @NonNull CompletableFuture<Result> completeAsynchronously() {
        return CompletableFuture.supplyAsync(this::complete, this.pipeline.executor());
    }

    public @NonNull ServicePump<Result> forward() {
        return this.pipeline.pump(this.complete());
    }

    public @NonNull CompletableFuture<ServicePump<Result>> forwardAsynchronously() {
        return this.completeAsynchronously().thenApply(this.pipeline::pump);
    }
}

