/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.permission;

import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.immutables.value.Value;
import org.incendo.cloud.permission.Permission;
import org.incendo.cloud.permission.PermissionResultImpl;

@API(status=API.Status.STABLE)
@Value.Immutable
public interface PermissionResult {
    public boolean allowed();

    default public boolean denied() {
        return !this.allowed();
    }

    public @NonNull Permission permission();

    public static @NonNull PermissionResult of(boolean result, @NonNull Permission permission) {
        return PermissionResultImpl.of(result, permission);
    }

    public static @NonNull PermissionResult allowed(@NonNull Permission permission) {
        return PermissionResultImpl.of(true, permission);
    }

    public static @NonNull PermissionResult denied(@NonNull Permission permission) {
        return PermissionResultImpl.of(false, permission);
    }
}

