/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_properties.server;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.world_properties.WorldPropertyDataType;
import com.moulberry.axiom.world_properties.WorldPropertyWidgetType;
import com.moulberry.axiom.world_properties.server.PropertyUpdateResult;
import com.moulberry.axiom.world_properties.server.ServerWorldPropertiesRegistry;
import com.moulberry.axiom.world_properties.server.ServerWorldPropertyHolder;
import net.minecraft.resources.MinecraftKey;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Player;

public abstract class ServerWorldPropertyBase<T> {
    private final MinecraftKey id;
    final String name;
    final boolean localizeName;
    WorldPropertyWidgetType<T> widget;

    public ServerWorldPropertyBase(NamespacedKey id, String name, boolean localizeName, WorldPropertyWidgetType<T> widget) {
        this.id = CraftNamespacedKey.toMinecraft((NamespacedKey)id);
        this.name = name;
        this.localizeName = localizeName;
        this.widget = widget;
    }

    public abstract T getDefaultValue(World var1);

    public abstract PropertyUpdateResult handleUpdateProperty(Player var1, World var2, T var3);

    public MinecraftKey getId() {
        return this.id;
    }

    public WorldPropertyDataType<T> getType() {
        return this.widget.dataType();
    }

    public boolean setValueWithoutSyncing(World world, T value) {
        ServerWorldPropertyHolder<?> property;
        ServerWorldPropertiesRegistry properties = AxiomPaper.PLUGIN.getWorldPropertiesIfPresent(world);
        if (properties != null && (property = properties.getById(this.id)) != null && property.getProperty() == this) {
            property.setValueWithoutSyncing(value);
            return true;
        }
        return false;
    }

    public boolean setValue(World world, T value) {
        ServerWorldPropertyHolder<?> property;
        ServerWorldPropertiesRegistry properties = AxiomPaper.PLUGIN.getWorldPropertiesIfPresent(world);
        if (properties != null && (property = properties.getById(this.id)) != null && property.getProperty() == this) {
            property.setValue(world, value);
            return true;
        }
        return false;
    }
}

