/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_properties.server;

import com.moulberry.axiom.world_properties.WorldPropertyCategory;
import com.moulberry.axiom.world_properties.WorldPropertyWidgetType;
import com.moulberry.axiom.world_properties.server.PropertyUpdateResult;
import com.moulberry.axiom.world_properties.server.ServerWorldProperty;
import com.moulberry.axiom.world_properties.server.ServerWorldPropertyBase;
import com.moulberry.axiom.world_properties.server.ServerWorldPropertyHolder;
import io.netty.buffer.Unpooled;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import org.bukkit.GameRule;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ServerWorldPropertiesRegistry {
    private final LinkedHashMap<WorldPropertyCategory, List<ServerWorldPropertyHolder<?>>> propertyList = new LinkedHashMap();
    private final Map<MinecraftKey, ServerWorldPropertyHolder<?>> propertyMap = new HashMap();
    private final Reference<World> world;
    private static final ServerWorldProperty<Integer> TIME = new ServerWorldProperty<Integer>(new NamespacedKey("axiom", "time"), "axiom.editorui.window.world_properties.time", true, WorldPropertyWidgetType.TIME, world -> 0, (player, w, integer) -> PropertyUpdateResult.UPDATE_WITHOUT_SYNC);
    public static final ServerWorldProperty<Boolean> PAUSE_WEATHER = new ServerWorldProperty<Boolean>(new NamespacedKey("axiom", "pause_weather"), "axiom.editorui.window.world_properties.pause_weather", true, WorldPropertyWidgetType.CHECKBOX, world -> (Boolean)world.getGameRuleValue(GameRule.DO_WEATHER_CYCLE) == false, (player, world, bool) -> {
        world.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)(bool == false ? 1 : 0));
        return PropertyUpdateResult.UPDATE_WITHOUT_SYNC;
    });
    private static final ServerWorldProperty<Integer> WEATHER_TYPE = new ServerWorldProperty<Integer>(new NamespacedKey("axiom", "weather_type"), "axiom.editorui.window.world_properties.clear_weather", true, new WorldPropertyWidgetType.ButtonArray(List.of("axiom.editorui.window.world_properties.rain_weather", "axiom.editorui.window.world_properties.thunder_weather")), world -> 0, (player, world, index) -> {
        WorldServer serverLevel = ((CraftWorld)world).getHandle();
        if (index == 0) {
            serverLevel.a(WorldServer.b.a(serverLevel.z), 0, false, false);
        } else if (index == 1) {
            serverLevel.a(0, WorldServer.c.a(serverLevel.z), true, false);
        } else if (index == 2) {
            serverLevel.a(0, WorldServer.d.a(serverLevel.z), true, true);
        }
        return PropertyUpdateResult.UPDATE_WITHOUT_SYNC;
    });

    public ServerWorldPropertiesRegistry(Reference<World> world) {
        this.world = world;
        this.registerDefault();
    }

    public ServerWorldPropertyHolder<?> getById(MinecraftKey resourceLocation) {
        return this.propertyMap.get(resourceLocation);
    }

    public void addCategory(WorldPropertyCategory category, List<ServerWorldPropertyBase<?>> properties) {
        World world = this.world.get();
        if (world == null) {
            return;
        }
        ArrayList holders = new ArrayList();
        for (ServerWorldPropertyBase<?> serverWorldPropertyBase : properties) {
            Object defaultValue = serverWorldPropertyBase.getDefaultValue(world);
            holders.add(new ServerWorldPropertyHolder(defaultValue, serverWorldPropertyBase));
        }
        this.propertyList.put(category, holders);
        for (ServerWorldPropertyHolder serverWorldPropertyHolder : holders) {
            MinecraftKey id = serverWorldPropertyHolder.getId();
            if (this.propertyMap.containsKey(id)) {
                throw new RuntimeException("Duplicate property: " + String.valueOf(id));
            }
            this.propertyMap.put(id, serverWorldPropertyHolder);
        }
    }

    public void registerFor(Plugin plugin, Player bukkitPlayer) {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.c(this.propertyList.size());
        for (Map.Entry<WorldPropertyCategory, List<ServerWorldPropertyHolder<?>>> entry : this.propertyList.entrySet()) {
            entry.getKey().write(buf);
            buf.a((Collection)entry.getValue(), (buffer, p) -> p.write((PacketDataSerializer)buffer));
        }
        byte[] bytes = new byte[buf.writerIndex()];
        buf.a(0, bytes);
        bukkitPlayer.sendPluginMessage(plugin, "axiom:register_world_properties", bytes);
    }

    public void registerDefault() {
        WorldPropertyCategory timeCategory = new WorldPropertyCategory("axiom.editorui.window.world_properties.time", true);
        this.addCategory(timeCategory, List.of(TIME));
        WorldPropertyCategory weatherCategory = new WorldPropertyCategory("axiom.editorui.window.world_properties.weather", true);
        this.addCategory(weatherCategory, List.of(PAUSE_WEATHER, WEATHER_TYPE));
    }
}

