/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_properties;

import com.moulberry.axiom.world_properties.WorldPropertyDataType;
import java.util.List;
import net.minecraft.network.PacketDataSerializer;

public interface WorldPropertyWidgetType<T> {
    public static final WorldPropertyWidgetType<Boolean> CHECKBOX = new WorldPropertyWidgetType<Boolean>(){

        @Override
        public WorldPropertyDataType<Boolean> dataType() {
            return WorldPropertyDataType.BOOLEAN;
        }

        @Override
        public void write(PacketDataSerializer friendlyByteBuf) {
            friendlyByteBuf.c(0);
        }
    };
    public static final WorldPropertyWidgetType<String> TEXTBOX = new WorldPropertyWidgetType<String>(){

        @Override
        public WorldPropertyDataType<String> dataType() {
            return WorldPropertyDataType.STRING;
        }

        @Override
        public void write(PacketDataSerializer friendlyByteBuf) {
            friendlyByteBuf.c(2);
        }
    };
    public static final WorldPropertyWidgetType<Integer> TIME = new WorldPropertyWidgetType<Integer>(){

        @Override
        public WorldPropertyDataType<Integer> dataType() {
            return WorldPropertyDataType.INTEGER;
        }

        @Override
        public void write(PacketDataSerializer friendlyByteBuf) {
            friendlyByteBuf.c(3);
        }
    };
    public static final WorldPropertyWidgetType<Void> BUTTON = new WorldPropertyWidgetType<Void>(){

        @Override
        public WorldPropertyDataType<Void> dataType() {
            return WorldPropertyDataType.EMPTY;
        }

        @Override
        public void write(PacketDataSerializer friendlyByteBuf) {
            friendlyByteBuf.c(4);
        }
    };

    public WorldPropertyDataType<T> dataType();

    public void write(PacketDataSerializer var1);

    public record ButtonArray(List<String> otherButtons) implements WorldPropertyWidgetType<Integer>
    {
        @Override
        public WorldPropertyDataType<Integer> dataType() {
            return WorldPropertyDataType.INTEGER;
        }

        @Override
        public void write(PacketDataSerializer friendlyByteBuf) {
            friendlyByteBuf.c(5);
            friendlyByteBuf.a(this.otherButtons, PacketDataSerializer::a);
        }
    }

    public record Slider(int min, int max) implements WorldPropertyWidgetType<Integer>
    {
        @Override
        public WorldPropertyDataType<Integer> dataType() {
            return WorldPropertyDataType.INTEGER;
        }

        @Override
        public void write(PacketDataSerializer friendlyByteBuf) {
            friendlyByteBuf.c(1);
            friendlyByteBuf.p(this.min);
            friendlyByteBuf.p(this.max);
        }
    }
}

