/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.viaversion;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.buffer.BlockBuffer;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.data.MappingData;
import com.viaversion.viaversion.api.data.Mappings;
import com.viaversion.viaversion.api.protocol.ProtocolPathEntry;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.SharedConstants;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.Player;

public class ViaVersionHelper {
    private static final Int2ObjectOpenHashMap<RegistryBlockID<IBlockData>> blockRegistryCache = new Int2ObjectOpenHashMap();
    private static final Int2ObjectOpenHashMap<String> blockRegistryErrorCache = new Int2ObjectOpenHashMap();
    private static final int UNNAMED_COMPOUND_TAG_CHANGE_VERSION = 764;

    public static RegistryBlockID<IBlockData> getBlockRegistryForVersion(RegistryBlockID<IBlockData> mapper, int playerVersion) {
        if (blockRegistryErrorCache.containsKey(playerVersion)) {
            throw new RuntimeException((String)blockRegistryErrorCache.get(playerVersion));
        }
        if (blockRegistryCache.containsKey(playerVersion)) {
            return (RegistryBlockID)blockRegistryCache.get(playerVersion);
        }
        List path = Via.getManager().getProtocolManager().getProtocolPath(playerVersion, SharedConstants.c());
        if (path == null) {
            blockRegistryErrorCache.put(playerVersion, (Object)"Failed to find protocol path");
            throw new RuntimeException("Failed to find protocol path");
        }
        for (int i = path.size() - 1; i >= 0; --i) {
            ProtocolPathEntry protocolPathEntry = (ProtocolPathEntry)path.get(i);
            MappingData mappingData = protocolPathEntry.protocol().getMappingData();
            if (mappingData == null) {
                blockRegistryErrorCache.put(playerVersion, (Object)("Failed to load mapping data (" + String.valueOf(protocolPathEntry) + ")"));
                throw new RuntimeException("Failed to load mapping data (" + String.valueOf(protocolPathEntry) + ")");
            }
            Mappings blockStateMappings = mappingData.getBlockStateMappings();
            if (blockStateMappings == null) {
                blockRegistryErrorCache.put(playerVersion, (Object)("Failed to load BlockState mappings (" + String.valueOf(protocolPathEntry) + ")"));
                throw new RuntimeException("Failed to load BlockState mappings (" + String.valueOf(protocolPathEntry) + ")");
            }
            mapper = ViaVersionHelper.applyMappings(mapper, blockStateMappings);
        }
        blockRegistryCache.put(playerVersion, mapper);
        return mapper;
    }

    private static RegistryBlockID<IBlockData> applyMappings(RegistryBlockID<IBlockData> registry, Mappings mappings) {
        int i;
        RegistryBlockID newBlockRegistry = new RegistryBlockID();
        int size = mappings.mappedSize();
        for (i = 0; i < size; ++i) {
            newBlockRegistry.a((Object)BlockBuffer.EMPTY_STATE, i);
        }
        for (i = 0; i < registry.c(); ++i) {
            int newId;
            IBlockData blockState = (IBlockData)registry.a(i);
            if (blockState == null || (newId = mappings.getNewId(i)) < 0) continue;
            newBlockRegistry.a((Object)blockState, newId);
        }
        int newEmptyStateId = mappings.getNewId(registry.a((Object)BlockBuffer.EMPTY_STATE));
        if (newEmptyStateId >= 0) {
            newBlockRegistry.a((Object)BlockBuffer.EMPTY_STATE, newEmptyStateId);
        }
        return newBlockRegistry;
    }

    public static void skipTagViaVersion(PacketDataSerializer friendlyByteBuf, Player player) throws Exception {
        ViaVersionHelper.skipTagViaVersion(friendlyByteBuf, AxiomPaper.PLUGIN.getProtocolVersionFor(player.getUniqueId()));
    }

    public static void skipTagViaVersion(PacketDataSerializer friendlyByteBuf, int playerVersion) throws Exception {
        ViaVersionHelper.getTagType(playerVersion).read((ByteBuf)friendlyByteBuf);
    }

    public static NBTTagCompound readTagViaVersion(PacketDataSerializer friendlyByteBuf, Player player) throws Exception {
        return ViaVersionHelper.readTagViaVersion(friendlyByteBuf, AxiomPaper.PLUGIN.getProtocolVersionFor(player.getUniqueId()));
    }

    public static NBTTagCompound readTagViaVersion(PacketDataSerializer friendlyByteBuf, int playerVersion) throws Exception {
        Type<CompoundTag> from = ViaVersionHelper.getTagType(playerVersion);
        Type<CompoundTag> to = ViaVersionHelper.getTagType(SharedConstants.c());
        return ViaVersionHelper.readTagViaVersion(friendlyByteBuf, from, to);
    }

    private static Type<CompoundTag> getTagType(int version) {
        if (version < 764) {
            return Types.NAMED_COMPOUND_TAG;
        }
        return Types.COMPOUND_TAG;
    }

    private static NBTTagCompound readTagViaVersion(PacketDataSerializer friendlyByteBuf, Type<CompoundTag> from, Type<CompoundTag> to) throws Exception {
        if (from == to) {
            return friendlyByteBuf.o();
        }
        CompoundTag tag = (CompoundTag)from.read((ByteBuf)friendlyByteBuf);
        PacketDataSerializer buffer = new PacketDataSerializer(Unpooled.buffer());
        to.write((ByteBuf)buffer, (Object)tag);
        return buffer.o();
    }
}

