/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.persistence;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;

public class UUIDDataType
implements PersistentDataType<byte[], UUID> {
    public static UUIDDataType INSTANCE = new UUIDDataType();

    private UUIDDataType() {
    }

    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    public Class<UUID> getComplexType() {
        return UUID.class;
    }

    public byte[] toPrimitive(UUID complex, PersistentDataAdapterContext context) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(complex.getMostSignificantBits());
        bb.putLong(complex.getLeastSignificantBits());
        return bb.array();
    }

    public UUID fromPrimitive(byte[] primitive, PersistentDataAdapterContext context) {
        ByteBuffer bb = ByteBuffer.wrap(primitive);
        long firstLong = bb.getLong();
        long secondLong = bb.getLong();
        return new UUID(firstLong, secondLong);
    }
}

