/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.event.AxiomTeleportEvent;
import com.moulberry.axiom.event.AxiomUnknownTeleportEvent;
import io.netty.buffer.Unpooled;
import net.kyori.adventure.text.Component;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class TeleportPacketListener
implements PluginMessageListener {
    private final AxiomPaper plugin;

    public TeleportPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        try {
            this.process(player, message);
        }
        catch (Throwable t) {
            player.kick((Component)Component.text((String)("Error while processing packet " + channel + ": " + t.getMessage())));
        }
    }

    private void process(Player player, byte[] message) {
        if (!this.plugin.canUseAxiom(player, "axiom.world.teleport")) {
            return;
        }
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])message));
        ResourceKey resourceKey = friendlyByteBuf.a(Registries.ba);
        double x = friendlyByteBuf.readDouble();
        double y = friendlyByteBuf.readDouble();
        double z = friendlyByteBuf.readDouble();
        float yRot = friendlyByteBuf.readFloat();
        float xRot = friendlyByteBuf.readFloat();
        boolean allowTeleportBetweenWorlds = this.plugin.configuration.getBoolean("allow-teleport-between-worlds");
        if (!allowTeleportBetweenWorlds && !((CraftPlayer)player).getHandle().A().af().equals(resourceKey)) {
            return;
        }
        AxiomUnknownTeleportEvent preTeleportEvent = new AxiomUnknownTeleportEvent(player, CraftNamespacedKey.fromMinecraft((MinecraftKey)resourceKey.a()), x, y, z, yRot, xRot);
        Bukkit.getPluginManager().callEvent((Event)preTeleportEvent);
        if (preTeleportEvent.isCancelled()) {
            return;
        }
        NamespacedKey namespacedKey = new NamespacedKey(resourceKey.a().b(), resourceKey.a().a());
        World world = Bukkit.getWorld((NamespacedKey)namespacedKey);
        if (world == null) {
            return;
        }
        if (!allowTeleportBetweenWorlds && world != player.getWorld()) {
            return;
        }
        AxiomTeleportEvent teleportEvent = new AxiomTeleportEvent(player, new Location(world, x, y, z, yRot, xRot));
        Bukkit.getPluginManager().callEvent((Event)teleportEvent);
        if (teleportEvent.isCancelled()) {
            return;
        }
        player.teleport(new Location(world, x, y, z, yRot, xRot));
    }
}

