/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet;

import com.moulberry.axiom.AxiomConstants;
import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.persistence.ItemStackDataType;
import io.netty.buffer.Unpooled;
import net.kyori.adventure.text.Component;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class SwitchActiveHotbarPacketListener
implements PluginMessageListener {
    private final AxiomPaper plugin;

    public SwitchActiveHotbarPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        try {
            this.process(player, message);
        }
        catch (Throwable t) {
            player.kick((Component)Component.text((String)("Error while processing packet " + channel + ": " + t.getMessage())));
        }
    }

    private void process(Player player, byte[] message) {
        if (!this.plugin.canUseAxiom(player, "axiom.player.hotbar") || this.plugin.isMismatchedDataVersion(player.getUniqueId())) {
            return;
        }
        RegistryFriendlyByteBuf friendlyByteBuf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])message), ((CraftPlayer)player).getHandle().dQ());
        byte oldHotbarIndex = friendlyByteBuf.readByte();
        byte activeHotbarIndex = friendlyByteBuf.readByte();
        ItemStack[] hotbarItems = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            hotbarItems[i] = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.h.decode((Object)friendlyByteBuf)));
        }
        PersistentDataContainer container = player.getPersistentDataContainer();
        PersistentDataContainer containerHotbarItems = (PersistentDataContainer)container.get(AxiomConstants.HOTBAR_DATA, PersistentDataType.TAG_CONTAINER);
        if (containerHotbarItems == null) {
            containerHotbarItems = container.getAdapterContext().newPersistentDataContainer();
        }
        for (int i = 0; i < 9; ++i) {
            int index;
            if (oldHotbarIndex != activeHotbarIndex) {
                index = oldHotbarIndex * 9 + i;
                ItemStack stack = player.getInventory().getItem(i);
                stack = stack == null ? new ItemStack(Material.AIR) : stack.clone();
                containerHotbarItems.set(new NamespacedKey("axiom", "slot_" + index), (PersistentDataType)ItemStackDataType.INSTANCE, (Object)stack);
            }
            index = activeHotbarIndex * 9 + i;
            containerHotbarItems.set(new NamespacedKey("axiom", "slot_" + index), (PersistentDataType)ItemStackDataType.INSTANCE, (Object)hotbarItems[i].clone());
            if (player.getGameMode() != GameMode.CREATIVE) continue;
            player.getInventory().setItem(i, hotbarItems[i]);
        }
        container.set(AxiomConstants.HOTBAR_DATA, PersistentDataType.TAG_CONTAINER, (Object)containerHotbarItems);
        container.set(AxiomConstants.ACTIVE_HOTBAR_INDEX, PersistentDataType.BYTE, (Object)activeHotbarIndex);
    }
}

