/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.NbtSanitization;
import com.moulberry.axiom.integration.Integration;
import com.moulberry.axiom.viaversion.UnknownVersionHelper;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnEntityPacketListener
implements PluginMessageListener {
    private final AxiomPaper plugin;
    private static final EnumBlockRotation[] ROTATION_VALUES = EnumBlockRotation.values();

    public SpawnEntityPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        try {
            this.process(player, message);
        }
        catch (Throwable t) {
            player.kick((Component)Component.text((String)("Error while processing packet " + channel + ": " + t.getMessage())));
        }
    }

    private void process(Player player, byte[] message) {
        if (!this.plugin.canUseAxiom(player, "axiom.entity.spawn", true)) {
            return;
        }
        if (!this.plugin.canModifyWorld(player, player.getWorld())) {
            return;
        }
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])message));
        List entries = (List)friendlyByteBuf.a(PacketDataSerializer.a(ArrayList::new, (int)1000), buf -> new SpawnEntry(buf.n(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readFloat(), (UUID)buf.c(buffer -> buffer.n()), UnknownVersionHelper.readTagUnknown(buf, player)));
        WorldServer serverLevel = ((CraftWorld)player.getWorld()).getHandle();
        List whitelistedEntities = this.plugin.configuration.getStringList("whitelist-entities");
        List blacklistedEntities = this.plugin.configuration.getStringList("blacklist-entities");
        for (SpawnEntry entry : entries) {
            AtomicBoolean useNewUuid;
            Entity spawned;
            NBTTagCompound compoundTag;
            Entity entityCopyFrom;
            Vec3D position = new Vec3D(entry.x, entry.y, entry.z);
            BlockPosition blockPos = BlockPosition.a((IPosition)position);
            if (!World.l((BlockPosition)blockPos) || !Integration.canPlaceBlock(player, new Location(player.getWorld(), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w())) || serverLevel.a(entry.newUuid) != null) continue;
            NBTTagCompound tag = entry.tag == null ? new NBTTagCompound() : entry.tag;
            NbtSanitization.sanitizeEntity(tag);
            if (entry.copyFrom != null && (entityCopyFrom = serverLevel.a(entry.copyFrom)) != null && entityCopyFrom.d(compoundTag = new NBTTagCompound())) {
                compoundTag.r("Dimension");
                tag = tag.a(compoundTag);
            }
            if (!tag.e("id") || (spawned = EntityTypes.a((NBTTagCompound)tag, (World)serverLevel, arg_0 -> SpawnEntityPacketListener.lambda$process$2(whitelistedEntities, blacklistedEntities, useNewUuid = new AtomicBoolean(true), entry, position, arg_0))) == null) continue;
            serverLevel.e(spawned);
        }
    }

    private static /* synthetic */ Entity lambda$process$2(List whitelistedEntities, List blacklistedEntities, AtomicBoolean useNewUuid, SpawnEntry entry, Vec3D position, Entity entity) {
        String type = EntityTypes.a((EntityTypes)entity.am()).toString();
        if (!whitelistedEntities.isEmpty() && !whitelistedEntities.contains(type)) {
            return null;
        }
        if (blacklistedEntities.contains(type)) {
            return null;
        }
        if (useNewUuid.getAndSet(false)) {
            entity.a_(entry.newUuid);
        } else {
            entity.a_(UUID.randomUUID());
        }
        if (entity instanceof EntityHanging) {
            EntityItemFrame itemFrame;
            EntityHanging hangingEntity = (EntityHanging)entity;
            float changedYaw = entry.yaw - entity.dE();
            int rotations = Math.round(changedYaw / 90.0f);
            hangingEntity.a(ROTATION_VALUES[rotations & 3]);
            if (entity instanceof EntityItemFrame && (itemFrame = (EntityItemFrame)entity).cH().o() == EnumDirection.EnumAxis.b) {
                itemFrame.b(itemFrame.F() - Math.round(changedYaw / 45.0f));
            }
        }
        entity.b(position.c, position.d, position.e, entry.yaw, entry.pitch);
        entity.o(entity.dE());
        return entity;
    }

    private record SpawnEntry(UUID newUuid, double x, double y, double z, float yaw, float pitch, @Nullable UUID copyFrom, NBTTagCompound tag) {
    }
}

