/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.integration.plotsquared.PlotSquaredIntegration;
import com.moulberry.axiom.world_properties.server.ServerWorldPropertiesRegistry;
import com.moulberry.axiom.world_properties.server.ServerWorldPropertyHolder;
import io.netty.buffer.Unpooled;
import net.kyori.adventure.text.Component;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class SetWorldPropertyListener
implements PluginMessageListener {
    private final AxiomPaper plugin;

    public SetWorldPropertyListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        try {
            this.process(player, message);
        }
        catch (Throwable t) {
            player.kick((Component)Component.text((String)("Error while processing packet " + channel + ": " + t.getMessage())));
        }
    }

    private void process(Player player, byte[] message) {
        if (!this.plugin.canUseAxiom(player, "axiom.world.property")) {
            return;
        }
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])message));
        MinecraftKey id = friendlyByteBuf.q();
        int type = friendlyByteBuf.l();
        byte[] data = friendlyByteBuf.b();
        int updateId = friendlyByteBuf.l();
        if (!this.plugin.canModifyWorld(player, player.getWorld())) {
            this.sendAck(player, updateId);
            return;
        }
        if (PlotSquaredIntegration.isPlotWorld(player.getWorld())) {
            this.sendAck(player, updateId);
            return;
        }
        ServerWorldPropertiesRegistry registry = AxiomPaper.PLUGIN.getOrCreateWorldProperties(player.getWorld());
        if (registry == null) {
            this.sendAck(player, updateId);
            return;
        }
        ServerWorldPropertyHolder<?> property = registry.getById(id);
        if (property != null && property.getType().getTypeId() == type) {
            property.update(player, player.getWorld(), data);
        }
        this.sendAck(player, updateId);
    }

    private void sendAck(Player player, int updateId) {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.c(updateId);
        byte[] bytes = new byte[buf.writerIndex()];
        buf.a(0, bytes);
        player.sendPluginMessage((Plugin)AxiomPaper.PLUGIN, "axiom:ack_world_properties", bytes);
    }
}

