/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.event.AxiomTimeChangeEvent;
import com.moulberry.axiom.integration.plotsquared.PlotSquaredIntegration;
import io.netty.buffer.Unpooled;
import net.kyori.adventure.text.Component;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GameRules;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class SetTimePacketListener
implements PluginMessageListener {
    private final AxiomPaper plugin;

    public SetTimePacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        try {
            this.process(player, message);
        }
        catch (Throwable t) {
            player.kick((Component)Component.text((String)("Error while processing packet " + channel + ": " + t.getMessage())));
        }
    }

    private void process(Player player, byte[] message) {
        if (!this.plugin.canUseAxiom(player, "axiom.world.time")) {
            return;
        }
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])message));
        ResourceKey key = friendlyByteBuf.a(Registries.ba);
        Integer time = (Integer)friendlyByteBuf.c(PacketDataSerializer::readInt);
        Boolean freezeTime = (Boolean)friendlyByteBuf.c(PacketDataSerializer::readBoolean);
        if (time == null && freezeTime == null) {
            return;
        }
        WorldServer level = ((CraftWorld)player.getWorld()).getHandle();
        if (!level.af().equals(key)) {
            return;
        }
        if (!this.plugin.canModifyWorld(player, player.getWorld())) {
            return;
        }
        if (PlotSquaredIntegration.isPlotWorld(player.getWorld())) {
            return;
        }
        AxiomTimeChangeEvent timeChangeEvent = new AxiomTimeChangeEvent(player, time, freezeTime);
        Bukkit.getPluginManager().callEvent((Event)timeChangeEvent);
        if (timeChangeEvent.isCancelled()) {
            return;
        }
        if (time != null) {
            level.b((long)time.intValue());
        }
        if (freezeTime != null) {
            ((GameRules.GameRuleBoolean)level.ab().a(GameRules.l)).set(freezeTime == false, null);
        }
    }
}

