/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet;

import com.moulberry.axiom.AxiomConstants;
import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.persistence.ItemStackDataType;
import io.netty.buffer.Unpooled;
import net.kyori.adventure.text.Component;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class SetHotbarSlotPacketListener
implements PluginMessageListener {
    private final AxiomPaper plugin;

    public SetHotbarSlotPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        try {
            this.process(player, message);
        }
        catch (Throwable t) {
            player.kick((Component)Component.text((String)("Error while processing packet " + channel + ": " + t.getMessage())));
        }
    }

    private void process(Player player, byte[] message) {
        if (!this.plugin.canUseAxiom(player, "axiom.player.hotbar") || this.plugin.isMismatchedDataVersion(player.getUniqueId())) {
            return;
        }
        RegistryFriendlyByteBuf friendlyByteBuf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])message), ((CraftPlayer)player).getHandle().dQ());
        byte index = friendlyByteBuf.readByte();
        if (index < 0 || index >= 81) {
            return;
        }
        ItemStack nmsStack = (ItemStack)ItemStack.h.decode((Object)friendlyByteBuf);
        PersistentDataContainer container = player.getPersistentDataContainer();
        PersistentDataContainer hotbarItems = (PersistentDataContainer)container.get(AxiomConstants.HOTBAR_DATA, PersistentDataType.TAG_CONTAINER);
        if (hotbarItems == null) {
            hotbarItems = container.getAdapterContext().newPersistentDataContainer();
        }
        hotbarItems.set(new NamespacedKey("axiom", "slot_" + index), (PersistentDataType)ItemStackDataType.INSTANCE, (Object)CraftItemStack.asCraftMirror((ItemStack)nmsStack));
        container.set(AxiomConstants.HOTBAR_DATA, PersistentDataType.TAG_CONTAINER, (Object)hotbarItems);
    }
}

