/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet;

import com.google.common.collect.Lists;
import com.moulberry.axiom.AxiomConstants;
import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.View;
import com.moulberry.axiom.persistence.UUIDDataType;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.UUID;
import java.util.function.IntFunction;
import net.kyori.adventure.text.Component;
import net.minecraft.network.PacketDataSerializer;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class SetEditorViewsPacketListener
implements PluginMessageListener {
    private final AxiomPaper plugin;

    public SetEditorViewsPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        try {
            this.process(player, message);
        }
        catch (Throwable t) {
            player.kick((Component)Component.text((String)("Error while processing packet " + channel + ": " + t.getMessage())));
        }
    }

    private void process(Player player, byte[] message) {
        if (!this.plugin.canUseAxiom(player, "axiom.editor.views")) {
            return;
        }
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])message));
        UUID uuid = friendlyByteBuf.n();
        IntFunction listFunction = PacketDataSerializer.a(Lists::newArrayListWithCapacity, (int)64);
        List views = (List)friendlyByteBuf.a(listFunction, View::read);
        PersistentDataContainer container = player.getPersistentDataContainer();
        container.set(AxiomConstants.ACTIVE_VIEW, (PersistentDataType)UUIDDataType.INSTANCE, (Object)uuid);
        PersistentDataContainer[] containerArray = new PersistentDataContainer[views.size()];
        for (int i = 0; i < views.size(); ++i) {
            PersistentDataContainer viewContainer = container.getAdapterContext().newPersistentDataContainer();
            ((View)views.get(i)).save(viewContainer);
            containerArray[i] = viewContainer;
        }
        container.set(AxiomConstants.VIEWS, PersistentDataType.TAG_CONTAINER_ARRAY, (Object)containerArray);
    }
}

