/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet;

import com.google.common.collect.Maps;
import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.integration.Integration;
import com.moulberry.axiom.integration.coreprotect.CoreProtectIntegration;
import io.netty.buffer.Unpooled;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jpenilla.reflectionremapper.ReflectionRemapper;

public class SetBlockPacketListener
implements PluginMessageListener {
    private final AxiomPaper plugin;
    private final Method updateBlockEntityTicker;

    public SetBlockPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
        ReflectionRemapper reflectionRemapper = ReflectionRemapper.forReobfMappingsInPaperJar();
        String methodName = reflectionRemapper.remapMethodName(Chunk.class, "updateBlockEntityTicker", TileEntity.class);
        try {
            this.updateBlockEntityTicker = Chunk.class.getDeclaredMethod(methodName, TileEntity.class);
            this.updateBlockEntityTicker.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        try {
            this.process(player, message);
        }
        catch (Throwable t) {
            player.kick((Component)Component.text((String)("Error while processing packet " + channel + ": " + t.getMessage())));
        }
    }

    private void process(Player bukkitPlayer, byte[] message) {
        if (!this.plugin.canUseAxiom(bukkitPlayer, "axiom.build.place")) {
            return;
        }
        if (!this.plugin.canModifyWorld(bukkitPlayer, bukkitPlayer.getWorld())) {
            return;
        }
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])message));
        IntFunction mapFunction = PacketDataSerializer.a(Maps::newLinkedHashMapWithExpectedSize, (int)512);
        RegistryBlockID<IBlockData> registry = this.plugin.getBlockRegistry(bukkitPlayer.getUniqueId());
        Map blocks = friendlyByteBuf.a(mapFunction, buf -> buf.e(), buf -> (IBlockData)buf.a(arg_0 -> ((RegistryBlockID)registry).b(arg_0)));
        boolean updateNeighbors = friendlyByteBuf.readBoolean();
        int reason = friendlyByteBuf.l();
        boolean breaking = friendlyByteBuf.readBoolean();
        MovingObjectPositionBlock blockHit = friendlyByteBuf.v();
        EnumHand hand = (EnumHand)friendlyByteBuf.b(EnumHand.class);
        int sequenceId = friendlyByteBuf.l();
        EntityPlayer player = ((CraftPlayer)bukkitPlayer).getHandle();
        if (sequenceId >= 0) {
            player.c.a(sequenceId);
        }
        BlockActionContext blockPlaceContext = new BlockActionContext((EntityHuman)player, hand, player.b(hand), blockHit);
        if (!blockHit.e().equals((Object)Vec3D.b)) {
            BlockFace blockFace;
            org.bukkit.block.Block blockClicked;
            ItemStack heldItem;
            PlayerInteractEvent playerInteractEvent = new PlayerInteractEvent(bukkitPlayer, breaking ? Action.LEFT_CLICK_BLOCK : Action.RIGHT_CLICK_BLOCK, heldItem = hand == EnumHand.a ? bukkitPlayer.getInventory().getItemInMainHand() : bukkitPlayer.getInventory().getItemInOffHand(), blockClicked = bukkitPlayer.getWorld().getBlockAt(blockHit.a().u(), blockHit.a().v(), blockHit.a().w()), blockFace = CraftBlock.notchToBlockFace((EnumDirection)blockHit.b()));
            if (!playerInteractEvent.callEvent()) {
                return;
            }
            ArrayList<AxiomPlacingCraftBlockState> blockStates = new ArrayList<AxiomPlacingCraftBlockState>();
            CraftWorld world = player.A().getWorld();
            for (Map.Entry entry : blocks.entrySet()) {
                blockStates.add(new AxiomPlacingCraftBlockState((org.bukkit.World)world, (BlockPosition)entry.getKey(), (IBlockData)entry.getValue()));
            }
            BlockMultiPlaceEvent event = null;
            if (blockStates.size() > 1) {
                event = CraftEventFactory.callBlockMultiPlaceEvent((WorldServer)player.A(), (EntityHuman)player, (EnumHand)hand, blockStates, (int)blockHit.a().u(), (int)blockHit.a().v(), (int)blockHit.a().w());
            } else if (blockStates.size() == 1) {
                event = CraftEventFactory.callBlockPlaceEvent((WorldServer)player.A(), (EntityHuman)player, (EnumHand)hand, (BlockState)((BlockState)blockStates.get(0)), (int)blockHit.a().u(), (int)blockHit.a().v(), (int)blockHit.a().w());
            }
            if (event != null && event.isCancelled()) {
                return;
            }
        }
        CraftWorld world = player.dO().getWorld();
        if (updateNeighbors) {
            count = 0;
            for (Map.Entry entry : blocks.entrySet()) {
                if (count++ <= 64) {
                    blockPos = (BlockPosition)entry.getKey();
                    blockState = (IBlockData)entry.getValue();
                    if (blockState == null || !player.dO().p(blockPos) || (!blockState.i() ? !Integration.canPlaceBlock(bukkitPlayer, new Location((org.bukkit.World)world, (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w())) : !Integration.canBreakBlock(bukkitPlayer, world.getBlockAt(blockPos.u(), blockPos.v(), blockPos.w())))) continue;
                    if (CoreProtectIntegration.isEnabled()) {
                        IBlockData old = player.dO().a_(blockPos);
                        CoreProtectIntegration.logRemoval(bukkitPlayer.getName(), old, world, blockPos);
                    }
                    player.dO().a(blockPos, blockState, 3);
                    CoreProtectIntegration.logPlacement(bukkitPlayer.getName(), blockState, world, blockPos);
                    continue;
                }
                break;
            }
        } else {
            count = 0;
            for (Map.Entry entry : blocks.entrySet()) {
                if (count++ <= 64) {
                    boolean nowHasOnlyAir;
                    blockPos = (BlockPosition)entry.getKey();
                    blockState = (IBlockData)entry.getValue();
                    if (blockState == null || !player.dO().p(blockPos) || (blockState.i() ? !Integration.canBreakBlock(bukkitPlayer, world.getBlockAt(blockPos.u(), blockPos.v(), blockPos.w())) : !Integration.canPlaceBlock(bukkitPlayer, new Location((org.bukkit.World)world, (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w())))) continue;
                    int bx = blockPos.u();
                    int by = blockPos.v();
                    int bz = blockPos.w();
                    int x = bx & 0xF;
                    int y = by & 0xF;
                    int z = bz & 0xF;
                    int cx = bx >> 4;
                    int cy = by >> 4;
                    int cz = bz >> 4;
                    WorldServer level = player.A();
                    Chunk chunk = level.d(cx, cz);
                    chunk.a(true);
                    ChunkSection section = chunk.b(level.f(cy));
                    boolean hasOnlyAir = section.c();
                    HeightMap worldSurface = null;
                    HeightMap oceanFloor = null;
                    HeightMap motionBlocking = null;
                    HeightMap motionBlockingNoLeaves = null;
                    for (Map.Entry heightmap : chunk.e()) {
                        switch ((HeightMap.Type)heightmap.getKey()) {
                            case b: {
                                worldSurface = (HeightMap)heightmap.getValue();
                                break;
                            }
                            case d: {
                                oceanFloor = (HeightMap)heightmap.getValue();
                                break;
                            }
                            case e: {
                                motionBlocking = (HeightMap)heightmap.getValue();
                                break;
                            }
                            case f: {
                                motionBlockingNoLeaves = (HeightMap)heightmap.getValue();
                                break;
                            }
                        }
                    }
                    IBlockData old = section.a(x, y, z, blockState, true);
                    if (blockState != old) {
                        Block block = blockState.b();
                        motionBlocking.a(x, by, z, blockState);
                        motionBlockingNoLeaves.a(x, by, z, blockState);
                        oceanFloor.a(x, by, z, blockState);
                        worldSurface.a(x, by, z, blockState);
                        if (blockState.t()) {
                            TileEntity blockEntity = chunk.a(blockPos, Chunk.EnumTileEntityState.c);
                            if (blockEntity == null) {
                                blockEntity = ((ITileEntity)block).a(blockPos, blockState);
                                if (blockEntity != null) {
                                    chunk.b(blockEntity);
                                }
                            } else if (blockEntity.r().a(blockState)) {
                                blockEntity.c(blockState);
                                try {
                                    this.updateBlockEntityTicker.invoke((Object)chunk, blockEntity);
                                }
                                catch (IllegalAccessException | InvocationTargetException e) {
                                    throw new RuntimeException(e);
                                }
                            } else {
                                chunk.d(blockPos);
                                blockEntity = ((ITileEntity)block).a(blockPos, blockState);
                                if (blockEntity != null) {
                                    chunk.b(blockEntity);
                                }
                            }
                        } else if (old.t()) {
                            chunk.d(blockPos);
                        }
                        level.l().a(blockPos);
                        if (LightEngine.a((IBlockAccess)chunk, (BlockPosition)blockPos, (IBlockData)old, (IBlockData)blockState)) {
                            level.l().a().a(blockPos);
                        }
                        Optional newPoi = PoiTypes.a((IBlockData)blockState);
                        Optional oldPoi = PoiTypes.a((IBlockData)old);
                        if (!Objects.equals(oldPoi, newPoi)) {
                            if (oldPoi.isPresent()) {
                                level.y().a(blockPos);
                            }
                            if (newPoi.isPresent()) {
                                level.y().a(blockPos, (Holder)newPoi.get());
                            }
                        }
                        if (CoreProtectIntegration.isEnabled()) {
                            String changedBy = player.getBukkitEntity().getName();
                            BlockPosition changedPos = new BlockPosition(bx, by, bz);
                            CoreProtectIntegration.logRemoval(changedBy, old, world, changedPos);
                            CoreProtectIntegration.logPlacement(changedBy, blockState, world, changedPos);
                        }
                    }
                    if (hasOnlyAir == (nowHasOnlyAir = section.c())) continue;
                    level.l().a().a(SectionPosition.a((int)cx, (int)cy, (int)cz), nowHasOnlyAir);
                    continue;
                }
                break;
            }
        }
        if (!breaking) {
            BlockPosition clickedPos = blockPlaceContext.a();
            if (!player.dO().p(clickedPos)) {
                return;
            }
            IBlockData desiredBlockState = (IBlockData)blocks.get(clickedPos);
            IBlockData actualBlockState = player.dO().a_(clickedPos);
            Block actualBlock = actualBlockState.b();
            if (desiredBlockState == null || desiredBlockState.i() || actualBlockState.i()) {
                return;
            }
            if (desiredBlockState.b() != actualBlock) {
                return;
            }
            if (!Integration.canPlaceBlock(bukkitPlayer, new Location((org.bukkit.World)world, (double)clickedPos.u(), (double)clickedPos.v(), (double)clickedPos.w()))) {
                return;
            }
            net.minecraft.world.item.ItemStack inHand = player.b(hand);
            ItemBlock.a((World)player.dO(), (EntityHuman)player, (BlockPosition)clickedPos, (net.minecraft.world.item.ItemStack)inHand);
            TileEntity blockEntity = player.dO().c_(clickedPos);
            if (blockEntity != null) {
                blockEntity.a(inHand);
            }
            if (!(actualBlock instanceof BlockBed || actualBlock instanceof BlockTallPlant || actualBlock instanceof BlockDoor)) {
                actualBlock.a(player.dO(), clickedPos, actualBlockState, (EntityLiving)player, inHand);
            }
        }
    }

    public static class AxiomPlacingCraftBlockState
    extends CraftBlockState {
        public AxiomPlacingCraftBlockState(@Nullable org.bukkit.World world, BlockPosition blockPosition, IBlockData blockData) {
            super(world, blockPosition, blockData);
        }
    }
}

