/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet;

import com.google.common.util.concurrent.RateLimiter;
import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.WorldExtension;
import com.moulberry.axiom.buffer.BiomeBuffer;
import com.moulberry.axiom.buffer.BlockBuffer;
import com.moulberry.axiom.buffer.CompressedBlockEntity;
import com.moulberry.axiom.integration.Integration;
import com.moulberry.axiom.integration.SectionPermissionChecker;
import com.moulberry.axiom.integration.coreprotect.CoreProtectIntegration;
import com.moulberry.axiom.viaversion.UnknownVersionHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.text.Component;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LightEngine;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import xyz.jpenilla.reflectionremapper.ReflectionRemapper;

public class SetBlockBufferPacketListener {
    private final AxiomPaper plugin;
    private final Method updateBlockEntityTicker;
    private final WeakHashMap<EntityPlayer, RateLimiter> packetRateLimiter = new WeakHashMap();

    public SetBlockBufferPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
        ReflectionRemapper reflectionRemapper = ReflectionRemapper.forReobfMappingsInPaperJar();
        String methodName = reflectionRemapper.remapMethodName(Chunk.class, "updateBlockEntityTicker", TileEntity.class);
        try {
            this.updateBlockEntityTicker = Chunk.class.getDeclaredMethod(methodName, TileEntity.class);
            this.updateBlockEntityTicker.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void onReceive(EntityPlayer player, PacketDataSerializer friendlyByteBuf) {
        MinecraftServer server = player.cO();
        if (server == null) {
            return;
        }
        ResourceKey worldKey = friendlyByteBuf.a(Registries.ba);
        friendlyByteBuf.n();
        boolean continuation = friendlyByteBuf.readBoolean();
        if (!continuation) {
            UnknownVersionHelper.skipTagUnknown(friendlyByteBuf, (Player)player.getBukkitEntity());
        }
        RateLimiter rateLimiter = this.plugin.getBlockBufferRateLimiter(player.cz());
        byte type = friendlyByteBuf.readByte();
        if (type == 0) {
            AtomicBoolean reachedRateLimit = new AtomicBoolean(false);
            BlockBuffer buffer = BlockBuffer.load(friendlyByteBuf, rateLimiter, reachedRateLimit, this.plugin.getBlockRegistry(player.cz()));
            if (reachedRateLimit.get()) {
                player.a((IChatBaseComponent)IChatBaseComponent.b((String)("[Axiom] Exceeded server rate-limit of " + (int)rateLimiter.getRate() + " sections per second")).a(EnumChatFormat.m));
            }
            if (this.plugin.logLargeBlockBufferChanges()) {
                this.plugin.getLogger().info("Player " + String.valueOf(player.cz()) + " modified " + buffer.entrySet().size() + " chunk sections (blocks)");
                if (buffer.getTotalBlockEntities() > 0L) {
                    this.plugin.getLogger().info("Player " + String.valueOf(player.cz()) + " modified " + buffer.getTotalBlockEntities() + " block entities, compressed bytes = " + buffer.getTotalBlockEntityBytes());
                }
            }
            this.applyBlockBuffer(player, server, buffer, (ResourceKey<World>)worldKey);
        } else if (type == 1) {
            AtomicBoolean reachedRateLimit = new AtomicBoolean(false);
            BiomeBuffer buffer = BiomeBuffer.load(friendlyByteBuf, rateLimiter, reachedRateLimit);
            if (reachedRateLimit.get()) {
                player.a((IChatBaseComponent)IChatBaseComponent.b((String)("[Axiom] Exceeded server rate-limit of " + (int)rateLimiter.getRate() + " sections per second")).a(EnumChatFormat.m));
            }
            if (this.plugin.logLargeBlockBufferChanges()) {
                this.plugin.getLogger().info("Player " + String.valueOf(player.cz()) + " modified " + buffer.size() + " chunk sections (biomes)");
            }
            this.applyBiomeBuffer(player, server, buffer, (ResourceKey<World>)worldKey);
        } else {
            throw new RuntimeException("Unknown buffer type: " + type);
        }
    }

    private void applyBlockBuffer(EntityPlayer player, MinecraftServer server, BlockBuffer buffer, ResourceKey<World> worldKey) {
        server.execute(() -> {
            try {
                WorldServer world = player.A();
                if (!world.af().equals(worldKey)) {
                    return;
                }
                if (!this.plugin.canUseAxiom((Player)player.getBukkitEntity(), "axiom.build.section")) {
                    return;
                }
                if (!this.plugin.canModifyWorld((Player)player.getBukkitEntity(), (org.bukkit.World)world.getWorld())) {
                    return;
                }
                BlockPosition.MutableBlockPosition blockPos = new BlockPosition.MutableBlockPosition();
                WorldExtension extension = WorldExtension.get(world);
                IBlockData emptyState = BlockBuffer.EMPTY_STATE;
                for (Long2ObjectMap.Entry entry : buffer.entrySet()) {
                    SectionPermissionChecker checker;
                    int cx = BlockPosition.a((long)entry.getLongKey());
                    int cy = BlockPosition.b((long)entry.getLongKey());
                    int cz = BlockPosition.c((long)entry.getLongKey());
                    DataPaletteBlock container = (DataPaletteBlock)entry.getValue();
                    if (cy < world.ao() || cy >= world.ap() || (checker = Integration.checkSection((Player)player.getBukkitEntity(), (org.bukkit.World)world.getWorld(), cx, cy, cz)) != null && checker.noneAllowed()) continue;
                    Chunk chunk = world.d(cx, cz);
                    ChunkSection section = chunk.b(world.f(cy));
                    DataPaletteBlock sectionStates = section.h();
                    boolean hasOnlyAir = section.c();
                    HeightMap worldSurface = null;
                    HeightMap oceanFloor = null;
                    HeightMap motionBlocking = null;
                    HeightMap motionBlockingNoLeaves = null;
                    for (Map.Entry heightmap : chunk.e()) {
                        switch ((HeightMap.Type)heightmap.getKey()) {
                            case b: {
                                worldSurface = (HeightMap)heightmap.getValue();
                                break;
                            }
                            case d: {
                                oceanFloor = (HeightMap)heightmap.getValue();
                                break;
                            }
                            case e: {
                                motionBlocking = (HeightMap)heightmap.getValue();
                                break;
                            }
                            case f: {
                                motionBlockingNoLeaves = (HeightMap)heightmap.getValue();
                                break;
                            }
                        }
                    }
                    boolean sectionChanged = false;
                    boolean sectionLightChanged = false;
                    boolean containerMaybeHasPoi = container.a(PoiTypes::b);
                    boolean sectionMaybeHasPoi = section.a(PoiTypes::b);
                    Short2ObjectMap<CompressedBlockEntity> blockEntityChunkMap = buffer.getBlockEntityChunkMap(entry.getLongKey());
                    int minX = 0;
                    int minY = 0;
                    int minZ = 0;
                    int maxX = 15;
                    int maxY = 15;
                    int maxZ = 15;
                    if (checker != null) {
                        minX = checker.bounds().minX();
                        minY = checker.bounds().minY();
                        minZ = checker.bounds().minZ();
                        maxX = checker.bounds().maxX();
                        maxY = checker.bounds().maxY();
                        maxZ = checker.bounds().maxZ();
                        if (checker.allAllowed()) {
                            checker = null;
                        }
                    }
                    for (int x = minX; x <= maxX; ++x) {
                        for (int y = minY; y <= maxY; ++y) {
                            for (int z = minZ; z <= maxZ; ++z) {
                                IBlockData blockState = (IBlockData)container.a(x, y, z);
                                if (blockState == emptyState) continue;
                                int bx = cx * 16 + x;
                                int by = cy * 16 + y;
                                int bz = cz * 16 + z;
                                if (hasOnlyAir && blockState.i() || checker != null && !checker.allowed(x, y, z)) continue;
                                Block block = blockState.b();
                                IBlockData old = section.a(x, y, z, blockState, true);
                                if (blockState != old) {
                                    Optional oldPoi;
                                    sectionChanged = true;
                                    blockPos.d(bx, by, bz);
                                    motionBlocking.a(x, by, z, blockState);
                                    motionBlockingNoLeaves.a(x, by, z, blockState);
                                    oceanFloor.a(x, by, z, blockState);
                                    worldSurface.a(x, by, z, blockState);
                                    sectionLightChanged |= LightEngine.a((IBlockAccess)chunk, (BlockPosition)blockPos, (IBlockData)old, (IBlockData)blockState);
                                    Optional newPoi = containerMaybeHasPoi ? PoiTypes.a((IBlockData)blockState) : Optional.empty();
                                    Optional optional = oldPoi = sectionMaybeHasPoi ? PoiTypes.a((IBlockData)old) : Optional.empty();
                                    if (!Objects.equals(oldPoi, newPoi)) {
                                        if (oldPoi.isPresent()) {
                                            world.y().a((BlockPosition)blockPos);
                                        }
                                        if (newPoi.isPresent()) {
                                            world.y().a((BlockPosition)blockPos, (Holder)newPoi.get());
                                        }
                                    }
                                }
                                if (blockState.t()) {
                                    int key;
                                    CompressedBlockEntity savedBlockEntity;
                                    blockPos.d(bx, by, bz);
                                    TileEntity blockEntity = chunk.a((BlockPosition)blockPos, Chunk.EnumTileEntityState.c);
                                    if (blockEntity == null) {
                                        blockEntity = ((ITileEntity)block).a((BlockPosition)blockPos, blockState);
                                        if (blockEntity != null) {
                                            chunk.b(blockEntity);
                                        }
                                    } else if (blockEntity.r().a(blockState)) {
                                        blockEntity.c(blockState);
                                        try {
                                            this.updateBlockEntityTicker.invoke((Object)chunk, blockEntity);
                                        }
                                        catch (IllegalAccessException | InvocationTargetException e) {
                                            throw new RuntimeException(e);
                                        }
                                    } else {
                                        chunk.d((BlockPosition)blockPos);
                                        blockEntity = ((ITileEntity)block).a((BlockPosition)blockPos, blockState);
                                        if (blockEntity != null) {
                                            chunk.b(blockEntity);
                                        }
                                    }
                                    if (blockEntity != null && blockEntityChunkMap != null && (savedBlockEntity = (CompressedBlockEntity)blockEntityChunkMap.get((short)(key = x | y << 4 | z << 8))) != null) {
                                        blockEntity.c(savedBlockEntity.decompress(), (HolderLookup.a)player.dQ());
                                    }
                                } else if (old.t()) {
                                    chunk.d((BlockPosition)blockPos);
                                }
                                if (!CoreProtectIntegration.isEnabled() || old == blockState) continue;
                                String changedBy = player.getBukkitEntity().getName();
                                BlockPosition changedPos = new BlockPosition(bx, by, bz);
                                CoreProtectIntegration.logRemoval(changedBy, old, world.getWorld(), changedPos);
                                CoreProtectIntegration.logPlacement(changedBy, blockState, world.getWorld(), changedPos);
                            }
                        }
                    }
                    boolean nowHasOnlyAir = section.c();
                    if (hasOnlyAir != nowHasOnlyAir) {
                        world.l().a().a(SectionPosition.a((int)cx, (int)cy, (int)cz), nowHasOnlyAir);
                    }
                    if (sectionChanged) {
                        extension.sendChunk(cx, cz);
                        chunk.a(true);
                    }
                    if (!sectionLightChanged) continue;
                    extension.lightChunk(cx, cz);
                }
            }
            catch (Throwable t) {
                player.getBukkitEntity().kick((Component)Component.text((String)("An error occured while processing block change: " + t.getMessage())));
            }
        });
    }

    private void applyBiomeBuffer(EntityPlayer player, MinecraftServer server, BiomeBuffer biomeBuffer, ResourceKey<World> worldKey) {
        server.execute(() -> {
            try {
                WorldServer world = player.A();
                if (!world.af().equals(worldKey)) {
                    return;
                }
                if (!this.plugin.canUseAxiom((Player)player.getBukkitEntity(), "axiom.build.section")) {
                    return;
                }
                if (!this.plugin.canModifyWorld((Player)player.getBukkitEntity(), (org.bukkit.World)world.getWorld())) {
                    return;
                }
                HashSet changedChunks = new HashSet();
                int minSection = world.ao();
                int maxSection = world.ap();
                Optional registryOptional = world.H_().c(Registries.aF);
                if (registryOptional.isEmpty()) {
                    return;
                }
                IRegistry registry = (IRegistry)registryOptional.get();
                biomeBuffer.forEachEntry((x, y, z, biome) -> {
                    int cy = y >> 2;
                    if (cy < minSection || cy >= maxSection) {
                        return;
                    }
                    Optional holder = registry.b(biome);
                    if (holder.isPresent()) {
                        Chunk chunk = (Chunk)world.a(x >> 2, z >> 2, ChunkStatus.n, false);
                        if (chunk == null) {
                            return;
                        }
                        ChunkSection section = chunk.b(cy - minSection);
                        DataPaletteBlock container = (DataPaletteBlock)section.i();
                        if (!Integration.canPlaceBlock((Player)player.getBukkitEntity(), new Location(player.getBukkitEntity().getWorld(), (double)((x << 2) + 1), (double)((y << 2) + 1), (double)((z << 2) + 1)))) {
                            return;
                        }
                        container.c(x & 3, y & 3, z & 3, (Object)((Holder)holder.get()));
                        changedChunks.add(chunk);
                    }
                });
                PlayerChunkMap chunkMap = world.l().a;
                HashMap<EntityPlayer, List> map = new HashMap<EntityPlayer, List>();
                for (Chunk chunk : changedChunks) {
                    chunk.a(true);
                    ChunkCoordIntPair chunkPos = chunk.f();
                    for (EntityPlayer serverPlayer2 : chunkMap.a(chunkPos, false)) {
                        map.computeIfAbsent(serverPlayer2, serverPlayer -> new ArrayList()).add(chunk);
                    }
                }
                map.forEach((serverPlayer, list) -> serverPlayer.c.b((Packet)ClientboundChunksBiomesPacket.a((List)list)));
            }
            catch (Throwable t) {
                player.getBukkitEntity().kick((Component)Component.text((String)("An error occured while processing biome change: " + t.getMessage())));
            }
        });
    }
}

