/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet;

import com.moulberry.axiom.AxiomConstants;
import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.buffer.CompressedBlockEntity;
import com.moulberry.axiom.integration.plotsquared.PlotSquaredIntegration;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.ByteArrayOutputStream;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class RequestChunkDataPacketListener
implements PluginMessageListener {
    private static final MinecraftKey RESPONSE_ID = VersionHelper.createResourceLocation("axiom:response_chunk_data");
    private final AxiomPaper plugin;

    public RequestChunkDataPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        try {
            this.process(player, message);
        }
        catch (Throwable t) {
            player.kick((Component)Component.text((String)("Error while processing packet " + channel + ": " + t.getMessage())));
        }
    }

    private void process(Player bukkitPlayer, byte[] message) {
        int beforeWriterIndex;
        EntityPlayer player = ((CraftPlayer)bukkitPlayer).getHandle();
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])message));
        long id = friendlyByteBuf.readLong();
        if (!this.plugin.canUseAxiom(bukkitPlayer, "axiom.chunk.request") || this.plugin.isMismatchedDataVersion(bukkitPlayer.getUniqueId())) {
            this.sendEmptyResponse(player, id);
            return;
        }
        if (!this.plugin.canModifyWorld(bukkitPlayer, bukkitPlayer.getWorld())) {
            this.sendEmptyResponse(player, id);
            return;
        }
        MinecraftServer server = player.cO();
        if (server == null) {
            this.sendEmptyResponse(player, id);
            return;
        }
        ResourceKey worldKey = friendlyByteBuf.a(Registries.ba);
        WorldServer level = server.a(worldKey);
        if (level == null) {
            this.sendEmptyResponse(player, id);
            return;
        }
        boolean sendBlockEntitiesInChunks = friendlyByteBuf.readBoolean();
        Long2ObjectOpenHashMap blockEntityMap = new Long2ObjectOpenHashMap();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        int maxChunkLoadDistance = this.plugin.configuration.getInt("max-chunk-load-distance");
        if (PlotSquaredIntegration.isPlotWorld((World)level.getWorld())) {
            maxChunkLoadDistance = 0;
        }
        int playerSectionX = player.ds() >> 4;
        int playerSectionZ = player.dy() >> 4;
        int count = friendlyByteBuf.l();
        for (int i = 0; i < count; ++i) {
            TileEntity blockEntity;
            int distance;
            boolean canLoad;
            int chunkZ;
            long pos = friendlyByteBuf.readLong();
            mutableBlockPos.f(pos);
            if (level.s((BlockPosition)mutableBlockPos)) continue;
            int chunkX = mutableBlockPos.u() >> 4;
            Chunk chunk = (Chunk)level.a(chunkX, chunkZ = mutableBlockPos.w() >> 4, ChunkStatus.n, canLoad = (distance = Math.abs(playerSectionX - chunkX) + Math.abs(playerSectionZ - chunkZ)) <= maxChunkLoadDistance);
            if (chunk == null || (blockEntity = chunk.a((BlockPosition)mutableBlockPos, Chunk.EnumTileEntityState.a)) == null) continue;
            NBTTagCompound tag = blockEntity.d((HolderLookup.a)player.dQ());
            blockEntityMap.put(pos, (Object)CompressedBlockEntity.compress(tag, baos));
        }
        Long2ObjectOpenHashMap sections = new Long2ObjectOpenHashMap();
        if (maxChunkLoadDistance > 0) {
            count = friendlyByteBuf.l();
            for (int i = 0; i < count; ++i) {
                Chunk chunk;
                int sectionIndex;
                long pos = friendlyByteBuf.readLong();
                int sx = BlockPosition.a((long)pos);
                int sy = BlockPosition.b((long)pos);
                int sz = BlockPosition.c((long)pos);
                int distance = Math.abs(playerSectionX - sx) + Math.abs(playerSectionZ - sz);
                if (distance > maxChunkLoadDistance || (sectionIndex = (chunk = level.d(sx, sz)).f(sy)) < 0 || sectionIndex >= chunk.an()) continue;
                ChunkSection section = chunk.b(sectionIndex);
                if (section.c()) {
                    sections.put(pos, null);
                    continue;
                }
                DataPaletteBlock container = section.h();
                sections.put(pos, (Object)container);
                if (!sendBlockEntitiesInChunks || !section.a(BlockBase.BlockData::t)) continue;
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            IBlockData blockState = (IBlockData)container.a(x, y, z);
                            if (!blockState.t()) continue;
                            mutableBlockPos.d(sx * 16 + x, sy * 16 + y, sz * 16 + z);
                            TileEntity blockEntity = chunk.a((BlockPosition)mutableBlockPos, Chunk.EnumTileEntityState.c);
                            if (blockEntity == null) continue;
                            NBTTagCompound tag = blockEntity.d((HolderLookup.a)player.dQ());
                            blockEntityMap.put(mutableBlockPos.a(), (Object)CompressedBlockEntity.compress(tag, baos));
                        }
                    }
                }
            }
        }
        boolean firstPart = true;
        int maxSize = 1048512;
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.b(id);
        for (Long2ObjectMap.Entry entry : blockEntityMap.long2ObjectEntrySet()) {
            beforeWriterIndex = buf.writerIndex();
            buf.b(entry.getLongKey());
            ((CompressedBlockEntity)entry.getValue()).write(buf);
            if (buf.writerIndex() >= maxSize) {
                if (firstPart) {
                    buf.b(AxiomConstants.MIN_POSITION_LONG);
                    buf.b(AxiomConstants.MIN_POSITION_LONG);
                    buf.a(false);
                    byte[] bytes = new byte[buf.writerIndex()];
                    buf.a(0, bytes);
                    VersionHelper.sendCustomPayload(player, RESPONSE_ID, bytes);
                    buf = new PacketDataSerializer(Unpooled.buffer());
                    buf.b(id);
                    continue;
                }
                int copiedSize = buf.writerIndex() - beforeWriterIndex;
                byte[] copied = new byte[copiedSize];
                buf.a(beforeWriterIndex, copied);
                buf.h(beforeWriterIndex);
                buf.b(AxiomConstants.MIN_POSITION_LONG);
                buf.b(AxiomConstants.MIN_POSITION_LONG);
                buf.a(false);
                byte[] bytes = new byte[buf.writerIndex()];
                buf.a(0, bytes);
                VersionHelper.sendCustomPayload(player, RESPONSE_ID, bytes);
                buf = new PacketDataSerializer(Unpooled.buffer());
                buf.b(id);
                buf.c(copied);
                firstPart = true;
                continue;
            }
            firstPart = false;
        }
        buf.b(AxiomConstants.MIN_POSITION_LONG);
        for (Long2ObjectMap.Entry entry : sections.long2ObjectEntrySet()) {
            beforeWriterIndex = buf.writerIndex();
            buf.b(entry.getLongKey());
            DataPaletteBlock container = (DataPaletteBlock)entry.getValue();
            if (container == null) {
                buf.a(false);
            } else {
                buf.a(true);
                ((DataPaletteBlock)entry.getValue()).b(buf);
            }
            if (buf.writerIndex() >= maxSize) {
                if (firstPart) {
                    buf.b(AxiomConstants.MIN_POSITION_LONG);
                    buf.a(false);
                    byte[] bytes = new byte[buf.writerIndex()];
                    buf.a(0, bytes);
                    VersionHelper.sendCustomPayload(player, RESPONSE_ID, bytes);
                    buf = new PacketDataSerializer(Unpooled.buffer());
                    buf.b(id);
                    buf.b(AxiomConstants.MIN_POSITION_LONG);
                    continue;
                }
                int copiedSize = buf.writerIndex() - beforeWriterIndex;
                byte[] copied = new byte[copiedSize];
                buf.a(beforeWriterIndex, copied);
                buf.h(beforeWriterIndex);
                buf.b(AxiomConstants.MIN_POSITION_LONG);
                buf.a(false);
                byte[] bytes = new byte[buf.writerIndex()];
                buf.a(0, bytes);
                VersionHelper.sendCustomPayload(player, RESPONSE_ID, bytes);
                buf = new PacketDataSerializer(Unpooled.buffer());
                buf.b(id);
                buf.b(AxiomConstants.MIN_POSITION_LONG);
                buf.c(copied);
                firstPart = true;
                continue;
            }
            firstPart = false;
        }
        buf.b(AxiomConstants.MIN_POSITION_LONG);
        buf.a(true);
        byte[] bytes = new byte[buf.writerIndex()];
        buf.a(0, bytes);
        VersionHelper.sendCustomPayload(player, RESPONSE_ID, bytes);
    }

    private void sendEmptyResponse(EntityPlayer player, long id) {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer((int)16));
        buf.b(id);
        buf.b(AxiomConstants.MIN_POSITION_LONG);
        buf.b(AxiomConstants.MIN_POSITION_LONG);
        buf.a(true);
        byte[] bytes = new byte[buf.writerIndex()];
        buf.a(0, bytes);
        VersionHelper.sendCustomPayload(player, RESPONSE_ID, bytes);
    }
}

