/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.marker.MarkerData;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Marker;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class MarkerNbtRequestPacketListener
implements PluginMessageListener {
    private final AxiomPaper plugin;

    public MarkerNbtRequestPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        try {
            this.process(player, message);
        }
        catch (Throwable t) {
            player.kick((Component)Component.text((String)("Error while processing packet " + channel + ": " + t.getMessage())));
        }
    }

    private void process(Player player, byte[] message) {
        if (!this.plugin.canUseAxiom(player, "axiom.entity.manipulate", true)) {
            return;
        }
        if (!this.plugin.canModifyWorld(player, player.getWorld())) {
            return;
        }
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])message));
        UUID uuid = friendlyByteBuf.n();
        WorldServer serverLevel = ((CraftWorld)player.getWorld()).getHandle();
        Entity entity = serverLevel.a(uuid);
        if (entity instanceof Marker) {
            Marker marker = (Marker)entity;
            NBTTagCompound data = MarkerData.getData(marker);
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
            buf.a(uuid);
            buf.a((NBTBase)data);
            byte[] bytes = new byte[buf.writerIndex()];
            buf.a(0, bytes);
            player.sendPluginMessage((Plugin)AxiomPaper.PLUGIN, "axiom:marker_nbt_response", bytes);
        }
    }
}

