/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.NbtSanitization;
import com.moulberry.axiom.event.AxiomManipulateEntityEvent;
import com.moulberry.axiom.integration.Integration;
import com.moulberry.axiom.viaversion.UnknownVersionHelper;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManipulateEntityPacketListener
implements PluginMessageListener {
    private final AxiomPaper plugin;
    private static final EnumBlockRotation[] ROTATION_VALUES = EnumBlockRotation.values();

    public ManipulateEntityPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        try {
            this.process(player, message);
        }
        catch (Throwable t) {
            player.kick((Component)Component.text((String)("Error while processing packet " + channel + ": " + t.getMessage())));
        }
    }

    private void process(Player player, byte[] message) {
        if (!this.plugin.canUseAxiom(player, "axiom.entity.manipulate", true)) {
            return;
        }
        if (!this.plugin.canModifyWorld(player, player.getWorld())) {
            return;
        }
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])message));
        List entries = (List)friendlyByteBuf.a(PacketDataSerializer.a(ArrayList::new, (int)1000), buf -> ManipulateEntry.read(buf, player));
        WorldServer serverLevel = ((CraftWorld)player.getWorld()).getHandle();
        List whitelistedEntities = this.plugin.configuration.getStringList("whitelist-entities");
        List blacklistedEntities = this.plugin.configuration.getStringList("blacklist-entities");
        block6: for (ManipulateEntry entry : entries) {
            AxiomManipulateEntityEvent manipulateEvent;
            net.minecraft.world.entity.Entity entity = serverLevel.a(entry.uuid);
            if (entity == null || entity instanceof EntityHuman || entity.a(ManipulateEntityPacketListener::isPlayer)) continue;
            String type = EntityTypes.a((EntityTypes)entity.am()).toString();
            if (!whitelistedEntities.isEmpty() && !whitelistedEntities.contains(type) || blacklistedEntities.contains(type)) continue;
            Vec3D position = entity.dm();
            BlockPosition containing = BlockPosition.a((double)position.c, (double)position.d, (double)position.e);
            if (!Integration.canPlaceBlock(player, new Location(player.getWorld(), (double)containing.u(), (double)containing.v(), (double)containing.w())) || !(manipulateEvent = new AxiomManipulateEntityEvent(player, (Entity)entity.getBukkitEntity())).callEvent()) continue;
            if (entry.merge != null && !entry.merge.g()) {
                NbtSanitization.sanitizeEntity(entry.merge);
                NBTTagCompound compoundTag = entity.f(new NBTTagCompound());
                compoundTag = ManipulateEntityPacketListener.merge(compoundTag, entry.merge);
                entity.g(compoundTag);
            }
            entity.o(position.c, position.d, position.e);
            Vec3D entryPos = entry.position();
            if (entryPos != null && entry.relativeMovementSet != null) {
                float newPitch;
                double newX = entry.relativeMovementSet.contains(RelativeMovement.a) ? entity.dm().c + entryPos.c : entryPos.c;
                double newY = entry.relativeMovementSet.contains(RelativeMovement.b) ? entity.dm().d + entryPos.d : entryPos.d;
                double newZ = entry.relativeMovementSet.contains(RelativeMovement.c) ? entity.dm().e + entryPos.e : entryPos.e;
                float newYaw = entry.relativeMovementSet.contains(RelativeMovement.d) ? entity.dE() + entry.yaw : entry.yaw;
                float f = newPitch = entry.relativeMovementSet.contains(RelativeMovement.e) ? entity.dG() + entry.pitch : entry.pitch;
                if (entity instanceof EntityHanging) {
                    EntityItemFrame itemFrame;
                    EntityHanging hangingEntity = (EntityHanging)entity;
                    float changedYaw = newYaw - entity.dE();
                    int rotations = Math.round(changedYaw / 90.0f);
                    hangingEntity.a(ROTATION_VALUES[rotations & 3]);
                    if (entity instanceof EntityItemFrame && (itemFrame = (EntityItemFrame)entity).cH().o() == EnumDirection.EnumAxis.b) {
                        itemFrame.b(itemFrame.F() - Math.round(changedYaw / 45.0f));
                    }
                }
                containing = BlockPosition.a((double)newX, (double)newY, (double)newZ);
                if (Integration.canPlaceBlock(player, new Location(player.getWorld(), (double)containing.u(), (double)containing.v(), (double)containing.w()))) {
                    entity.a(serverLevel, newX, newY, newZ, Set.of(), newYaw, newPitch);
                }
                entity.o(newYaw);
            }
            switch (entry.passengerManipulation.ordinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    entity.bI();
                    break;
                }
                case 2: {
                    String passengerType;
                    for (UUID passengerUuid : entry.passengers) {
                        net.minecraft.world.entity.Entity passenger = serverLevel.a(passengerUuid);
                        if (passenger == null || passenger.bS() || passenger instanceof EntityHuman || passenger.a(ManipulateEntityPacketListener::isPlayer)) continue;
                        passengerType = EntityTypes.a((EntityTypes)passenger.am()).toString();
                        if (!whitelistedEntities.isEmpty() && !whitelistedEntities.contains(passengerType) || blacklistedEntities.contains(passengerType) || passenger.cU().anyMatch(entity2 -> entity2 == entity)) continue;
                        position = passenger.dm();
                        containing = BlockPosition.a((double)position.c, (double)position.d, (double)position.e);
                        if (!Integration.canPlaceBlock(player, new Location(player.getWorld(), (double)containing.u(), (double)containing.v(), (double)containing.w()))) continue;
                        passenger.a(entity, true);
                    }
                    continue block6;
                }
                case 3: {
                    String passengerType;
                    for (UUID passengerUuid : entry.passengers) {
                        net.minecraft.world.entity.Entity vehicle;
                        net.minecraft.world.entity.Entity passenger = serverLevel.a(passengerUuid);
                        if (passenger == null || passenger == entity || passenger instanceof EntityHuman || passenger.a(ManipulateEntityPacketListener::isPlayer)) continue;
                        passengerType = EntityTypes.a((EntityTypes)passenger.am()).toString();
                        if (!whitelistedEntities.isEmpty() && !whitelistedEntities.contains(passengerType) || blacklistedEntities.contains(passengerType) || (vehicle = passenger.dc()) != entity) continue;
                        passenger.ad();
                    }
                    break;
                }
            }
        }
    }

    private static NBTTagCompound merge(NBTTagCompound left, NBTTagCompound right) {
        if (right.e("axiom:modify")) {
            right.r("axiom:modify");
            return right;
        }
        for (String key : right.e()) {
            NBTBase tag = right.c(key);
            if (tag instanceof NBTTagCompound) {
                NBTTagCompound compound = (NBTTagCompound)tag;
                if (compound.g()) {
                    left.r(key);
                    continue;
                }
                if (left.b(key, 10)) {
                    NBTTagCompound child = left.p(key);
                    child = ManipulateEntityPacketListener.merge(child, compound);
                    left.a(key, (NBTBase)child);
                    continue;
                }
                NBTTagCompound copied = compound.i();
                if (copied.e("axiom:modify")) {
                    copied.r("axiom:modify");
                }
                left.a(key, (NBTBase)copied);
                continue;
            }
            left.a(key, tag.d());
        }
        return left;
    }

    private static boolean isPlayer(net.minecraft.world.entity.Entity entity) {
        return entity instanceof EntityHuman;
    }

    public record ManipulateEntry(UUID uuid, @Nullable Set<RelativeMovement> relativeMovementSet, @Nullable Vec3D position, float yaw, float pitch, NBTTagCompound merge, PassengerManipulation passengerManipulation, List<UUID> passengers) {
        public static ManipulateEntry read(PacketDataSerializer friendlyByteBuf, Player player) {
            UUID uuid = friendlyByteBuf.n();
            byte flags = friendlyByteBuf.readByte();
            Set relativeMovementSet = null;
            Vec3D position = null;
            float yaw = 0.0f;
            float pitch = 0.0f;
            if (flags >= 0) {
                relativeMovementSet = RelativeMovement.a((int)flags);
                position = new Vec3D(friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble());
                yaw = friendlyByteBuf.readFloat();
                pitch = friendlyByteBuf.readFloat();
            }
            NBTTagCompound nbt = UnknownVersionHelper.readTagUnknown(friendlyByteBuf, player);
            PassengerManipulation passengerManipulation = (PassengerManipulation)friendlyByteBuf.b(PassengerManipulation.class);
            List passengers = List.of();
            if (passengerManipulation == PassengerManipulation.ADD_LIST || passengerManipulation == PassengerManipulation.REMOVE_LIST) {
                passengers = (List)friendlyByteBuf.a(PacketDataSerializer.a(ArrayList::new, (int)1000), buffer -> buffer.n());
            }
            return new ManipulateEntry(uuid, relativeMovementSet, position, yaw, pitch, nbt, passengerManipulation, passengers);
        }
    }

    public static enum PassengerManipulation {
        NONE,
        REMOVE_ALL,
        ADD_LIST,
        REMOVE_LIST;

    }
}

