/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet;

import com.google.common.util.concurrent.RateLimiter;
import com.moulberry.axiom.AxiomConstants;
import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.View;
import com.moulberry.axiom.WorldExtension;
import com.moulberry.axiom.blueprint.ServerBlueprintManager;
import com.moulberry.axiom.event.AxiomHandshakeEvent;
import com.moulberry.axiom.persistence.ItemStackDataType;
import com.moulberry.axiom.persistence.UUIDDataType;
import com.moulberry.axiom.viaversion.ViaVersionHelper;
import com.moulberry.axiom.world_properties.server.ServerWorldPropertiesRegistry;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.SharedConstants;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class HelloPacketListener
implements PluginMessageListener {
    private final AxiomPaper plugin;

    public HelloPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        try {
            this.process(player, message);
        }
        catch (Throwable t) {
            player.kick((Component)Component.text((String)("Error while processing packet " + channel + ": " + t.getMessage())));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void process(Player player, byte[] message) {
        World world;
        ServerWorldPropertiesRegistry serverWorldPropertiesRegistry;
        UUID activeView;
        if (!this.plugin.hasAxiomPermission(player)) {
            return;
        }
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])message));
        int apiVersion = friendlyByteBuf.l();
        if (apiVersion != 8) {
            String versions = " (C=" + apiVersion + " S=8)";
            TextComponent text = apiVersion < 8 ? Component.text((String)("Unable to use Axiom, you're on an outdated version! Please update to the latest version of Axiom to use it on this server." + versions)) : Component.text((String)("Unable to use Axiom, server hasn't updated Axiom yet." + versions));
            String unsupportedAxiomVersion = this.plugin.configuration.getString("unsupported-axiom-version");
            if (unsupportedAxiomVersion == null) {
                unsupportedAxiomVersion = "kick";
            }
            if (unsupportedAxiomVersion.equals("warn")) {
                player.sendMessage(text.color((TextColor)NamedTextColor.RED));
                return;
            }
            if (!unsupportedAxiomVersion.equals("ignore")) {
                player.kick((Component)text);
                return;
            }
        }
        int dataVersion = friendlyByteBuf.l();
        int protocolVersion = friendlyByteBuf.l();
        int serverDataVersion = SharedConstants.b().d().c();
        if (protocolVersion != SharedConstants.c()) {
            String incompatibleDataVersion = this.plugin.configuration.getString("incompatible-data-version");
            if (incompatibleDataVersion == null) {
                incompatibleDataVersion = "warn";
            }
            TextComponent incompatibleWarning = Component.text((String)("Axiom: Incompatible data version detected (client " + dataVersion + ", server " + serverDataVersion + ")"));
            if (!Bukkit.getPluginManager().isPluginEnabled("ViaVersion")) {
                if (incompatibleDataVersion.equals("warn")) {
                    player.sendMessage(incompatibleWarning.color((TextColor)NamedTextColor.RED));
                    return;
                }
                if (!incompatibleDataVersion.equals("ignore")) {
                    player.kick((Component)incompatibleWarning);
                    return;
                }
            } else {
                RegistryBlockID<IBlockData> mapper;
                try {
                    mapper = ViaVersionHelper.getBlockRegistryForVersion(this.plugin.allowedBlockRegistry, protocolVersion);
                }
                catch (Exception e) {
                    String clientDescription = "client: " + String.valueOf(ProtocolVersion.getProtocol((int)protocolVersion));
                    String serverDescription = "server: " + String.valueOf(ProtocolVersion.getProtocol((int)SharedConstants.c()));
                    String description = clientDescription + " <-> " + serverDescription;
                    TextComponent text = Component.text((String)("Axiom+ViaVersion: " + e.getMessage() + " (" + description + ")"));
                    if (incompatibleDataVersion.equals("warn")) {
                        player.sendMessage(text.color((TextColor)NamedTextColor.RED));
                    } else {
                        player.kick((Component)text);
                    }
                    return;
                }
                this.plugin.playerBlockRegistry.put(player.getUniqueId(), mapper);
                this.plugin.playerProtocolVersion.put(player.getUniqueId(), protocolVersion);
                TextComponent text = Component.text((String)"Axiom: Warning, client and server versions don't match. Axiom will try to use ViaVersion conversions, but this process may cause problems");
                player.sendMessage(text.color((TextColor)NamedTextColor.RED));
            }
        }
        int maxBufferSize = this.plugin.configuration.getInt("max-block-buffer-packet-size");
        AxiomHandshakeEvent handshakeEvent = new AxiomHandshakeEvent(player, maxBufferSize);
        Bukkit.getPluginManager().callEvent((Event)handshakeEvent);
        if (handshakeEvent.isCancelled()) {
            return;
        }
        this.plugin.activeAxiomPlayers.add(player.getUniqueId());
        int rateLimit = this.plugin.configuration.getInt("block-buffer-rate-limit");
        if (rateLimit > 0) {
            this.plugin.playerBlockBufferRateLimiters.putIfAbsent(player.getUniqueId(), RateLimiter.create((double)rateLimit));
        }
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), (IRegistryCustom)MinecraftServer.getServer().bc());
        buf.a(true);
        buf.p(handshakeEvent.getMaxBufferSize());
        buf.a(false);
        buf.a(false);
        buf.c(5);
        buf.c(16);
        buf.a(true);
        byte[] enableBytes = new byte[buf.writerIndex()];
        buf.a(0, enableBytes);
        player.sendPluginMessage((Plugin)this.plugin, "axiom:enable", enableBytes);
        PersistentDataContainer container = player.getPersistentDataContainer();
        if (!this.plugin.isMismatchedDataVersion(player.getUniqueId())) {
            byte activeHotbarIndex = (Byte)container.getOrDefault(AxiomConstants.ACTIVE_HOTBAR_INDEX, PersistentDataType.BYTE, (Object)0);
            PersistentDataContainer hotbarItems = (PersistentDataContainer)container.get(AxiomConstants.HOTBAR_DATA, PersistentDataType.TAG_CONTAINER);
            if (hotbarItems != null) {
                void var16_28;
                buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), (IRegistryCustom)MinecraftServer.getServer().bc());
                buf.k((int)activeHotbarIndex);
                boolean bl = false;
                while (var16_28 < 81) {
                    if (var16_28 / 9 == activeHotbarIndex) {
                        net.minecraft.world.item.ItemStack.h.encode((Object)buf, (Object)net.minecraft.world.item.ItemStack.l);
                    } else {
                        ItemStack stack = (ItemStack)hotbarItems.get(new NamespacedKey("axiom", "slot_" + (int)var16_28), (PersistentDataType)ItemStackDataType.INSTANCE);
                        net.minecraft.world.item.ItemStack.h.encode((Object)buf, (Object)CraftItemStack.asNMSCopy((ItemStack)stack));
                    }
                    ++var16_28;
                }
                byte[] byArray = new byte[buf.writerIndex()];
                buf.a(0, byArray);
                player.sendPluginMessage((Plugin)this.plugin, "axiom:initialize_hotbars", byArray);
            }
        }
        if ((activeView = (UUID)container.get(AxiomConstants.ACTIVE_VIEW, (PersistentDataType)UUIDDataType.INSTANCE)) != null) {
            buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), (IRegistryCustom)MinecraftServer.getServer().bc());
            buf.a(activeView);
            PersistentDataContainer[] views = (PersistentDataContainer[])container.get(AxiomConstants.VIEWS, PersistentDataType.TAG_CONTAINER_ARRAY);
            buf.c(views.length);
            for (PersistentDataContainer view : views) {
                View.load(view).write((PacketDataSerializer)buf);
            }
            byte[] byArray = new byte[buf.writerIndex()];
            buf.a(0, byArray);
            player.sendPluginMessage((Plugin)this.plugin, "axiom:set_editor_views", byArray);
        }
        if ((serverWorldPropertiesRegistry = this.plugin.getOrCreateWorldProperties(world = player.getWorld())) == null) {
            player.sendPluginMessage((Plugin)this.plugin, "axiom:register_world_properties", new byte[]{0});
        } else {
            serverWorldPropertiesRegistry.registerFor((Plugin)this.plugin, player);
        }
        WorldExtension.onPlayerJoin(world, player);
        ServerBlueprintManager.sendManifest(List.of(((CraftPlayer)player).getHandle()));
    }
}

