/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.integration.Integration;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class DeleteEntityPacketListener
implements PluginMessageListener {
    private final AxiomPaper plugin;

    public DeleteEntityPacketListener(AxiomPaper plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        try {
            this.process(player, message);
        }
        catch (Throwable t) {
            player.kick((Component)Component.text((String)("Error while processing packet " + channel + ": " + t.getMessage())));
        }
    }

    private void process(Player player, byte[] message) {
        if (!this.plugin.canUseAxiom(player, "axiom.entity.delete", true)) {
            return;
        }
        if (!this.plugin.canModifyWorld(player, player.getWorld())) {
            return;
        }
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])message));
        List delete = (List)friendlyByteBuf.a(PacketDataSerializer.a(ArrayList::new, (int)1000), buf -> buf.n());
        WorldServer serverLevel = ((CraftWorld)player.getWorld()).getHandle();
        List whitelistedEntities = this.plugin.configuration.getStringList("whitelist-entities");
        List blacklistedEntities = this.plugin.configuration.getStringList("blacklist-entities");
        for (UUID uuid : delete) {
            Entity entity = serverLevel.a(uuid);
            if (entity == null || entity instanceof EntityHuman || entity.a(e -> e instanceof EntityHuman)) continue;
            String type = EntityTypes.a((EntityTypes)entity.am()).toString();
            if (!whitelistedEntities.isEmpty() && !whitelistedEntities.contains(type) || blacklistedEntities.contains(type) || !Integration.canBreakBlock(player, player.getWorld().getBlockAt(entity.ds(), entity.du(), entity.dy()))) continue;
            entity.a(Entity.RemovalReason.b);
        }
    }
}

