/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packet;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.packet.RequestChunkDataPacketListener;
import com.moulberry.axiom.packet.SetBlockBufferPacketListener;
import com.moulberry.axiom.packet.UpdateAnnotationPacketListener;
import com.moulberry.axiom.packet.UploadBlueprintPacketListener;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.papermc.paper.network.ConnectionEvent;
import java.io.IOException;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.entity.Player;

public class AxiomBigPayloadHandler
extends MessageToMessageDecoder<ByteBuf> {
    private static final MinecraftKey SET_BUFFER = VersionHelper.createResourceLocation("axiom", "set_buffer");
    private static final MinecraftKey UPLOAD_BLUEPRINT = VersionHelper.createResourceLocation("axiom", "upload_blueprint");
    private static final MinecraftKey UPDATE_ANNOTATIONS = VersionHelper.createResourceLocation("axiom", "annotation_update");
    private static final MinecraftKey REQUEST_CHUNK_DATA = VersionHelper.createResourceLocation("axiom", "request_chunk_data");
    private final int payloadId;
    private final NetworkManager connection;
    private final SetBlockBufferPacketListener setBlockBuffer;
    private final UploadBlueprintPacketListener uploadBlueprint;
    private final UpdateAnnotationPacketListener updateAnnotation;
    private final RequestChunkDataPacketListener requestChunkDataPacketListener;

    public AxiomBigPayloadHandler(int payloadId, NetworkManager connection, SetBlockBufferPacketListener setBlockBuffer, UploadBlueprintPacketListener uploadBlueprint, UpdateAnnotationPacketListener updateAnnotation, RequestChunkDataPacketListener requestChunkDataPacketListener) {
        this.payloadId = payloadId;
        this.connection = connection;
        this.setBlockBuffer = setBlockBuffer;
        this.uploadBlueprint = uploadBlueprint;
        this.updateAnnotation = updateAnnotation;
        this.requestChunkDataPacketListener = requestChunkDataPacketListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() == 0) {
            return;
        }
        EntityPlayer player = this.connection.getPlayer();
        if (player == null || !AxiomPaper.PLUGIN.canUseAxiom((Player)player.getBukkitEntity())) {
            out.add(in.retain());
            return;
        }
        if (!ctx.channel().isActive()) {
            in.skipBytes(in.readableBytes());
            return;
        }
        int readerIndex = in.readerIndex();
        boolean success = false;
        try {
            PacketDataSerializer buf = new PacketDataSerializer(in);
            int packetId = buf.l();
            if (packetId == this.payloadId) {
                MinecraftKey identifier = buf.q();
                if (identifier.equals((Object)SET_BUFFER)) {
                    this.setBlockBuffer.onReceive(player, buf);
                    success = true;
                    if (in.readableBytes() > 0) {
                        throw new IOException("Axiom packet " + String.valueOf(identifier) + " was larger than I expected, found " + in.readableBytes() + " bytes extra whilst reading packet");
                    }
                    return;
                }
                if (identifier.equals((Object)UPLOAD_BLUEPRINT)) {
                    this.uploadBlueprint.onReceive(player, buf);
                    success = true;
                    if (in.readableBytes() > 0) {
                        throw new IOException("Axiom packet " + String.valueOf(identifier) + " was larger than I expected, found " + in.readableBytes() + " bytes extra whilst reading packet");
                    }
                    return;
                }
                if (identifier.equals((Object)UPDATE_ANNOTATIONS)) {
                    this.updateAnnotation.onReceive(player, buf);
                    success = true;
                    if (in.readableBytes() > 0) {
                        throw new IOException("Axiom packet " + String.valueOf(identifier) + " was larger than I expected, found " + in.readableBytes() + " bytes extra whilst reading packet");
                    }
                    return;
                }
                if (this.requestChunkDataPacketListener != null && identifier.equals((Object)REQUEST_CHUNK_DATA)) {
                    byte[] bytes = new byte[buf.writerIndex() - buf.readerIndex()];
                    buf.a(buf.readerIndex(), bytes);
                    player.cO().execute(() -> {
                        try {
                            this.requestChunkDataPacketListener.onPluginMessageReceived(identifier.toString(), (Player)player.getBukkitEntity(), bytes);
                        }
                        catch (Throwable t) {
                            player.getBukkitEntity().kick((Component)Component.text((String)("An error occured while requesting chunk data: " + t.getMessage())));
                        }
                    });
                    success = true;
                    in.skipBytes(in.readableBytes());
                    return;
                }
            }
        }
        catch (Throwable t) {
            if (!(t instanceof IndexOutOfBoundsException)) {
                success = true;
                in.skipBytes(in.readableBytes());
                throw t;
            }
        }
        finally {
            if (!success) {
                in.readerIndex(readerIndex);
            }
        }
        out.add(in.retain());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == ConnectionEvent.COMPRESSION_THRESHOLD_SET || evt == ConnectionEvent.COMPRESSION_DISABLED) {
            ctx.channel().pipeline().remove("axiom-big-payload-handler");
            ctx.channel().pipeline().addBefore("decoder", "axiom-big-payload-handler", (ChannelHandler)new AxiomBigPayloadHandler(this.payloadId, this.connection, this.setBlockBuffer, this.uploadBlueprint, this.updateAnnotation, this.requestChunkDataPacketListener));
        }
        super.userEventTriggered(ctx, evt);
    }
}

