/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.marker;

import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.phys.Vec3D;
import org.jetbrains.annotations.Nullable;
import xyz.jpenilla.reflectionremapper.ReflectionRemapper;

public record MarkerData(UUID uuid, Vec3D position, @Nullable String name, @Nullable Vec3D minRegion, @Nullable Vec3D maxRegion, int lineArgb, float lineThickness, int faceArgb) {
    private static final Field dataField;

    public static MarkerData read(PacketDataSerializer friendlyByteBuf) {
        UUID uuid = friendlyByteBuf.n();
        Vec3D position = new Vec3D(friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble());
        String name = (String)friendlyByteBuf.c(PacketDataSerializer::p);
        Vec3D minRegion = null;
        Vec3D maxRegion = null;
        int lineArgb = 0;
        float lineThickness = 0.0f;
        int faceArgb = 0;
        byte flags = friendlyByteBuf.readByte();
        if (flags != 0) {
            minRegion = new Vec3D(friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble());
            maxRegion = new Vec3D(friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble());
            if ((flags & 2) != 0) {
                lineArgb = friendlyByteBuf.readInt();
            }
            if ((flags & 4) != 0) {
                lineThickness = friendlyByteBuf.readFloat();
            }
            if ((flags & 8) != 0) {
                faceArgb = friendlyByteBuf.readInt();
            }
        }
        return new MarkerData(uuid, position, name, minRegion, maxRegion, lineArgb, lineThickness, faceArgb);
    }

    public static void write(PacketDataSerializer friendlyByteBuf, MarkerData markerData) {
        friendlyByteBuf.a(markerData.uuid);
        friendlyByteBuf.a(markerData.position.c);
        friendlyByteBuf.a(markerData.position.d);
        friendlyByteBuf.a(markerData.position.e);
        friendlyByteBuf.a((Object)markerData.name, PacketDataSerializer::a);
        if (markerData.minRegion != null && markerData.maxRegion != null) {
            int flags = 1;
            if (markerData.lineArgb != 0) {
                flags = (byte)(flags | 2);
            }
            if (markerData.lineThickness != 0.0f) {
                flags = (byte)(flags | 4);
            }
            if (markerData.faceArgb != 0) {
                flags = (byte)(flags | 8);
            }
            friendlyByteBuf.k(flags);
            friendlyByteBuf.a(markerData.minRegion.c);
            friendlyByteBuf.a(markerData.minRegion.d);
            friendlyByteBuf.a(markerData.minRegion.e);
            friendlyByteBuf.a(markerData.maxRegion.c);
            friendlyByteBuf.a(markerData.maxRegion.d);
            friendlyByteBuf.a(markerData.maxRegion.e);
            if (markerData.lineArgb != 0) {
                friendlyByteBuf.p(markerData.lineArgb);
            }
            if (markerData.lineThickness != 0.0f) {
                friendlyByteBuf.a(markerData.lineThickness);
            }
            if (markerData.faceArgb != 0) {
                friendlyByteBuf.p(markerData.faceArgb);
            }
        } else {
            friendlyByteBuf.k(0);
        }
    }

    public static NBTTagCompound getData(Marker marker) {
        try {
            return (NBTTagCompound)dataField.get(marker);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static MarkerData createFrom(Marker marker) {
        Vec3D position = marker.dm();
        NBTTagCompound data = MarkerData.getData(marker);
        String name = data.l("name").trim();
        if (name.isEmpty()) {
            name = null;
        }
        Vec3D minRegion = null;
        Vec3D maxRegion = null;
        int lineArgb = 0;
        float lineThickness = 0.0f;
        int faceArgb = 0;
        if (data.b("min", 9) && data.b("max", 9)) {
            NBTTagList min = data.c("min", 6);
            NBTTagList max = data.c("max", 6);
            if (min.size() == 3 && max.size() == 3) {
                double minX = min.h(0);
                double minY = min.h(1);
                double minZ = min.h(2);
                double maxX = max.h(0);
                double maxY = max.h(1);
                double maxZ = max.h(2);
                minRegion = new Vec3D(minX, minY, minZ);
                maxRegion = new Vec3D(maxX, maxY, maxZ);
                if (data.b("line_argb", 99)) {
                    lineArgb = data.h("line_argb");
                }
                if (data.b("line_thickness", 99)) {
                    lineThickness = data.h("line_thickness");
                }
                if (data.b("face_argb", 99)) {
                    faceArgb = data.h("face_argb");
                }
            }
        }
        return new MarkerData(marker.cz(), position, name, minRegion, maxRegion, lineArgb, lineThickness, faceArgb);
    }

    static {
        ReflectionRemapper reflectionRemapper = ReflectionRemapper.forReobfMappingsInPaperJar();
        String fieldName = reflectionRemapper.remapFieldName(Marker.class, "data");
        try {
            dataField = Marker.class.getDeclaredField(fieldName);
            dataField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

