/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.integration.coreprotect;

import com.moulberry.axiom.AxiomPaper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.coreprotect.CoreProtect;
import net.coreprotect.CoreProtectAPI;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.plugin.Plugin;

public class CoreProtectIntegrationImpl {
    private static final CoreProtectAPI COREPROTECT_API = CoreProtectIntegrationImpl.getCoreProtect();
    private static final boolean COREPROTECT_ENABLED;
    private static final Constructor<CraftBlockState> CRAFT_BLOCK_STATE_CONSTRUCTOR;

    private static CoreProtectAPI getCoreProtect() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("CoreProtect");
        if (!(plugin instanceof CoreProtect)) {
            return null;
        }
        CoreProtectAPI coreProtect = ((CoreProtect)plugin).getAPI();
        if (!coreProtect.isEnabled()) {
            return null;
        }
        if (coreProtect.APIVersion() < 10) {
            return null;
        }
        return coreProtect;
    }

    private static CraftBlockState createCraftBlockState(World world, BlockPosition pos, IBlockData blockState) {
        try {
            return CRAFT_BLOCK_STATE_CONSTRUCTOR.newInstance(world, pos, blockState);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            AxiomPaper.PLUGIN.getLogger().warning("Failed to create CraftBlockState for CoreProtect: " + String.valueOf(e));
            return null;
        }
    }

    static boolean isEnabled() {
        return COREPROTECT_ENABLED;
    }

    static void logPlacement(String name, IBlockData blockState, CraftWorld world, BlockPosition pos) {
        if (blockState.i()) {
            return;
        }
        COREPROTECT_API.logPlacement(name, (BlockState)CoreProtectIntegrationImpl.createCraftBlockState((World)world, pos, blockState));
    }

    static void logRemoval(String name, IBlockData blockState, CraftWorld world, BlockPosition pos) {
        COREPROTECT_API.logRemoval(name, (BlockState)CoreProtectIntegrationImpl.createCraftBlockState((World)world, pos, blockState));
    }

    static {
        Constructor constructor = null;
        if (COREPROTECT_API != null) {
            try {
                constructor = CraftBlockState.class.getDeclaredConstructor(World.class, BlockPosition.class, IBlockData.class);
                constructor.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException e) {
                AxiomPaper.PLUGIN.getLogger().warning("Failed to get CraftBlockState constructor for CoreProtect: " + String.valueOf(e));
            }
        }
        CRAFT_BLOCK_STATE_CONSTRUCTOR = constructor;
        COREPROTECT_ENABLED = COREPROTECT_API != null && CRAFT_BLOCK_STATE_CONSTRUCTOR != null;
    }
}

