/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.commands;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.Restrictions;
import com.moulberry.axiom.integration.Integration;
import com.moulberry.axiom.integration.plotsquared.PlotSquaredIntegration;
import com.moulberry.axiom.integration.worldguard.WorldGuardIntegration;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.incendo.cloud.Command;
import org.incendo.cloud.bukkit.BukkitCommandManager;
import org.incendo.cloud.parser.standard.EnumParser;
import org.incendo.cloud.parser.standard.StringParser;
import org.incendo.cloud.permission.PredicatePermission;

public class AxiomDebugCommand {
    private static final UUID MOULBERRY_UUID = UUID.fromString("d0e05de7-6067-454d-beae-c6d19d886191");

    public static void register(AxiomPaper axiomPaper, BukkitCommandManager<CommandSender> manager) {
        manager.command(AxiomDebugCommand.base(manager, "hasAxiomPermission").handler(context -> {
            Object patt0$temp = context.sender();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            boolean hasAxiomPermission = axiomPaper.hasAxiomPermission(player);
            ((CommandSender)context.sender()).sendMessage((Component)Component.text((String)("hasAxiomPermission: " + hasAxiomPermission)));
        }));
        manager.command(AxiomDebugCommand.base(manager, "canUseAxiom").handler(context -> {
            Object patt0$temp = context.sender();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            boolean canUseAxiom = axiomPaper.canUseAxiom(player);
            ((CommandSender)context.sender()).sendMessage((Component)Component.text((String)("canUseAxiom: " + canUseAxiom)));
        }));
        manager.command(AxiomDebugCommand.base(manager, "isMismatchedDataVersion").handler(context -> {
            Object patt0$temp = context.sender();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            boolean isMismatchedDataVersion = axiomPaper.isMismatchedDataVersion(player.getUniqueId());
            ((CommandSender)context.sender()).sendMessage((Component)Component.text((String)("isMismatchedDataVersion: " + isMismatchedDataVersion)));
        }));
        manager.command(AxiomDebugCommand.base(manager, "canModifyWorld").handler(context -> {
            Object patt0$temp = context.sender();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            boolean canModifyWorld = axiomPaper.canModifyWorld(player, player.getWorld());
            ((CommandSender)context.sender()).sendMessage((Component)Component.text((String)("canModifyWorld: " + canModifyWorld)));
        }));
        manager.command(AxiomDebugCommand.base(manager, "isClientListening").required("channel", StringParser.greedyStringParser()).handler(context -> {
            Object patt0$temp = context.sender();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            String channel = (String)context.get("channel");
            boolean isClientListening = player.getListeningPluginChannels().contains(channel);
            ((CommandSender)context.sender()).sendMessage((Component)Component.text((String)("listening to " + channel + ": " + isClientListening)));
        }));
        manager.command(AxiomDebugCommand.base(manager, "hasPermission").required("permission", StringParser.greedyStringParser()).handler(context -> {
            String permission = (String)context.get("permission");
            boolean hasPermission = ((CommandSender)context.sender()).hasPermission(permission);
            ((CommandSender)context.sender()).sendMessage((Component)Component.text((String)("has permission " + permission + ": " + hasPermission)));
        }));
        manager.command(AxiomDebugCommand.base(manager, "getRestrictions").handler(context -> {
            Object patt0$temp = context.sender();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            Restrictions restrictions = axiomPaper.playerRestrictions.get(player.getUniqueId());
            if (restrictions == null) {
                ((CommandSender)context.sender()).sendMessage((Component)Component.text((String)"no restrictions"));
            } else {
                ((CommandSender)context.sender()).sendMessage((Component)Component.text((String)("restrictions: " + String.valueOf(restrictions))));
            }
        }));
        static enum IntegrationType {
            PLOT_SQUARED,
            WORLD_GUARD;

        }
        manager.command(AxiomDebugCommand.base(manager, "canBreakBlockAtCurrentPosition").optional("type", EnumParser.enumParser(IntegrationType.class)).handler(context -> {
            Object patt0$temp = context.sender();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            IntegrationType integrationType = context.optional("type").orElse(null);
            Block block = player.getWorld().getBlockAt(player.getLocation());
            boolean canBreakBlock = integrationType == IntegrationType.PLOT_SQUARED ? PlotSquaredIntegration.canBreakBlock(player, block) : (integrationType == IntegrationType.WORLD_GUARD ? WorldGuardIntegration.canBreakBlock(player, block.getLocation()) : Integration.canBreakBlock(player, block));
            ((CommandSender)context.sender()).sendMessage((Component)Component.text((String)("canBreakBlock: " + canBreakBlock)));
        }));
        manager.command(AxiomDebugCommand.base(manager, "canPlaceBlockAtCurrentPosition").optional("type", EnumParser.enumParser(IntegrationType.class)).handler(context -> {
            Object patt0$temp = context.sender();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            IntegrationType integrationType = context.optional("type").orElse(null);
            boolean canPlaceBlock = integrationType == IntegrationType.PLOT_SQUARED ? PlotSquaredIntegration.canPlaceBlock(player, player.getLocation()) : (integrationType == IntegrationType.WORLD_GUARD ? WorldGuardIntegration.canPlaceBlock(player, player.getLocation()) : Integration.canPlaceBlock(player, player.getLocation()));
            ((CommandSender)context.sender()).sendMessage((Component)Component.text((String)("canPlaceBlock: " + canPlaceBlock)));
        }));
        manager.command(AxiomDebugCommand.base(manager, "isPlotWorld").handler(context -> {
            Object patt0$temp = context.sender();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            boolean isPlotWorld = PlotSquaredIntegration.isPlotWorld(player.getWorld());
            ((CommandSender)context.sender()).sendMessage((Component)Component.text((String)("isPlotWorld: " + isPlotWorld)));
        }));
        manager.command(AxiomDebugCommand.base(manager, "getCurrentEditablePlot").handler(context -> {
            Object patt0$temp = context.sender();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            PlotSquaredIntegration.PlotBounds plotBounds = PlotSquaredIntegration.getCurrentEditablePlot(player);
            ((CommandSender)context.sender()).sendMessage((Component)Component.text((String)("plotBounds: " + String.valueOf(plotBounds))));
        }));
    }

    private static Command.Builder<CommandSender> base(BukkitCommandManager<CommandSender> manager, String subcommand) {
        return manager.commandBuilder("axiompaperdebug", new String[0]).literal(subcommand, new String[0]).senderType(CommandSender.class).permission(PredicatePermission.of(sender -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                return player.hasPermission("axiom.debug") || player.getUniqueId().equals(MOULBERRY_UUID);
            }
            return false;
        }));
    }
}

