/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.blueprint;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.blueprint.BlueprintIo;
import com.moulberry.axiom.blueprint.RawBlueprint;
import com.moulberry.axiom.blueprint.ServerBlueprintRegistry;
import io.netty.buffer.Unpooled;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class ServerBlueprintManager {
    private static ServerBlueprintRegistry registry = null;
    private static final int MAX_SIZE = 1000000;
    private static final MinecraftKey PACKET_BLUEPRINT_MANIFEST_IDENTIFIER = VersionHelper.createResourceLocation("axiom:blueprint_manifest");

    public static void initialize(Path blueprintDirectory) {
        HashMap<String, RawBlueprint> map = new HashMap<String, RawBlueprint>();
        ServerBlueprintManager.loadRegistryFromFolder(map, blueprintDirectory, "/");
        registry = new ServerBlueprintRegistry(map);
    }

    public static void sendManifest(List<EntityPlayer> serverPlayers) {
        if (registry != null) {
            ArrayList<EntityPlayer> sendTo = new ArrayList<EntityPlayer>();
            for (EntityPlayer entityPlayer : serverPlayers) {
                CraftPlayer craftPlayer = entityPlayer.getBukkitEntity();
                if (!AxiomPaper.PLUGIN.canUseAxiom((Player)craftPlayer) || !craftPlayer.getListeningPluginChannels().contains("axiom:blueprint_manifest")) continue;
                sendTo.add(entityPlayer);
            }
            if (sendTo.isEmpty()) {
                return;
            }
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
            buf.a(true);
            for (Map.Entry<String, RawBlueprint> entry : registry.blueprints().entrySet()) {
                buf.a(entry.getKey());
                RawBlueprint.writeHeader(buf, entry.getValue());
                if (buf.writerIndex() <= 1000000) continue;
                buf.a("");
                byte[] byArray = new byte[buf.writerIndex()];
                buf.a(0, byArray);
                for (EntityPlayer entityPlayer : sendTo) {
                    VersionHelper.sendCustomPayload(entityPlayer, PACKET_BLUEPRINT_MANIFEST_IDENTIFIER, byArray);
                }
                buf = new PacketDataSerializer(Unpooled.buffer());
                buf.a(false);
            }
            buf.a("");
            byte[] byArray = new byte[buf.writerIndex()];
            buf.a(0, byArray);
            for (EntityPlayer entityPlayer : sendTo) {
                VersionHelper.sendCustomPayload(entityPlayer, PACKET_BLUEPRINT_MANIFEST_IDENTIFIER, byArray);
            }
        }
    }

    public static ServerBlueprintRegistry getRegistry() {
        return registry;
    }

    private static void loadRegistryFromFolder(Map<String, RawBlueprint> map, Path folder, String location) {
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(folder);){
            for (Path path : directoryStream) {
                String filename = path.getFileName().toString();
                if (filename.endsWith(".bp")) {
                    try {
                        RawBlueprint rawBlueprint = BlueprintIo.readRawBlueprint(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));
                        String newLocation = location + filename.substring(0, filename.length() - 3);
                        map.put(newLocation, rawBlueprint);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                String newLocation = location + filename + "/";
                ServerBlueprintManager.loadRegistryFromFolder(map, path, newLocation);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

