/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.blueprint;

import com.moulberry.axiom.blueprint.BlueprintHeader;
import com.moulberry.axiom.buffer.CompressedBlockEntity;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.core.Registry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.DataPaletteBlock;

public record RawBlueprint(BlueprintHeader header, byte[] thumbnail, Long2ObjectMap<DataPaletteBlock<IBlockData>> blocks, Long2ObjectMap<CompressedBlockEntity> blockEntities) {
    public static void writeHeader(PacketDataSerializer friendlyByteBuf, RawBlueprint rawBlueprint) {
        rawBlueprint.header.write(friendlyByteBuf);
        friendlyByteBuf.a(rawBlueprint.thumbnail);
    }

    public static RawBlueprint readHeader(PacketDataSerializer friendlyByteBuf) {
        BlueprintHeader header = BlueprintHeader.read(friendlyByteBuf);
        byte[] thumbnail = friendlyByteBuf.b();
        return new RawBlueprint(header, thumbnail, null, null);
    }

    public static void write(PacketDataSerializer friendlyByteBuf, RawBlueprint rawBlueprint) {
        rawBlueprint.header.write(friendlyByteBuf);
        friendlyByteBuf.a(rawBlueprint.thumbnail);
        LongSet chunkKeys = rawBlueprint.blocks.keySet();
        friendlyByteBuf.c(chunkKeys.size());
        LongIterator longIterator = chunkKeys.longIterator();
        while (longIterator.hasNext()) {
            long pos = longIterator.nextLong();
            friendlyByteBuf.b(pos);
            ((DataPaletteBlock)rawBlueprint.blocks.get(pos)).b(friendlyByteBuf);
        }
        LongSet blockEntityKeys = rawBlueprint.blockEntities.keySet();
        friendlyByteBuf.c(blockEntityKeys.size());
        longIterator = blockEntityKeys.longIterator();
        while (longIterator.hasNext()) {
            long pos = longIterator.nextLong();
            friendlyByteBuf.b(pos);
            ((CompressedBlockEntity)rawBlueprint.blockEntities.get(pos)).write(friendlyByteBuf);
        }
    }

    public static RawBlueprint read(PacketDataSerializer friendlyByteBuf) {
        BlueprintHeader header = BlueprintHeader.read(friendlyByteBuf);
        byte[] thumbnail = friendlyByteBuf.b();
        Long2ObjectOpenHashMap blocks = new Long2ObjectOpenHashMap();
        int chunkCount = friendlyByteBuf.l();
        for (int i = 0; i < chunkCount; ++i) {
            long pos = friendlyByteBuf.readLong();
            DataPaletteBlock palettedContainer = new DataPaletteBlock((Registry)Block.q, (Object)Blocks.kN.o(), DataPaletteBlock.d.d);
            palettedContainer.a(friendlyByteBuf);
            blocks.put(pos, (Object)palettedContainer);
        }
        Long2ObjectOpenHashMap blockEntities = new Long2ObjectOpenHashMap();
        int blockEntityCount = friendlyByteBuf.l();
        for (int i = 0; i < blockEntityCount; ++i) {
            long pos = friendlyByteBuf.readLong();
            CompressedBlockEntity compressedBlockEntity = CompressedBlockEntity.read(friendlyByteBuf);
            blockEntities.put(pos, (Object)compressedBlockEntity);
        }
        return new RawBlueprint(header, thumbnail, (Long2ObjectMap<DataPaletteBlock<IBlockData>>)blocks, (Long2ObjectMap<CompressedBlockEntity>)blockEntities);
    }
}

