/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.blueprint;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.PacketDataSerializer;

public record BlueprintHeader(String name, String author, List<String> tags, float thumbnailYaw, float thumbnailPitch, boolean lockedThumbnail, int blockCount) {
    private static final int CURRENT_VERSION = 0;

    public void write(PacketDataSerializer friendlyByteBuf) {
        friendlyByteBuf.a(this.name);
        friendlyByteBuf.a(this.author);
        friendlyByteBuf.a(this.tags, PacketDataSerializer::a);
        friendlyByteBuf.p(this.blockCount);
    }

    public static BlueprintHeader read(PacketDataSerializer friendlyByteBuf) {
        String name = friendlyByteBuf.p();
        String author = friendlyByteBuf.p();
        List tags = (List)friendlyByteBuf.a(PacketDataSerializer.a(ArrayList::new, (int)1000), PacketDataSerializer::p);
        int blockCount = friendlyByteBuf.readInt();
        return new BlueprintHeader(name, author, tags, 0.0f, 0.0f, true, blockCount);
    }

    public static BlueprintHeader load(NBTTagCompound tag) {
        long version = tag.i("Version");
        String name = tag.l("Name");
        String author = tag.l("Author");
        float thumbnailYaw = tag.b("ThumbnailYaw", 5) ? tag.j("ThumbnailYaw") : 135.0f;
        float thumbnailPitch = tag.b("ThumbnailPitch", 5) ? tag.j("ThumbnailPitch") : 30.0f;
        boolean lockedThumbnail = tag.q("LockedThumbnail");
        int blockCount = tag.h("BlockCount");
        ArrayList<String> tags = new ArrayList<String>();
        for (NBTBase string : tag.c("Tags", 8)) {
            tags.add(string.s_());
        }
        return new BlueprintHeader(name, author, tags, thumbnailYaw, thumbnailPitch, lockedThumbnail, blockCount);
    }

    public NBTTagCompound save(NBTTagCompound tag) {
        NBTTagList listTag = new NBTTagList();
        for (String string : this.tags) {
            listTag.add((Object)NBTTagString.a((String)string));
        }
        tag.a("Version", 0L);
        tag.a("Name", this.name);
        tag.a("Author", this.author);
        tag.a("Tags", (NBTBase)listTag);
        tag.a("ThumbnailYaw", this.thumbnailYaw);
        tag.a("ThumbnailPitch", this.thumbnailPitch);
        tag.a("LockedThumbnail", this.lockedThumbnail);
        tag.a("BlockCount", this.blockCount);
        return tag;
    }
}

