/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.annotations;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.annotations.AnnotationUpdateAction;
import com.moulberry.axiom.annotations.ServerAnnotationsAdapater;
import com.moulberry.axiom.annotations.data.AnnotationData;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ServerAnnotations {
    private static final WeakHashMap<World, ServerAnnotations> serverAnnotationCache = new WeakHashMap();
    private static final NamespacedKey ANNOTATION_DATA_KEY = new NamespacedKey((Plugin)AxiomPaper.PLUGIN, "annotation_data");
    final LinkedHashMap<UUID, AnnotationData> annotations = new LinkedHashMap();

    private static void sendAnnotationUpdates(List<AnnotationUpdateAction> actions, List<EntityPlayer> players) {
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.buffer());
        friendlyByteBuf.a(actions, (buffer, action) -> action.write((PacketDataSerializer)buffer));
        byte[] bytes = new byte[friendlyByteBuf.writerIndex()];
        friendlyByteBuf.a(0, bytes);
        for (EntityPlayer serverPlayer : players) {
            VersionHelper.sendCustomPayload(serverPlayer, VersionHelper.createResourceLocation("axiom:annotation_update"), bytes);
        }
    }

    public static void sendAll(World world, EntityPlayer player) {
        if (!AxiomPaper.PLUGIN.allowAnnotations) {
            return;
        }
        ArrayList<AnnotationUpdateAction> actions = new ArrayList<AnnotationUpdateAction>();
        actions.add(new AnnotationUpdateAction.ClearAllAnnotations());
        ServerAnnotations serverAnnotations = serverAnnotationCache.get(world);
        if (serverAnnotations == null) {
            serverAnnotations = (ServerAnnotations)world.getPersistentDataContainer().get(ANNOTATION_DATA_KEY, (PersistentDataType)ServerAnnotationsAdapater.INSTANCE);
            serverAnnotationCache.put(world, serverAnnotations);
        }
        if (serverAnnotations != null) {
            for (Map.Entry<UUID, AnnotationData> entry : serverAnnotations.annotations.entrySet()) {
                actions.add(new AnnotationUpdateAction.CreateAnnotation(entry.getKey(), entry.getValue()));
            }
        }
        ServerAnnotations.sendAnnotationUpdates(actions, List.of(player));
    }

    public static void handleUpdates(World world, List<AnnotationUpdateAction> actions) {
        if (!AxiomPaper.PLUGIN.allowAnnotations) {
            return;
        }
        ServerAnnotations serverAnnotations = serverAnnotationCache.get(world);
        if (serverAnnotations == null) {
            serverAnnotations = (ServerAnnotations)world.getPersistentDataContainer().get(ANNOTATION_DATA_KEY, (PersistentDataType)ServerAnnotationsAdapater.INSTANCE);
            serverAnnotationCache.put(world, serverAnnotations);
        }
        if (serverAnnotations == null) {
            serverAnnotations = new ServerAnnotations();
            serverAnnotationCache.put(world, serverAnnotations);
        }
        boolean dirty = false;
        for (AnnotationUpdateAction action : actions) {
            AnnotationData annotation;
            if (action instanceof AnnotationUpdateAction.CreateAnnotation) {
                AnnotationUpdateAction.CreateAnnotation create = (AnnotationUpdateAction.CreateAnnotation)action;
                serverAnnotations.annotations.put(create.uuid(), create.annotationData());
                dirty = true;
                continue;
            }
            if (action instanceof AnnotationUpdateAction.DeleteAnnotation) {
                AnnotationUpdateAction.DeleteAnnotation delete = (AnnotationUpdateAction.DeleteAnnotation)action;
                AnnotationData removed = (AnnotationData)serverAnnotations.annotations.remove(delete.uuid());
                if (removed == null) continue;
                dirty = true;
                continue;
            }
            if (action instanceof AnnotationUpdateAction.MoveAnnotation) {
                AnnotationUpdateAction.MoveAnnotation move = (AnnotationUpdateAction.MoveAnnotation)action;
                annotation = serverAnnotations.annotations.get(move.uuid());
                if (annotation == null) continue;
                annotation.setPosition(move.to());
                dirty = true;
                continue;
            }
            if (action instanceof AnnotationUpdateAction.ClearAllAnnotations) {
                if (serverAnnotations.annotations.isEmpty()) continue;
                serverAnnotations.annotations.clear();
                dirty = true;
                continue;
            }
            if (action instanceof AnnotationUpdateAction.RotateAnnotation) {
                AnnotationUpdateAction.RotateAnnotation rotate = (AnnotationUpdateAction.RotateAnnotation)action;
                annotation = serverAnnotations.annotations.get(rotate.uuid());
                if (annotation == null) continue;
                annotation.setRotation(rotate.to());
                dirty = true;
                continue;
            }
            throw new UnsupportedOperationException("Unknown action: " + String.valueOf(action.getClass()));
        }
        if (dirty) {
            world.getPersistentDataContainer().set(ANNOTATION_DATA_KEY, (PersistentDataType)ServerAnnotationsAdapater.INSTANCE, (Object)serverAnnotations);
        }
        ArrayList<EntityPlayer> playersWithAxiom = new ArrayList<EntityPlayer>();
        for (EntityPlayer player : ((CraftWorld)world).getHandle().x()) {
            if (!AxiomPaper.PLUGIN.canUseAxiom((Player)player.getBukkitEntity(), "axiom.annotations.view")) continue;
            playersWithAxiom.add(player);
        }
        if (!playersWithAxiom.isEmpty()) {
            ServerAnnotations.sendAnnotationUpdates(actions, playersWithAxiom);
        }
    }
}

