/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.moulberry.axiom.AxiomPaper;
import com.moulberry.axiom.annotations.ServerAnnotations;
import com.moulberry.axiom.marker.MarkerData;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldExtension {
    private static final Map<ResourceKey<World>, WorldExtension> extensions = new HashMap<ResourceKey<World>, WorldExtension>();
    private WorldServer level;
    private final LongSet pendingChunksToSend = new LongOpenHashSet();
    private final LongSet pendingChunksToLight = new LongOpenHashSet();
    private final Map<UUID, MarkerData> previousMarkerData = new HashMap<UUID, MarkerData>();

    public static WorldExtension get(WorldServer serverLevel) {
        WorldExtension extension = extensions.computeIfAbsent((ResourceKey<World>)serverLevel.af(), k -> new WorldExtension());
        extension.level = serverLevel;
        return extension;
    }

    public static void onPlayerJoin(org.bukkit.World world, Player player) {
        WorldServer level = ((CraftWorld)world).getHandle();
        WorldExtension.get(level).onPlayerJoin(player);
        if (AxiomPaper.PLUGIN.canUseAxiom(player, "axiom.annotations.view")) {
            ServerAnnotations.sendAll(world, ((CraftPlayer)player).getHandle());
        }
    }

    public static void tick(MinecraftServer server, boolean sendMarkers, int maxChunkRelightsPerTick, int maxChunkSendsPerTick) {
        extensions.keySet().retainAll(server.J());
        for (WorldServer level : server.K()) {
            WorldExtension.get(level).tick(sendMarkers, maxChunkRelightsPerTick, maxChunkSendsPerTick);
        }
    }

    public void sendChunk(int cx, int cz) {
        this.pendingChunksToSend.add(ChunkCoordIntPair.c((int)cx, (int)cz));
    }

    public void lightChunk(int cx, int cz) {
        this.pendingChunksToLight.add(ChunkCoordIntPair.c((int)cx, (int)cz));
    }

    public void onPlayerJoin(Player player) {
        if (!this.previousMarkerData.isEmpty()) {
            ArrayList<MarkerData> markerData = new ArrayList<MarkerData>(this.previousMarkerData.values());
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
            buf.a(markerData, MarkerData::write);
            buf.a(Set.of(), (buffer, uuid) -> buffer.a(uuid));
            byte[] bytes = new byte[buf.writerIndex()];
            buf.a(0, bytes);
            player.sendPluginMessage((Plugin)AxiomPaper.PLUGIN, "axiom:marker_data", bytes);
        }
    }

    public void tick(boolean sendMarkers, int maxChunkRelightsPerTick, int maxChunkSendsPerTick) {
        if (sendMarkers) {
            this.tickMarkers();
        }
        this.tickChunkRelight(maxChunkRelightsPerTick, maxChunkSendsPerTick);
    }

    private void tickMarkers() {
        ArrayList<MarkerData> changedData = new ArrayList<MarkerData>();
        HashSet<UUID> allMarkers = new HashSet<UUID>();
        for (Entity entity : this.level.G().a()) {
            MarkerData previousData;
            if (!(entity instanceof Marker)) continue;
            Marker marker = (Marker)entity;
            MarkerData currentData = MarkerData.createFrom(marker);
            if (!Objects.equals(currentData, previousData = this.previousMarkerData.get(marker.cz()))) {
                this.previousMarkerData.put(marker.cz(), currentData);
                changedData.add(currentData);
            }
            allMarkers.add(marker.cz());
        }
        HashSet<UUID> oldUuids = new HashSet<UUID>(this.previousMarkerData.keySet());
        oldUuids.removeAll(allMarkers);
        this.previousMarkerData.keySet().removeAll(oldUuids);
        if (!changedData.isEmpty() || !oldUuids.isEmpty()) {
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
            buf.a(changedData, MarkerData::write);
            buf.a(oldUuids, (buffer, uuid) -> buffer.a(uuid));
            byte[] bytes = new byte[buf.writerIndex()];
            buf.a(0, bytes);
            for (EntityPlayer player : this.level.x()) {
                if (!AxiomPaper.PLUGIN.activeAxiomPlayers.contains(player.cz())) continue;
                player.getBukkitEntity().sendPluginMessage((Plugin)AxiomPaper.PLUGIN, "axiom:marker_data", bytes);
            }
        }
    }

    private void tickChunkRelight(int maxChunkRelightsPerTick, int maxChunkSendsPerTick) {
        PlayerChunkMap chunkMap = this.level.l().a;
        boolean sendAll = maxChunkSendsPerTick <= 0;
        LongIterator longIterator = this.pendingChunksToSend.longIterator();
        while (longIterator.hasNext()) {
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(longIterator.nextLong());
            List players = chunkMap.a(chunkPos, false);
            if (players.isEmpty()) continue;
            Chunk chunk = this.level.d(chunkPos.e, chunkPos.f);
            ClientboundLevelChunkWithLightPacket packet = new ClientboundLevelChunkWithLightPacket(chunk, this.level.y_(), null, null, false);
            for (EntityPlayer player : players) {
                player.c.b((Packet)packet);
            }
            if (sendAll) continue;
            longIterator.remove();
            if (--maxChunkSendsPerTick > 0) continue;
            break;
        }
        if (sendAll) {
            this.pendingChunksToSend.clear();
        }
        HashSet<ChunkCoordIntPair> chunkSet = new HashSet<ChunkCoordIntPair>();
        longIterator = this.pendingChunksToLight.longIterator();
        if (maxChunkRelightsPerTick <= 0) {
            while (longIterator.hasNext()) {
                chunkSet.add(new ChunkCoordIntPair(longIterator.nextLong()));
            }
            this.pendingChunksToLight.clear();
        } else {
            while (longIterator.hasNext()) {
                chunkSet.add(new ChunkCoordIntPair(longIterator.nextLong()));
                longIterator.remove();
                if (--maxChunkRelightsPerTick > 0) continue;
            }
        }
        this.level.l().a().starlight$serverRelightChunks(chunkSet, pos -> {}, count -> {});
    }
}

