/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.persistence.UUIDDataType;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public final class View {
    public String name;
    public final UUID uuid;
    public boolean pinLevel = false;
    public boolean pinLocation = false;
    private ResourceKey<World> level = null;
    private Vec3D position = null;
    private float yaw;
    private float pitch;
    private static final NamespacedKey NAME_KEY = new NamespacedKey("axiom", "view_name");
    private static final NamespacedKey UUID_KEY = new NamespacedKey("axiom", "view_uuid");
    private static final NamespacedKey PIN_LEVEL_KEY = new NamespacedKey("axiom", "view_pin_level");
    private static final NamespacedKey LEVEL_KEY = new NamespacedKey("axiom", "view_level");
    private static final NamespacedKey PIN_LOCATION_KEY = new NamespacedKey("axiom", "view_pin_location");
    private static final NamespacedKey X_KEY = new NamespacedKey("axiom", "view_x");
    private static final NamespacedKey Y_KEY = new NamespacedKey("axiom", "view_y");
    private static final NamespacedKey Z_KEY = new NamespacedKey("axiom", "view_z");
    private static final NamespacedKey YAW_KEY = new NamespacedKey("axiom", "view_yaw");
    private static final NamespacedKey PITCH_KEY = new NamespacedKey("axiom", "view_pitch");

    public View(String name, UUID uuid) {
        this.name = name;
        this.uuid = uuid;
    }

    public void write(PacketDataSerializer byteBuf) {
        byteBuf.a(this.name, 64);
        byteBuf.a(this.uuid);
        byteBuf.a(this.pinLevel);
        if (this.pinLevel && this.level != null) {
            byteBuf.a(true);
            byteBuf.b(this.level);
        } else {
            byteBuf.a(false);
        }
        byteBuf.a(this.pinLocation);
        if (this.position != null) {
            byteBuf.a(true);
            byteBuf.a(this.position.c);
            byteBuf.a(this.position.d);
            byteBuf.a(this.position.e);
            byteBuf.a(this.yaw);
            byteBuf.a(this.pitch);
        } else {
            byteBuf.a(false);
        }
    }

    public static View read(PacketDataSerializer byteBuf) {
        View view = new View(byteBuf.d(64), byteBuf.n());
        view.pinLevel = byteBuf.readBoolean();
        if (byteBuf.readBoolean()) {
            view.level = byteBuf.a(Registries.ba);
        }
        view.pinLocation = byteBuf.readBoolean();
        if (byteBuf.readBoolean()) {
            view.position = new Vec3D(byteBuf.readDouble(), byteBuf.readDouble(), byteBuf.readDouble());
            view.yaw = byteBuf.readFloat();
            view.pitch = byteBuf.readFloat();
        }
        return view;
    }

    public void save(PersistentDataContainer container) {
        container.set(NAME_KEY, PersistentDataType.STRING, (Object)this.name);
        container.set(UUID_KEY, (PersistentDataType)UUIDDataType.INSTANCE, (Object)this.uuid);
        container.set(PIN_LEVEL_KEY, PersistentDataType.BOOLEAN, (Object)this.pinLevel);
        if (this.pinLevel && this.level != null) {
            container.set(LEVEL_KEY, PersistentDataType.STRING, (Object)this.level.a().toString());
        }
        container.set(PIN_LOCATION_KEY, PersistentDataType.BOOLEAN, (Object)this.pinLocation);
        if (this.position != null) {
            container.set(X_KEY, PersistentDataType.DOUBLE, (Object)this.position.c);
            container.set(Y_KEY, PersistentDataType.DOUBLE, (Object)this.position.d);
            container.set(Z_KEY, PersistentDataType.DOUBLE, (Object)this.position.e);
            container.set(YAW_KEY, PersistentDataType.FLOAT, (Object)Float.valueOf(this.yaw));
            container.set(PITCH_KEY, PersistentDataType.FLOAT, (Object)Float.valueOf(this.pitch));
        }
    }

    public static View load(PersistentDataContainer tag) {
        String name = (String)tag.get(NAME_KEY, PersistentDataType.STRING);
        UUID uuid = (UUID)tag.get(UUID_KEY, (PersistentDataType)UUIDDataType.INSTANCE);
        View view = new View(name, uuid);
        view.pinLevel = (Boolean)tag.getOrDefault(PIN_LEVEL_KEY, PersistentDataType.BOOLEAN, (Object)false);
        if (tag.has(LEVEL_KEY)) {
            String level = (String)tag.get(LEVEL_KEY, PersistentDataType.STRING);
            view.level = ResourceKey.a((ResourceKey)Registries.ba, (MinecraftKey)VersionHelper.createResourceLocation(level));
        }
        view.pinLocation = (Boolean)tag.getOrDefault(PIN_LOCATION_KEY, PersistentDataType.BOOLEAN, (Object)false);
        if (tag.has(X_KEY) && tag.has(Y_KEY) && tag.has(Z_KEY)) {
            double x = (Double)tag.getOrDefault(X_KEY, PersistentDataType.DOUBLE, (Object)0.0);
            double y = (Double)tag.getOrDefault(Y_KEY, PersistentDataType.DOUBLE, (Object)0.0);
            double z = (Double)tag.getOrDefault(Z_KEY, PersistentDataType.DOUBLE, (Object)0.0);
            view.position = new Vec3D(x, y, z);
            view.yaw = ((Float)tag.getOrDefault(YAW_KEY, PersistentDataType.FLOAT, (Object)Float.valueOf(0.0f))).floatValue();
            view.pitch = ((Float)tag.getOrDefault(PITCH_KEY, PersistentDataType.FLOAT, (Object)Float.valueOf(0.0f))).floatValue();
        }
        return view;
    }
}

