/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.google.common.util.concurrent.RateLimiter;
import com.moulberry.axiom.DisallowedBlocks;
import com.moulberry.axiom.Restrictions;
import com.moulberry.axiom.VersionHelper;
import com.moulberry.axiom.WorldExtension;
import com.moulberry.axiom.blueprint.ServerBlueprintManager;
import com.moulberry.axiom.buffer.CompressedBlockEntity;
import com.moulberry.axiom.commands.AxiomDebugCommand;
import com.moulberry.axiom.event.AxiomCreateWorldPropertiesEvent;
import com.moulberry.axiom.event.AxiomModifyWorldEvent;
import com.moulberry.axiom.integration.coreprotect.CoreProtectIntegration;
import com.moulberry.axiom.integration.plotsquared.PlotSquaredIntegration;
import com.moulberry.axiom.packet.AxiomBigPayloadHandler;
import com.moulberry.axiom.packet.BlueprintRequestPacketListener;
import com.moulberry.axiom.packet.DeleteEntityPacketListener;
import com.moulberry.axiom.packet.HelloPacketListener;
import com.moulberry.axiom.packet.ManipulateEntityPacketListener;
import com.moulberry.axiom.packet.MarkerNbtRequestPacketListener;
import com.moulberry.axiom.packet.RequestChunkDataPacketListener;
import com.moulberry.axiom.packet.SetBlockBufferPacketListener;
import com.moulberry.axiom.packet.SetBlockPacketListener;
import com.moulberry.axiom.packet.SetEditorViewsPacketListener;
import com.moulberry.axiom.packet.SetFlySpeedPacketListener;
import com.moulberry.axiom.packet.SetGamemodePacketListener;
import com.moulberry.axiom.packet.SetHotbarSlotPacketListener;
import com.moulberry.axiom.packet.SetTimePacketListener;
import com.moulberry.axiom.packet.SetWorldPropertyListener;
import com.moulberry.axiom.packet.SpawnEntityPacketListener;
import com.moulberry.axiom.packet.SwitchActiveHotbarPacketListener;
import com.moulberry.axiom.packet.TeleportPacketListener;
import com.moulberry.axiom.packet.UpdateAnnotationPacketListener;
import com.moulberry.axiom.packet.UploadBlueprintPacketListener;
import com.moulberry.axiom.world_properties.server.ServerWorldPropertiesRegistry;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.papermc.paper.event.player.PlayerFailMoveEvent;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import io.papermc.paper.network.ChannelInitializeListener;
import io.papermc.paper.network.ChannelInitializeListenerHolder;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.key.Key;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.paper.LegacyPaperCommandManager;
import org.jetbrains.annotations.Nullable;

public class AxiomPaper
extends JavaPlugin
implements Listener {
    public static AxiomPaper PLUGIN;
    public final Set<UUID> activeAxiomPlayers = Collections.newSetFromMap(new ConcurrentHashMap());
    public final Map<UUID, RateLimiter> playerBlockBufferRateLimiters = new ConcurrentHashMap<UUID, RateLimiter>();
    public final Map<UUID, Restrictions> playerRestrictions = new ConcurrentHashMap<UUID, Restrictions>();
    public final Map<UUID, RegistryBlockID<IBlockData>> playerBlockRegistry = new ConcurrentHashMap<UUID, RegistryBlockID<IBlockData>>();
    public final Map<UUID, Integer> playerProtocolVersion = new ConcurrentHashMap<UUID, Integer>();
    public Configuration configuration;
    public RegistryBlockID<IBlockData> allowedBlockRegistry = null;
    private boolean logLargeBlockBufferChanges = false;
    public Path blueprintFolder = null;
    public boolean allowAnnotations = false;
    private final WeakHashMap<World, ServerWorldPropertiesRegistry> worldProperties = new WeakHashMap();

    public void onEnable() {
        PLUGIN = this;
        this.saveDefaultConfig();
        this.configuration = this.getConfig();
        Set<String> validResolutions = Set.of("kick", "warn", "ignore");
        if (!validResolutions.contains(this.configuration.getString("incompatible-data-version"))) {
            this.getLogger().warning("Invalid value for incompatible-data-version, expected 'kick', 'warn' or 'ignore'");
        }
        if (!validResolutions.contains(this.configuration.getString("unsupported-axiom-version"))) {
            this.getLogger().warning("Invalid value for unsupported-axiom-version, expected 'kick', 'warn' or 'ignore'");
        }
        boolean allowLargeChunkDataRequest = this.configuration.getBoolean("allow-large-chunk-data-request");
        this.logLargeBlockBufferChanges = this.configuration.getBoolean("log-large-block-buffer-changes");
        List disallowedBlocks = this.configuration.getStringList("disallowed-blocks");
        this.allowedBlockRegistry = DisallowedBlocks.createAllowedBlockRegistry(disallowedBlocks);
        this.allowAnnotations = this.configuration.getBoolean("allow-annotations");
        int allowedCapabilities = this.calculateAllowedCapabilities();
        int infiniteReachLimit = this.configuration.getInt("infinite-reach-limit");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        CompressedBlockEntity.initialize(this);
        Messenger msg = Bukkit.getMessenger();
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:enable");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:initialize_hotbars");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:set_editor_views");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:response_chunk_data");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:register_world_properties");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:set_world_property");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:ack_world_properties");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:restrictions");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:marker_data");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:marker_nbt_response");
        msg.registerOutgoingPluginChannel((Plugin)this, "axiom:annotation_update");
        if (this.configuration.getBoolean("packet-handlers.hello")) {
            msg.registerIncomingPluginChannel((Plugin)this, "axiom:hello", (PluginMessageListener)new HelloPacketListener(this));
        }
        if (this.configuration.getBoolean("packet-handlers.set-gamemode")) {
            msg.registerIncomingPluginChannel((Plugin)this, "axiom:set_gamemode", (PluginMessageListener)new SetGamemodePacketListener(this));
        }
        if (this.configuration.getBoolean("packet-handlers.set-fly-speed")) {
            msg.registerIncomingPluginChannel((Plugin)this, "axiom:set_fly_speed", (PluginMessageListener)new SetFlySpeedPacketListener(this));
        }
        if (this.configuration.getBoolean("packet-handlers.set-world-time")) {
            msg.registerIncomingPluginChannel((Plugin)this, "axiom:set_world_time", (PluginMessageListener)new SetTimePacketListener(this));
        }
        if (this.configuration.getBoolean("packet-handlers.set-world-property")) {
            msg.registerIncomingPluginChannel((Plugin)this, "axiom:set_world_property", (PluginMessageListener)new SetWorldPropertyListener(this));
        }
        if (this.configuration.getBoolean("packet-handlers.set-single-block")) {
            msg.registerIncomingPluginChannel((Plugin)this, "axiom:set_block", (PluginMessageListener)new SetBlockPacketListener(this));
        }
        if (this.configuration.getBoolean("packet-handlers.set-hotbar-slot")) {
            msg.registerIncomingPluginChannel((Plugin)this, "axiom:set_hotbar_slot", (PluginMessageListener)new SetHotbarSlotPacketListener(this));
        }
        if (this.configuration.getBoolean("packet-handlers.switch-active-hotbar")) {
            msg.registerIncomingPluginChannel((Plugin)this, "axiom:switch_active_hotbar", (PluginMessageListener)new SwitchActiveHotbarPacketListener(this));
        }
        if (this.configuration.getBoolean("packet-handlers.teleport")) {
            msg.registerIncomingPluginChannel((Plugin)this, "axiom:teleport", (PluginMessageListener)new TeleportPacketListener(this));
        }
        if (this.configuration.getBoolean("packet-handlers.set-editor-views")) {
            msg.registerIncomingPluginChannel((Plugin)this, "axiom:set_editor_views", (PluginMessageListener)new SetEditorViewsPacketListener(this));
        }
        if (!allowLargeChunkDataRequest && this.configuration.getBoolean("packet-handlers.request-chunk-data")) {
            msg.registerIncomingPluginChannel((Plugin)this, "axiom:request_chunk_data", (PluginMessageListener)new RequestChunkDataPacketListener(this));
        }
        if (this.configuration.getBoolean("packet-handlers.spawn-entity")) {
            msg.registerIncomingPluginChannel((Plugin)this, "axiom:spawn_entity", (PluginMessageListener)new SpawnEntityPacketListener(this));
        }
        if (this.configuration.getBoolean("packet-handlers.manipulate-entity")) {
            msg.registerIncomingPluginChannel((Plugin)this, "axiom:manipulate_entity", (PluginMessageListener)new ManipulateEntityPacketListener(this));
        }
        if (this.configuration.getBoolean("packet-handlers.delete-entity")) {
            msg.registerIncomingPluginChannel((Plugin)this, "axiom:delete_entity", (PluginMessageListener)new DeleteEntityPacketListener(this));
        }
        if (this.configuration.getBoolean("packet-handlers.marker-nbt-request")) {
            msg.registerIncomingPluginChannel((Plugin)this, "axiom:marker_nbt_request", (PluginMessageListener)new MarkerNbtRequestPacketListener(this));
        }
        if (this.configuration.getBoolean("packet-handlers.blueprint-request")) {
            msg.registerIncomingPluginChannel((Plugin)this, "axiom:request_blueprint", (PluginMessageListener)new BlueprintRequestPacketListener(this));
        }
        if (this.configuration.getBoolean("packet-handlers.set-buffer")) {
            final SetBlockBufferPacketListener setBlockBufferPacketListener = new SetBlockBufferPacketListener(this);
            final UploadBlueprintPacketListener uploadBlueprintPacketListener = new UploadBlueprintPacketListener(this);
            final UpdateAnnotationPacketListener updateAnnotationPacketListener = new UpdateAnnotationPacketListener(this);
            final RequestChunkDataPacketListener requestChunkDataPacketListener = allowLargeChunkDataRequest ? new RequestChunkDataPacketListener(this) : null;
            ProtocolInfo protocol = GameProtocols.a.a(k -> new RegistryFriendlyByteBuf(k, (IRegistryCustom)MinecraftServer.getServer().bc()));
            RegistryFriendlyByteBuf friendlyByteBuf = new RegistryFriendlyByteBuf(Unpooled.buffer(), (IRegistryCustom)MinecraftServer.getServer().bc());
            protocol.c().encode((Object)friendlyByteBuf, (Object)new ServerboundCustomPayloadPacket((CustomPacketPayload)new DiscardedPayload(VersionHelper.createResourceLocation("dummy"), Unpooled.buffer())));
            final int payloadId = friendlyByteBuf.l();
            ChannelInitializeListenerHolder.addListener((Key)Key.key((String)"axiom:handle_big_payload"), (ChannelInitializeListener)new ChannelInitializeListener(){

                public void afterInitChannel(@NonNull Channel channel) {
                    NetworkManager connection = (NetworkManager)channel.pipeline().get("packet_handler");
                    channel.pipeline().addBefore("decoder", "axiom-big-payload-handler", (ChannelHandler)new AxiomBigPayloadHandler(payloadId, connection, setBlockBufferPacketListener, uploadBlueprintPacketListener, updateAnnotationPacketListener, requestChunkDataPacketListener));
                }
            });
        }
        if (this.configuration.getBoolean("blueprint-sharing")) {
            this.blueprintFolder = this.getDataFolder().toPath().resolve("blueprints");
            try {
                Files.createDirectories(this.blueprintFolder, new FileAttribute[0]);
            }
            catch (IOException setBlockBufferPacketListener) {
                // empty catch block
            }
            ServerBlueprintManager.initialize(this.blueprintFolder);
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            HashSet<UUID> stillActiveAxiomPlayers = new HashSet<UUID>();
            int rateLimit = this.configuration.getInt("block-buffer-rate-limit");
            if (rateLimit > 0 && (rateLimit = rateLimit * 8 / 10) <= 0) {
                rateLimit = 1;
            }
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                boolean canCreateAnnotations;
                if (!this.activeAxiomPlayers.contains(player.getUniqueId())) continue;
                if (!this.hasAxiomPermission(player)) {
                    PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
                    buf.a(false);
                    byte[] bytes = new byte[buf.writerIndex()];
                    buf.a(0, bytes);
                    player.sendPluginMessage((Plugin)this, "axiom:enable", bytes);
                    continue;
                }
                UUID uuid = player.getUniqueId();
                stillActiveAxiomPlayers.add(uuid);
                boolean send = false;
                Restrictions restrictions = this.playerRestrictions.get(uuid);
                if (restrictions == null) {
                    restrictions = new Restrictions();
                    this.playerRestrictions.put(uuid, restrictions);
                    send = true;
                }
                Set<Object> bounds = Set.of();
                if (!player.hasPermission("axiom.allow_copying_other_plots")) {
                    if (PlotSquaredIntegration.isPlotWorld(player.getWorld())) {
                        PlotSquaredIntegration.PlotBounds editable = PlotSquaredIntegration.getCurrentEditablePlot(player);
                        if (editable != null) {
                            restrictions.lastPlotBounds = editable;
                            bounds = editable.boxes();
                        } else {
                            bounds = restrictions.lastPlotBounds != null && restrictions.lastPlotBounds.worldName().equals(player.getWorld().getName()) ? restrictions.lastPlotBounds.boxes() : Set.of(new PlotSquaredIntegration.PlotBox(BlockPosition.c, BlockPosition.c));
                        }
                    }
                    if (bounds.size() == 1) {
                        PlotSquaredIntegration.PlotBox plotBounds = (PlotSquaredIntegration.PlotBox)bounds.iterator().next();
                        int min = Integer.MIN_VALUE;
                        int max = Integer.MAX_VALUE;
                        if (plotBounds.min().u() == min && plotBounds.min().v() == min && plotBounds.min().w() == min && plotBounds.max().u() == max && plotBounds.max().v() == max && plotBounds.max().w() == max) {
                            bounds = Set.of();
                        }
                    }
                }
                boolean allowImportingBlocks = player.hasPermission("axiom.can_import_blocks");
                boolean bl = canCreateAnnotations = this.allowAnnotations && player.hasPermission("axiom.annotation.create");
                if (restrictions.maxSectionsPerSecond != rateLimit || restrictions.canImportBlocks != allowImportingBlocks || restrictions.canCreateAnnotations != canCreateAnnotations || restrictions.allowedCapabilities != allowedCapabilities || restrictions.infiniteReachLimit != infiniteReachLimit || !Objects.equals(restrictions.bounds, bounds)) {
                    restrictions.maxSectionsPerSecond = rateLimit;
                    restrictions.canImportBlocks = allowImportingBlocks;
                    restrictions.canCreateAnnotations = canCreateAnnotations;
                    restrictions.allowedCapabilities = allowedCapabilities;
                    restrictions.infiniteReachLimit = infiniteReachLimit;
                    restrictions.bounds = bounds;
                    send = true;
                }
                if (!send) continue;
                restrictions.send(this, player);
            }
            this.activeAxiomPlayers.retainAll(stillActiveAxiomPlayers);
            this.playerBlockBufferRateLimiters.keySet().retainAll(stillActiveAxiomPlayers);
            this.playerRestrictions.keySet().retainAll(stillActiveAxiomPlayers);
            this.playerBlockRegistry.keySet().retainAll(stillActiveAxiomPlayers);
            this.playerProtocolVersion.keySet().retainAll(stillActiveAxiomPlayers);
        }, 20L, 20L);
        boolean sendMarkers = this.configuration.getBoolean("send-markers");
        int maxChunkRelightsPerTick = this.configuration.getInt("max-chunk-relights-per-tick");
        int maxChunkSendsPerTick = this.configuration.getInt("max-chunk-sends-per-tick");
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> WorldExtension.tick(MinecraftServer.getServer(), sendMarkers, maxChunkRelightsPerTick, maxChunkSendsPerTick), 1L, 1L);
        try {
            LegacyPaperCommandManager<CommandSender> manager = LegacyPaperCommandManager.createNative((Plugin)this, ExecutionCoordinator.simpleCoordinator());
            if (manager.hasCapability(CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
                manager.registerBrigadier();
            }
            AxiomDebugCommand.register(this, manager);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (CoreProtectIntegration.isEnabled()) {
            this.getLogger().info("CoreProtect integration enabled");
        }
    }

    private int calculateAllowedCapabilities() {
        HashSet allowed = new HashSet(this.configuration.getStringList("allow-capabilities"));
        if (allowed.contains("all")) {
            return -1;
        }
        int allowedCapabilities = 0;
        if (allowed.contains("bulldozer")) {
            allowedCapabilities |= 1;
        }
        if (allowed.contains("replace_mode")) {
            allowedCapabilities |= 2;
        }
        if (allowed.contains("force_place")) {
            allowedCapabilities |= 4;
        }
        if (allowed.contains("no_updates")) {
            allowedCapabilities |= 8;
        }
        if (allowed.contains("tinker")) {
            allowedCapabilities |= 0x10;
        }
        if (allowed.contains("infinite_reach")) {
            allowedCapabilities |= 0x20;
        }
        if (allowed.contains("fast_place")) {
            allowedCapabilities |= 0x40;
        }
        if (allowed.contains("angel_placement")) {
            allowedCapabilities |= 0x80;
        }
        if (allowed.contains("no_clip")) {
            allowedCapabilities |= 0x100;
        }
        return allowedCapabilities;
    }

    public boolean logLargeBlockBufferChanges() {
        return this.logLargeBlockBufferChanges;
    }

    public boolean hasAxiomPermission(Player player) {
        return this.hasAxiomPermission(player, null, false);
    }

    public boolean hasAxiomPermission(Player player, String permission, boolean strict) {
        if (player.hasPermission("axiom.*") || player.isOp()) {
            return !strict || permission == null || player.hasPermission("axiom.all") || player.hasPermission(permission);
        }
        if (permission != null && !player.hasPermission(permission)) {
            return false;
        }
        return player.hasPermission("axiom.use");
    }

    public boolean canUseAxiom(Player player) {
        return this.canUseAxiom(player, null, false);
    }

    public boolean canUseAxiom(Player player, String permission) {
        return this.canUseAxiom(player, permission, false);
    }

    public boolean canUseAxiom(Player player, String permission, boolean strict) {
        return this.activeAxiomPlayers.contains(player.getUniqueId()) && this.hasAxiomPermission(player, permission, strict);
    }

    @Nullable
    public RateLimiter getBlockBufferRateLimiter(UUID uuid) {
        return this.playerBlockBufferRateLimiters.get(uuid);
    }

    public boolean isMismatchedDataVersion(UUID uuid) {
        return this.playerProtocolVersion.containsKey(uuid);
    }

    public int getProtocolVersionFor(UUID uuid) {
        return this.playerProtocolVersion.getOrDefault(uuid, SharedConstants.c());
    }

    public RegistryBlockID<IBlockData> getBlockRegistry(UUID uuid) {
        return this.playerBlockRegistry.getOrDefault(uuid, this.allowedBlockRegistry);
    }

    @Nullable
    public ServerWorldPropertiesRegistry getWorldPropertiesIfPresent(World world) {
        return this.worldProperties.get(world);
    }

    @Nullable
    public ServerWorldPropertiesRegistry getOrCreateWorldProperties(World world) {
        if (this.worldProperties.containsKey(world)) {
            return this.worldProperties.get(world);
        }
        ServerWorldPropertiesRegistry properties = this.createWorldProperties(world);
        this.worldProperties.put(world, properties);
        return properties;
    }

    public boolean canModifyWorld(Player player, World world) {
        String whitelist = this.configuration.getString("whitelist-world-regex");
        if (whitelist != null && !world.getName().matches(whitelist)) {
            return false;
        }
        String blacklist = this.configuration.getString("blacklist-world-regex");
        if (blacklist != null && world.getName().matches(blacklist)) {
            return false;
        }
        AxiomModifyWorldEvent modifyWorldEvent = new AxiomModifyWorldEvent(player, world);
        Bukkit.getPluginManager().callEvent((Event)modifyWorldEvent);
        return !modifyWorldEvent.isCancelled();
    }

    @EventHandler
    public void onFailMove(PlayerFailMoveEvent event) {
        if (!this.activeAxiomPlayers.contains(event.getPlayer().getUniqueId())) {
            return;
        }
        if (event.getFailReason() == PlayerFailMoveEvent.FailReason.MOVED_TOO_QUICKLY) {
            event.setAllowed(true);
        } else if (event.getPlayer().isFlying()) {
            event.setAllowed(true);
        }
    }

    @EventHandler
    public void onChangedWorld(PlayerChangedWorldEvent event) {
        if (!this.activeAxiomPlayers.contains(event.getPlayer().getUniqueId())) {
            return;
        }
        World world = event.getPlayer().getWorld();
        ServerWorldPropertiesRegistry properties = this.getOrCreateWorldProperties(world);
        if (properties == null) {
            event.getPlayer().sendPluginMessage((Plugin)this, "axiom:register_world_properties", new byte[]{0});
        } else {
            properties.registerFor((Plugin)this, event.getPlayer());
        }
        WorldExtension.onPlayerJoin(world, event.getPlayer());
    }

    @EventHandler
    public void onGameRuleChanged(WorldGameRuleChangeEvent event) {
        if (event.getGameRule() == GameRule.DO_WEATHER_CYCLE) {
            ServerWorldPropertiesRegistry.PAUSE_WEATHER.setValue(event.getWorld(), !Boolean.parseBoolean(event.getValue()));
        }
    }

    private ServerWorldPropertiesRegistry createWorldProperties(World world) {
        ServerWorldPropertiesRegistry registry = new ServerWorldPropertiesRegistry(new WeakReference<World>(world));
        AxiomCreateWorldPropertiesEvent createEvent = new AxiomCreateWorldPropertiesEvent(world, registry);
        Bukkit.getPluginManager().callEvent((Event)createEvent);
        if (createEvent.isCancelled()) {
            return null;
        }
        return registry;
    }
}

