/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.staminaclimb.climbing;

import com.mineinabyss.geary.papermc.tracking.items.inventory.GearyPlayerInventory;
import com.mineinabyss.geary.papermc.tracking.items.inventory.GearyPlayerInventoryKt;
import com.mineinabyss.staminaclimb.ExtensionsKt;
import com.mineinabyss.staminaclimb.component.StaminaModifier;
import com.mineinabyss.staminaclimb.config.StaminaConfig;
import com.mineinabyss.staminaclimb.modules.StaminaModuleKt;
import com.mineinabyss.staminaclimb.stamina.StaminaBar;
import com.mineinabyss.staminaclimb.stamina.StaminaBarKt;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.bossbar.BossBar;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\f\u0010\u001a\u001a\u00020\u0017*\u00020\u001bH\u0007J\f\u0010\u001c\u001a\u00020\u0017*\u00020\u001dH\u0007J\f\u0010\u001e\u001a\u00020\u0017*\u00020\u001fH\u0007J\f\u0010 \u001a\u00020\u0017*\u00020!H\u0007J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010#\u001a\u00020\r*\u00020\u001fH\u0002J\u0010\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\fH\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0012R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006)"}, d2={"Lcom/mineinabyss/staminaclimb/climbing/ClimbBehaviour;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "conf", "Lcom/mineinabyss/staminaclimb/config/StaminaConfig;", "getConf$stamina_climb", "()Lcom/mineinabyss/staminaclimb/config/StaminaConfig;", "setConf$stamina_climb", "(Lcom/mineinabyss/staminaclimb/config/StaminaConfig;)V", "canClimb", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "Ljava/util/UUID;", "", "getCanClimb", "()Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "isClimbing", "", "()Ljava/util/Map;", "cooldown", "", "getCooldown", "stopClimbing", "", "player", "Lorg/bukkit/entity/Player;", "onBlockPlace", "Lorg/bukkit/event/block/BlockPlaceEvent;", "onBlockBreak", "Lorg/bukkit/event/block/BlockBreakEvent;", "onRightClick", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onLeftClick", "Lorg/bukkit/event/player/PlayerAnimationEvent;", "allowClimb", "rightClicked", "leftClicked", "block", "Lorg/bukkit/Material;", "cooldownComplete", "uuid", "stamina-climb"})
public final class ClimbBehaviour
implements Listener {
    @NotNull
    public static final ClimbBehaviour INSTANCE = new ClimbBehaviour();
    @NotNull
    private static StaminaConfig conf = StaminaModuleKt.getStamina().getConfig();
    @NotNull
    private static final Object2ObjectOpenHashMap<UUID, Boolean> canClimb = new Object2ObjectOpenHashMap();
    @NotNull
    private static final Map<UUID, Boolean> isClimbing = new ConcurrentHashMap();
    @NotNull
    private static final Object2ObjectOpenHashMap<UUID, Long> cooldown = new Object2ObjectOpenHashMap();

    private ClimbBehaviour() {
    }

    @NotNull
    public final StaminaConfig getConf$stamina_climb() {
        return conf;
    }

    public final void setConf$stamina_climb(@NotNull StaminaConfig staminaConfig) {
        Intrinsics.checkNotNullParameter((Object)staminaConfig, (String)"<set-?>");
        conf = staminaConfig;
    }

    @NotNull
    public final Object2ObjectOpenHashMap<UUID, Boolean> getCanClimb() {
        return canClimb;
    }

    @NotNull
    public final Map<UUID, Boolean> isClimbing() {
        return isClimbing;
    }

    @NotNull
    public final Object2ObjectOpenHashMap<UUID, Long> getCooldown() {
        return cooldown;
    }

    public final void stopClimbing(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.getGameMode() == GameMode.SURVIVAL || player.getGameMode() == GameMode.ADVENTURE) {
            player.setAllowFlight(false);
            player.setFlying(false);
        }
        player.setFlySpeed(0.1f);
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        UUID uuid = uUID;
        isClimbing.remove(uuid);
    }

    @EventHandler
    public final void onBlockPlace(@NotNull BlockPlaceEvent $this$onBlockPlace) {
        UUID uuid;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)$this$onBlockPlace, (String)"<this>");
                UUID uUID = $this$onBlockPlace.getPlayer().getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
                uuid = uUID;
                if (!$this$onBlockPlace.getPlayer().isSneaking()) break block5;
                Player player = $this$onBlockPlace.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
                if (!ExtensionsKt.isInClimbableBlock(player)) break block6;
            }
            if (ExtensionsKt.isClimbing(uuid)) {
                $this$onBlockPlace.setCancelled(true);
            }
        }
        if (((Map)cooldown).containsKey(uuid)) {
            ExtensionsKt.setClimbCooldown(uuid, conf.getWalljumpCooldown());
        }
    }

    @EventHandler
    public final void onBlockBreak(@NotNull BlockBreakEvent $this$onBlockBreak) {
        Intrinsics.checkNotNullParameter((Object)$this$onBlockBreak, (String)"<this>");
        UUID uUID = $this$onBlockBreak.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        UUID uuid = uUID;
        if (((Map)cooldown).containsKey(uuid)) {
            ExtensionsKt.setClimbCooldown(uuid, conf.getWalljumpCooldown());
        }
    }

    @EventHandler
    public final void onRightClick(@NotNull PlayerInteractEvent $this$onRightClick) {
        block12: {
            UUID uuid;
            block11: {
                Intrinsics.checkNotNullParameter((Object)$this$onRightClick, (String)"<this>");
                UUID uUID = $this$onRightClick.getPlayer().getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
                uuid = uUID;
                Vector vector = $this$onRightClick.getPlayer().getVelocity();
                Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"getVelocity(...)");
                Vector velocity = vector;
                Player player = $this$onRightClick.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
                if (this.allowClimb(player) && this.rightClicked($this$onRightClick) && !isClimbing.containsKey(uuid)) {
                    BossBar bossBar = (BossBar)StaminaBar.INSTANCE.getRegisteredBars().get((Object)uuid);
                    if (bossBar == null) {
                        return;
                    }
                    BossBar bossBar2 = bossBar;
                    StaminaBarKt.removeProgress(bossBar2, $this$onRightClick.getPlayer().getFallDistance() / 15.0f);
                    double damageAmount = (double)($this$onRightClick.getPlayer().getFallDistance() - (float)3) / 1.9;
                    if (damageAmount >= 1.0) {
                        $this$onRightClick.getPlayer().damage(damageAmount);
                    }
                    if (bossBar2.progress() > 0.0f) {
                        Player player2 = $this$onRightClick.getPlayer();
                        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getPlayer(...)");
                        if (ExtensionsKt.getWallDifficulty(player2) >= 0.0f) {
                            double d = velocity.getY();
                            boolean bl = -0.08 <= d ? d <= -0.07 : false;
                            if (bl) {
                                $this$onRightClick.getPlayer().setVelocity($this$onRightClick.getPlayer().getVelocity().add(new Vector(0.0, 0.25, 0.0)));
                            }
                            ExtensionsKt.setClimbing(uuid, true);
                            $this$onRightClick.getPlayer().setAllowFlight(true);
                            $this$onRightClick.getPlayer().setFlying(true);
                        } else {
                            isClimbing.remove(uuid);
                            ExtensionsKt.restartCooldown(uuid);
                        }
                    }
                    Player player3 = $this$onRightClick.getPlayer();
                    PlayerInventory playerInventory = $this$onRightClick.getPlayer().getInventory();
                    Intrinsics.checkNotNullExpressionValue((Object)playerInventory, (String)"getInventory(...)");
                    GearyPlayerInventory gearyPlayerInventory = GearyPlayerInventoryKt.toGeary((PlayerInventory)playerInventory);
                    player3.setFlySpeed(gearyPlayerInventory != null ? ExtensionsKt.equipmentModifiers(gearyPlayerInventory, 0.03f, StaminaModifier.ModifierType.CLIMB_SPEED) : 0.03f);
                }
                if (!$this$onRightClick.getPlayer().isSneaking()) break block11;
                Player player4 = $this$onRightClick.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player4, (String)"getPlayer(...)");
                if (!ExtensionsKt.isInClimbableBlock(player4)) break block12;
            }
            if (ExtensionsKt.isClimbing(uuid)) {
                $this$onRightClick.setCancelled(true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onLeftClick(@NotNull PlayerAnimationEvent $this$onLeftClick) {
        Intrinsics.checkNotNullParameter((Object)$this$onLeftClick, (String)"<this>");
        UUID uUID = $this$onLeftClick.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        UUID uuid = uUID;
        Player player = $this$onLeftClick.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        if (this.allowClimb(player) && isClimbing.containsKey(uuid)) {
            ExtensionsKt.setClimbCooldown(uuid, conf.getWalljumpCooldown());
            BossBar bossBar = (BossBar)StaminaBar.INSTANCE.getRegisteredBars().get((Object)uuid);
            if (bossBar == null) {
                return;
            }
            BossBar bossBar2 = bossBar;
            List list = $this$onLeftClick.getPlayer().getLastTwoTargetBlocks(null, 4);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLastTwoTargetBlocks(...)");
            List blocks = list;
            if (blocks.size() < 2 || ((Block)blocks.get(0)).isLiquid() || ((Block)blocks.get(0)).getLocation().distanceSquared($this$onLeftClick.getPlayer().getLocation()) < 4.0) {
                return;
            }
            Material material = ((Block)blocks.get(1)).getType();
            Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
            Material blockType = material;
            if (this.leftClicked(blockType)) {
                Vector vector = $this$onLeftClick.getPlayer().getLocation().getDirection();
                Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"getDirection(...)");
                Vector direction = vector;
                double x = direction.getX();
                double y = direction.getY();
                double z = direction.getZ();
                Player player2 = $this$onLeftClick.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getPlayer(...)");
                if (ExtensionsKt.getWallDifficulty(player2) < 0.0f) {
                    void $this$onLeftClick_u24lambda_u240;
                    Vector vector2;
                    StaminaBarKt.removeProgress(bossBar2, 0.25f);
                    Vector vector3 = vector2 = $this$onLeftClick.getPlayer().getVelocity();
                    Player player3 = $this$onLeftClick.getPlayer();
                    boolean bl = false;
                    $this$onLeftClick_u24lambda_u240.setX(x / 1.8);
                    $this$onLeftClick_u24lambda_u240.setY(y / (double)2 + 0.3);
                    $this$onLeftClick_u24lambda_u240.setZ(z / 1.8);
                    player3.setVelocity(vector2);
                    ExtensionsKt.setClimbCooldown(uuid, -conf.getAirTime());
                } else {
                    void $this$onLeftClick_u24lambda_u241;
                    Vector vector4;
                    StaminaBarKt.removeProgress(bossBar2, 0.2f);
                    Vector $this$onLeftClick_u24lambda_u240 = vector4 = $this$onLeftClick.getPlayer().getVelocity();
                    Player player4 = $this$onLeftClick.getPlayer();
                    boolean bl = false;
                    $this$onLeftClick_u24lambda_u241.setX(x / 1.8);
                    $this$onLeftClick_u24lambda_u241.setY(y / 1.0);
                    $this$onLeftClick_u24lambda_u241.setZ(z / 1.8);
                    player4.setVelocity(vector4);
                }
            }
        }
    }

    private final boolean allowClimb(Player player) {
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        UUID uuid = uUID;
        return !(!ExtensionsKt.getClimbEnabled(player) || !ExtensionsKt.getCanClimb(uuid) || player.isSneaking() && !(player.getVelocity().getY() < -0.5) || !ExtensionsKt.getClimbCooldownDone(uuid) || player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE);
    }

    private final boolean rightClicked(PlayerInteractEvent $this$rightClicked) {
        if ($this$rightClicked.getClickedBlock() == null) {
            return false;
        }
        Block block = $this$rightClicked.getClickedBlock();
        if (block == null || (block = block.getType()) == null) {
            return false;
        }
        Block block2 = block;
        Material material = $this$rightClicked.getPlayer().getInventory().getItemInMainHand().getType();
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
        Material heldItem = material;
        if (heldItem.isBlock() && heldItem != Material.AIR) {
            UUID uUID = $this$rightClicked.getPlayer().getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            ExtensionsKt.setClimbCooldown(uUID, conf.getJumpCooldown());
            return false;
        }
        if (conf.getClimbBlacklist().contains(block2)) {
            UUID uUID = $this$rightClicked.getPlayer().getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            ExtensionsKt.setClimbCooldown(uUID, conf.getJumpCooldown());
            return false;
        }
        for (String interactable : conf.getClimbBlacklistGeneral()) {
            if (!StringsKt.contains$default((CharSequence)interactable, (CharSequence)block2.toString(), (boolean)false, (int)2, null)) continue;
            UUID uUID = $this$rightClicked.getPlayer().getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            ExtensionsKt.setClimbCooldown(uUID, conf.getJumpCooldown());
            return false;
        }
        return $this$rightClicked.getAction() == Action.RIGHT_CLICK_BLOCK && $this$rightClicked.getHand() == EquipmentSlot.HAND && block2.isSolid();
    }

    private final boolean leftClicked(Material block) {
        return !conf.getClimbBlacklist().contains(block);
    }

    private final boolean cooldownComplete(UUID uuid) {
        Long l = (Long)cooldown.get((Object)uuid);
        if (l == null) {
            return true;
        }
        long playerCooldown = l;
        return playerCooldown <= System.currentTimeMillis();
    }
}

