/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.features.anticheese;

import androidx.compose.runtime.internal.StabilityInferred;
import com.destroystokyo.paper.event.block.AnvilDamagedEvent;
import com.mineinabyss.features.helpers.LayerUtilsKt;
import com.mineinabyss.features.hubstorage.HubStorageHelpersKt;
import com.mineinabyss.idofront.messaging.LoggingKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0007J\f\u0010\u0007\u001a\u00020\u0005*\u00020\bH\u0007J\f\u0010\t\u001a\u00020\u0005*\u00020\nH\u0007J\f\u0010\u000b\u001a\u00020\u0005*\u00020\fH\u0007J\f\u0010\r\u001a\u00020\u0005*\u00020\u000eH\u0007J\f\u0010\u000f\u001a\u00020\u0005*\u00020\u0010H\u0007J\f\u0010\u0011\u001a\u00020\u0005*\u00020\u0012H\u0007\u00a8\u0006\u0013"}, d2={"Lcom/mineinabyss/features/anticheese/AntiCheeseListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onSculkSpread", "", "Lorg/bukkit/event/block/BlockSpreadEvent;", "onDamageAnvilOrth", "Lcom/destroystokyo/paper/event/block/AnvilDamagedEvent;", "preventPlacement", "Lorg/bukkit/event/block/BlockPlaceEvent;", "onPlayerHit", "Lorg/bukkit/event/entity/EntityPotionEffectEvent;", "preventBackpackPlace", "Lorg/bukkit/event/block/BlockDispenseEvent;", "cancelMinecartTNT", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "cancelBlockGrief", "Lorg/bukkit/event/player/PlayerFishEvent;", "mineinabyss-features"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nAntiCheeseListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AntiCheeseListener.kt\ncom/mineinabyss/features/anticheese/AntiCheeseListener\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,91:1\n14060#2,2:92\n*S KotlinDebug\n*F\n+ 1 AntiCheeseListener.kt\ncom/mineinabyss/features/anticheese/AntiCheeseListener\n*L\n69#1:92,2\n*E\n"})
public final class AntiCheeseListener
implements Listener {
    public static final int $stable;

    @EventHandler
    public final void onSculkSpread(@NotNull BlockSpreadEvent $this$onSculkSpread) {
        Intrinsics.checkNotNullParameter((Object)$this$onSculkSpread, (String)"<this>");
        if ($this$onSculkSpread.getBlock().getType() == Material.SCULK || $this$onSculkSpread.getBlock().getType() == Material.SCULK_VEIN) {
            $this$onSculkSpread.setCancelled(true);
        }
    }

    @EventHandler
    public final void onDamageAnvilOrth(@NotNull AnvilDamagedEvent $this$onDamageAnvilOrth) {
        Intrinsics.checkNotNullParameter((Object)$this$onDamageAnvilOrth, (String)"<this>");
        List list = $this$onDamageAnvilOrth.getViewers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getViewers(...)");
        Object object = CollectionsKt.firstOrNull((List)list);
        Player player = object instanceof Player ? (Player)object : null;
        boolean bl = player != null ? HubStorageHelpersKt.isInHub((Entity)player) : false;
        if (bl) {
            $this$onDamageAnvilOrth.setCancelled(true);
        }
    }

    @EventHandler
    public final void preventPlacement(@NotNull BlockPlaceEvent $this$preventPlacement) {
        Intrinsics.checkNotNullParameter((Object)$this$preventPlacement, (String)"<this>");
        Location location = $this$preventPlacement.getPlayer().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        Object object = LayerUtilsKt.getLayer(location);
        boolean bl = object != null && (object = object.getBlockBlacklist()) != null ? object.contains($this$preventPlacement.getBlockPlaced().getType()) : false;
        if (bl) {
            Player player = $this$preventPlacement.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            LoggingKt.error((CommandSender)((CommandSender)player), (Object)"You may not place this block on this layer.");
            $this$preventPlacement.setCancelled(true);
        }
    }

    @EventHandler
    public final void onPlayerHit(@NotNull EntityPotionEffectEvent $this$onPlayerHit) {
        Intrinsics.checkNotNullParameter((Object)$this$onPlayerHit, (String)"<this>");
        Entity entity = $this$onPlayerHit.getEntity();
        Player player = entity instanceof Player ? (Player)entity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        if ($this$onPlayerHit.getCause() != EntityPotionEffectEvent.Cause.PLUGIN && $this$onPlayerHit.getCause() != EntityPotionEffectEvent.Cause.COMMAND) {
            PotionEffect potionEffect = $this$onPlayerHit.getNewEffect();
            if (Intrinsics.areEqual((Object)(potionEffect != null ? potionEffect.getType() : null), (Object)PotionEffectType.RESISTANCE)) {
                $this$onPlayerHit.setCancelled(true);
                LoggingKt.error((CommandSender)((CommandSender)player2), (Object)"The <b>Resistance Effect</b> has been disabled");
            } else {
                PotionEffect potionEffect2 = $this$onPlayerHit.getNewEffect();
                if (Intrinsics.areEqual((Object)(potionEffect2 != null ? potionEffect2.getType() : null), (Object)PotionEffectType.SLOW_FALLING)) {
                    $this$onPlayerHit.setCancelled(true);
                    LoggingKt.error((CommandSender)((CommandSender)player2), (Object)"<b>Slow Falling</b> has been disabled");
                }
            }
        } else if ($this$onPlayerHit.getCause() == EntityPotionEffectEvent.Cause.MILK) {
            $this$onPlayerHit.setCancelled(true);
            LoggingKt.error((CommandSender)((CommandSender)player2), (Object)"<b>Milk</b> has been disabled");
        }
    }

    @EventHandler
    public final void preventBackpackPlace(@NotNull BlockDispenseEvent $this$preventBackpackPlace) {
        Intrinsics.checkNotNullParameter((Object)$this$preventBackpackPlace, (String)"<this>");
        if (Tag.ITEMS_SHULKER_BOXES.isTagged((Keyed)$this$preventBackpackPlace.getItem().getType())) {
            BlockState blockState = $this$preventBackpackPlace.getBlock().getState();
            Intrinsics.checkNotNull((Object)blockState, (String)"null cannot be cast to non-null type org.bukkit.block.Dispenser");
            ItemStack[] itemStackArray = ((Dispenser)blockState).getInventory().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getContents(...)");
            ItemStack[] inv = itemStackArray;
            Block block = $this$preventBackpackPlace.getBlock();
            BlockData blockData = $this$preventBackpackPlace.getBlock().getBlockData();
            Intrinsics.checkNotNull((Object)blockData, (String)"null cannot be cast to non-null type org.bukkit.block.data.Directional");
            Block block2 = block.getRelative(((Directional)blockData).getFacing());
            Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"getRelative(...)");
            Block relative = block2;
            if (relative.isSolid() || !relative.isReplaceable()) {
                return;
            }
            ItemStack[] $this$forEach$iv = inv;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                ItemStack element$iv;
                ItemStack it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)$this$preventBackpackPlace.getItem())) continue;
                it.subtract(1);
            }
            $this$preventBackpackPlace.setCancelled(true);
            $this$preventBackpackPlace.getBlock().getWorld().dropItemNaturally(relative.getLocation(), $this$preventBackpackPlace.getItem());
        }
    }

    @EventHandler
    public final void cancelMinecartTNT(@NotNull EntityDamageByEntityEvent $this$cancelMinecartTNT) {
        Intrinsics.checkNotNullParameter((Object)$this$cancelMinecartTNT, (String)"<this>");
        if ($this$cancelMinecartTNT.getDamager() instanceof ExplosiveMinecart) {
            $this$cancelMinecartTNT.setCancelled(true);
        }
    }

    @EventHandler
    public final void cancelBlockGrief(@NotNull PlayerFishEvent $this$cancelBlockGrief) {
        Intrinsics.checkNotNullParameter((Object)$this$cancelBlockGrief, (String)"<this>");
        Entity entity = $this$cancelBlockGrief.getCaught();
        if ((entity != null ? entity.getType() : null) != EntityType.PLAYER) {
            Player player = $this$cancelBlockGrief.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            if (HubStorageHelpersKt.isInHub((Entity)player)) {
                $this$cancelBlockGrief.setCancelled(true);
            }
        }
    }
}

