/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.features.quests;

import androidx.compose.runtime.internal.StabilityInferred;
import com.mineinabyss.features.quests.LocationData;
import com.mineinabyss.features.quests.QuestConfig;
import com.mineinabyss.features.quests.QuestManager;
import com.mineinabyss.features.quests.VisitQuest;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/mineinabyss/features/quests/QuestListener;", "Lorg/bukkit/event/Listener;", "questConfig", "Lcom/mineinabyss/features/quests/QuestConfig;", "<init>", "(Lcom/mineinabyss/features/quests/QuestConfig;)V", "getQuestConfig", "()Lcom/mineinabyss/features/quests/QuestConfig;", "onLocationEnter", "", "Lorg/bukkit/event/player/PlayerMoveEvent;", "mineinabyss-features"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nQuestListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuestListener.kt\ncom/mineinabyss/features/quests/QuestListener\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n221#2:43\n222#2:46\n1915#3,2:44\n*S KotlinDebug\n*F\n+ 1 QuestListener.kt\ncom/mineinabyss/features/quests/QuestListener\n*L\n27#1:43\n27#1:46\n33#1:44,2\n*E\n"})
public final class QuestListener
implements Listener {
    @NotNull
    private final QuestConfig questConfig;
    public static final int $stable = 8;

    public QuestListener(@NotNull QuestConfig questConfig) {
        Intrinsics.checkNotNullParameter((Object)questConfig, (String)"questConfig");
        this.questConfig = questConfig;
    }

    @NotNull
    public final QuestConfig getQuestConfig() {
        return this.questConfig;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onLocationEnter(@NotNull PlayerMoveEvent $this$onLocationEnter) {
        Intrinsics.checkNotNullParameter((Object)$this$onLocationEnter, (String)"<this>");
        if (!$this$onLocationEnter.hasExplicitlyChangedBlock()) {
            return;
        }
        Player player = $this$onLocationEnter.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Set<String> activeQuests = QuestManager.INSTANCE.activeQuests(player);
        Player player2 = $this$onLocationEnter.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getPlayer(...)");
        Set<String> playerVisitedLocations = QuestManager.INSTANCE.visitedLocations(player2);
        Map<String, VisitQuest> $this$forEach$iv = this.questConfig.getVisitQuests();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, VisitQuest>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, VisitQuest> element$iv;
            Map.Entry<String, VisitQuest> quest = element$iv = iterator.next();
            boolean bl = false;
            if (!activeQuests.contains(quest.getKey())) continue;
            Iterable $this$forEach$iv2 = quest.getValue().getLocations();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                LocationData location = (LocationData)element$iv2;
                boolean bl2 = false;
                if (playerVisitedLocations.contains(location.getName())) continue;
                Location location2 = $this$onLocationEnter.getTo();
                Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"getTo(...)");
                if (!LocationData.isInside$default(location, location2, false, 2, null)) continue;
                Player player3 = $this$onLocationEnter.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player3, (String)"getPlayer(...)");
                QuestManager.INSTANCE.addVisitedLocation(player3, location.getName());
                Player player4 = $this$onLocationEnter.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player4, (String)"getPlayer(...)");
                Pair<Integer, Integer> progress = QuestManager.INSTANCE.visitQuestProgress(player4, quest.getKey());
                Player player5 = $this$onLocationEnter.getPlayer();
                Player player6 = $this$onLocationEnter.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player6, (String)"getPlayer(...)");
                player5.sendActionBar(QuestManager.INSTANCE.questInformation(player6, quest.getKey()));
            }
        }
    }
}

