/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.features.gondolas;

import androidx.compose.runtime.internal.StabilityInferred;
import com.mineinabyss.components.gondolas.Gondola;
import com.mineinabyss.features.gondolas.GondolaData;
import com.mineinabyss.features.gondolas.GondolaType;
import com.mineinabyss.features.gondolas.pass.TicketHelperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\r\u00a8\u0006\u0019"}, d2={"Lcom/mineinabyss/features/gondolas/GondolasHelpers;", "", "<init>", "()V", "gondolaWarp", "", "gondola", "Lcom/mineinabyss/components/gondolas/Gondola;", "player", "Lorg/bukkit/entity/Player;", "gondolaType", "Lcom/mineinabyss/features/gondolas/GondolaType;", "gondolaId", "", "locContains", "", "loc", "Lorg/bukkit/Location;", "point", "radius", "", "closestGondolaData", "Lcom/mineinabyss/features/gondolas/GondolaData;", "location", "id", "mineinabyss-features"})
@StabilityInferred(parameters=1)
public final class GondolasHelpers {
    @NotNull
    public static final GondolasHelpers INSTANCE = new GondolasHelpers();
    public static final int $stable;

    private GondolasHelpers() {
    }

    public final void gondolaWarp(@NotNull Gondola gondola, @NotNull Player player, @NotNull GondolaType gondolaType, @Nullable String gondolaId) {
        Intrinsics.checkNotNullParameter((Object)gondola, (String)"gondola");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)gondolaType), (String)"gondolaType");
        player.teleportAsync(gondolaType == GondolaType.LOWER ? gondola.getUpperLoc() : gondola.getLowerLoc());
        if (gondola.getConsumeTicket() && gondolaId != null) {
            TicketHelperKt.removeRoute(player, gondolaId);
        }
    }

    public static /* synthetic */ void gondolaWarp$default(GondolasHelpers gondolasHelpers, Gondola gondola, Player player, GondolaType gondolaType, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        gondolasHelpers.gondolaWarp(gondola, player, gondolaType, string);
    }

    public final boolean locContains(@NotNull Location loc, @NotNull Location point, double radius) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (!Intrinsics.areEqual((Object)loc.getWorld().getUID(), (Object)point.getWorld().getUID())) {
            return false;
        }
        return loc.distanceSquared(point) <= radius * radius;
    }

    @NotNull
    public final GondolaData closestGondolaData(@NotNull Gondola gondola, @NotNull Location location, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)gondola, (String)"gondola");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.locContains(gondola.getUpperLoc(), location, gondola.getWarpZoneRange())) {
            return new GondolaData(id, gondola, GondolaType.UPPER);
        }
        if (this.locContains(gondola.getLowerLoc(), location, gondola.getWarpZoneRange())) {
            return new GondolaData(id, gondola, GondolaType.LOWER);
        }
        return new GondolaData(id, gondola, GondolaType.NONE);
    }
}

