/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.features.quests;

import androidx.compose.runtime.internal.StabilityInferred;
import com.mineinabyss.features.helpers.LuckPermsHelpersKt;
import com.mineinabyss.features.quests.LocationData;
import com.mineinabyss.features.quests.QuestConfig;
import com.mineinabyss.features.quests.QuestConfigHolder;
import com.mineinabyss.features.quests.QuestData;
import com.mineinabyss.features.quests.VisitQuest;
import com.mineinabyss.geary.datatypes.Entity;
import com.mineinabyss.geary.helpers.EngineHelpersKt;
import com.mineinabyss.geary.modules.Geary;
import com.mineinabyss.geary.papermc.WorldManagerKt;
import com.mineinabyss.geary.papermc.tracking.entities.ConversionKt;
import com.mineinabyss.geary.papermc.tracking.items.ItemTrackingKt;
import com.mineinabyss.geary.papermc.tracking.items.ItemTrackingModule;
import com.mineinabyss.geary.prefabs.PrefabKey;
import com.mineinabyss.geary.serialization.SerializableComponentsKt;
import com.mineinabyss.geary.serialization.SerializableComponentsModule;
import com.mineinabyss.geary.serialization.components.Persists;
import com.mineinabyss.idofront.messaging.LoggingKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.ScopedNode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\nH\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\rJ\u0016\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\rJ\u0016\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\rJ\u0016\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\rJ\u0016\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\rJ\u0016\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\rJ\"\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\rJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005J\u001e\u0010!\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005J\u001e\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005J\u0016\u0010#\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\rJ\u0016\u0010$\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\rJ\u0016\u0010%\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\rJ\u0016\u0010&\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010'\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006("}, d2={"Lcom/mineinabyss/features/quests/QuestManager;", "", "<init>", "()V", "getQuestData", "Lcom/mineinabyss/features/quests/QuestData;", "player", "Lorg/bukkit/entity/Player;", "update", "", "Lkotlin/Function1;", "activeQuests", "", "", "completedQuests", "visitedLocations", "questInformation", "Lnet/kyori/adventure/text/Component;", "questId", "addVisitedLocation", "locationName", "addQuest", "completeQuest", "giveQuestReward", "unlockQuest", "visitQuestProgress", "Lkotlin/Pair;", "", "isVisitQuestCompleted", "", "config", "Lcom/mineinabyss/features/quests/QuestConfig;", "questData", "isKillQuestCompleted", "isFetchQuestCompleted", "isQuestCompleted", "checkAndCompleteQuest", "playerHasUnlockedQuest", "playerHasCompletedQuest", "resetQuests", "mineinabyss-features"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nQuestManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuestManager.kt\ncom/mineinabyss/features/quests/QuestManager\n+ 2 EntitySerializationExtensions.kt\ncom/mineinabyss/geary/serialization/EntitySerializationExtensionsKt\n+ 3 Entity.kt\ncom/mineinabyss/geary/datatypes/Entity\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n52#2,5:187\n17#2,6:194\n23#2,2:201\n17#2,6:203\n23#2,2:210\n17#2,6:227\n23#2,2:234\n151#3:192\n75#3:200\n75#3:209\n75#3:233\n1#4:193\n221#5,2:212\n221#5,2:214\n1586#6:216\n1661#6,3:217\n1834#6,4:220\n1786#6,3:224\n1915#6,2:236\n*S KotlinDebug\n*F\n+ 1 QuestManager.kt\ncom/mineinabyss/features/quests/QuestManager\n*L\n33#1:187,5\n33#1:194,6\n33#1:201,2\n40#1:203,6\n40#1:210,2\n184#1:227,6\n184#1:234,2\n33#1:192\n33#1:200\n40#1:209\n184#1:233\n33#1:193\n88#1:212,2\n94#1:214,2\n101#1:216\n101#1:217,3\n130#1:220,4\n141#1:224,3\n103#1:236,2\n*E\n"})
public final class QuestManager {
    @NotNull
    public static final QuestManager INSTANCE = new QuestManager();
    public static final int $stable;

    private QuestManager() {
    }

    /*
     * WARNING - void declaration
     */
    private final QuestData getQuestData(Player player) {
        QuestData questData;
        void this_$iv$iv;
        Entity $this$getOrSetPersisting_u24default$iv = ConversionKt.toGeary((org.bukkit.entity.Entity)((org.bukkit.entity.Entity)player));
        KClass kClass$iv = Reflection.getOrCreateKotlinClass(QuestData.class);
        boolean $i$f$getOrSetPersisting = false;
        Object object = $this$getOrSetPersisting_u24default$iv;
        KClass kClass$iv$iv = kClass$iv;
        boolean $i$f$get = false;
        Object object2 = this_$iv$iv.get-VKZWuLQ(EngineHelpersKt.componentId((Geary)this_$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv)));
        if (!(object2 instanceof QuestData)) {
            object2 = null;
        }
        if ((questData = (QuestData)object2) == null) {
            void kClass$iv$iv$iv;
            void component$iv$iv$iv;
            void this_$iv$iv$iv;
            void component$iv$iv;
            void $this$setPersisting_u24default$iv$iv;
            boolean bl = false;
            Object it$iv = object = new QuestData(null, null, null, 7, null);
            boolean bl2 = false;
            Entity entity = $this$getOrSetPersisting_u24default$iv;
            Object object3 = it$iv;
            KClass kClass$iv$iv2 = kClass$iv;
            boolean noEvent$iv$iv = false;
            boolean $i$f$setPersisting = false;
            void var14_14 = $this$setPersisting_u24default$iv$iv;
            void var15_15 = component$iv$iv;
            KClass kClass = kClass$iv$iv2;
            boolean noEvent$iv$iv$iv = noEvent$iv$iv;
            boolean $i$f$set = false;
            this_$iv$iv$iv.set-z13BHRw((Object)component$iv$iv$iv, EngineHelpersKt.componentId((Geary)this_$iv$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv$iv)), noEvent$iv$iv$iv);
            $this$setPersisting_u24default$iv$iv.setRelation-x53JL5M(((SerializableComponentsModule)$this$setPersisting_u24default$iv$iv.getWorld().getAddon(SerializableComponentsKt.getSerializableComponents())).getPersists-s-VKNKU(), EngineHelpersKt.componentId((Geary)$this$setPersisting_u24default$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv2)), (Object)new Persists(0, 1, null), noEvent$iv$iv);
            questData = object;
        }
        return questData;
    }

    /*
     * WARNING - void declaration
     */
    private final void update(Player player, Function1<? super QuestData, QuestData> update) {
        void kClass$iv$iv;
        void component$iv$iv;
        void this_$iv$iv;
        void $this$setPersisting_u24default$iv;
        QuestData data = this.getQuestData(player);
        QuestData newData = (QuestData)update.invoke((Object)data);
        Entity entity = ConversionKt.toGeary((org.bukkit.entity.Entity)((org.bukkit.entity.Entity)player));
        QuestData component$iv = newData;
        KClass kClass$iv = Reflection.getOrCreateKotlinClass(QuestData.class);
        boolean noEvent$iv = false;
        boolean $i$f$setPersisting = false;
        void var10_10 = $this$setPersisting_u24default$iv;
        QuestData questData = component$iv;
        KClass kClass = kClass$iv;
        boolean noEvent$iv$iv = noEvent$iv;
        boolean $i$f$set = false;
        this_$iv$iv.set-z13BHRw((Object)component$iv$iv, EngineHelpersKt.componentId((Geary)this_$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv)), noEvent$iv$iv);
        $this$setPersisting_u24default$iv.setRelation-x53JL5M(((SerializableComponentsModule)$this$setPersisting_u24default$iv.getWorld().getAddon(SerializableComponentsKt.getSerializableComponents())).getPersists-s-VKNKU(), EngineHelpersKt.componentId((Geary)$this$setPersisting_u24default$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv)), (Object)new Persists(0, 1, null), noEvent$iv);
    }

    @NotNull
    public final Set<String> activeQuests(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.getQuestData(player).getActiveQuests();
    }

    @NotNull
    public final Set<String> completedQuests(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.getQuestData(player).getCompletedQuests();
    }

    @NotNull
    public final Set<String> visitedLocations(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.getQuestData(player).getVisitedLocations();
    }

    @NotNull
    public final Component questInformation(@NotNull Player player, @NotNull String questId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)questId, (String)"questId");
        QuestConfig questConfig = QuestConfigHolder.INSTANCE.getConfig();
        Intrinsics.checkNotNull((Object)questConfig);
        QuestConfig config2 = questConfig;
        Object object = config2.getVisitQuests().get(questId);
        if (object == null || (object = ((VisitQuest)object).getDisplayName()) == null) {
            TextComponent textComponent = Component.text((String)questId);
            Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(...)");
            return (Component)textComponent;
        }
        Object visitQuest = object;
        Pair<Integer, Integer> progress = this.visitQuestProgress(player, questId);
        TextComponent textComponent = Component.text((String)("\"" + (String)visitQuest + "\" - " + progress.getFirst() + "/" + progress.getSecond() + " locations visited."));
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(...)");
        return (Component)textComponent;
    }

    public final void addVisitedLocation(@NotNull Player player, @NotNull String locationName) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)locationName, (String)"locationName");
        this.update(player, (Function1<? super QuestData, QuestData>)((Function1)arg_0 -> QuestManager.addVisitedLocation$lambda$0(locationName, arg_0)));
    }

    public final void addQuest(@NotNull Player player, @NotNull String questId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)questId, (String)"questId");
        this.update(player, (Function1<? super QuestData, QuestData>)((Function1)arg_0 -> QuestManager.addQuest$lambda$0(questId, arg_0)));
    }

    public final void completeQuest(@NotNull Player player, @NotNull String questId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)questId, (String)"questId");
        this.update(player, (Function1<? super QuestData, QuestData>)((Function1)arg_0 -> QuestManager.completeQuest$lambda$0(questId, arg_0)));
        this.giveQuestReward(player, questId);
    }

    /*
     * WARNING - void declaration
     */
    public final void giveQuestReward(@NotNull Player player, @NotNull String questId) {
        Object material;
        int amount;
        boolean bl;
        Map.Entry<Object, Integer> entry;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)questId, (String)"questId");
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
        ItemTrackingModule gearyItems = (ItemTrackingModule)WorldManagerKt.toGeary((World)world).getAddon(ItemTrackingKt.getItemTracking());
        QuestConfig questConfig = QuestConfigHolder.INSTANCE.getConfig();
        if (questConfig == null) {
            throw new IllegalStateException(("Trying to complete quest " + questId + " but QuestConfig is not initialized").toString());
        }
        QuestConfig config2 = questConfig;
        VisitQuest visitQuest = config2.getVisitQuests().get(questId);
        if (visitQuest == null) {
            return;
        }
        VisitQuest visitQuest2 = visitQuest;
        Map<Object, Integer> $this$forEach$iv = visitQuest2.getGearyRewards();
        boolean $i$f$forEach = false;
        for (Map.Entry<PrefabKey, Integer> entry2 : $this$forEach$iv.entrySet()) {
            ItemStack gearyItem;
            entry = entry2;
            bl = false;
            PrefabKey item = entry.getKey();
            amount = ((Number)entry.getValue()).intValue();
            if (ItemTrackingModule.createItem$default((ItemTrackingModule)gearyItems, (PrefabKey)item, null, (int)2, null) == null) {
                throw new IllegalStateException(("Failed to complete quest " + questId + ": Geary prefab " + item + " not found").toString());
            }
            gearyItem.setAmount(RangesKt.coerceIn((int)amount, (int)1, (int)gearyItem.getMaxStackSize()));
            ItemStack[] itemStackArray = new ItemStack[]{gearyItem};
            player.getInventory().addItem(itemStackArray);
        }
        $this$forEach$iv = visitQuest2.getVanillaRewards();
        $i$f$forEach = false;
        for (Map.Entry<Object, Integer> entry3 : $this$forEach$iv.entrySet()) {
            entry = entry3;
            bl = false;
            String itemName = (String)entry.getKey();
            amount = ((Number)entry.getValue()).intValue();
            if (Material.matchMaterial((String)itemName) == null) {
                throw new IllegalStateException(("Failed to complete quest " + questId + ": Material " + itemName + " not found").toString());
            }
            ItemStack itemStack = new ItemStack(material);
            itemStack.setAmount(RangesKt.coerceIn((int)amount, (int)1, (int)itemStack.getMaxStackSize()));
            ItemStack[] itemStackArray = new ItemStack[]{itemStack};
            player.getInventory().addItem(itemStackArray);
        }
        Iterable $this$map$iv = visitQuest2.getPerms();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : iterable) {
            void it;
            material = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            ScopedNode scopedNode = Node.builder((String)it).value(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)scopedNode, (String)"build(...)");
            collection.add(scopedNode);
        }
        List nodes = (List)destination$iv$iv;
        if (!((Collection)nodes).isEmpty()) {
            LuckPermsHelpersKt.getLuckPerms().getUserManager().modifyUser(player.getUniqueId(), arg_0 -> QuestManager.giveQuestReward$lambda$4(arg_0 -> QuestManager.giveQuestReward$lambda$3(nodes, arg_0), arg_0));
        }
    }

    public final void unlockQuest(@NotNull Player player, @NotNull String questId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)questId, (String)"questId");
        QuestConfig questConfig = QuestConfigHolder.INSTANCE.getConfig();
        if (questConfig == null) {
            throw new IllegalStateException(("Trying to unlock quest " + questId + " but QuestConfig is not initialized").toString());
        }
        QuestConfig config2 = questConfig;
        if (!config2.getVisitQuests().keySet().contains(questId)) {
            throw new IllegalStateException(("Trying to unlock quest " + questId + " but it does not exist in the QuestConfig").toString());
        }
        QuestData questData = this.getQuestData(player);
        if (questData.getActiveQuests().contains(questId)) {
            throw new IllegalStateException(("Trying to unlock quest " + questId + " but player already has it active").toString());
        }
        if (questData.getCompletedQuests().contains(questId)) {
            throw new IllegalStateException(("Trying to unlock quest " + questId + " but player has already completed it").toString());
        }
        this.addQuest(player, questId);
    }

    @NotNull
    public final Pair<Integer, Integer> visitQuestProgress(@NotNull Player player, @NotNull String questId) {
        int n;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)questId, (String)"questId");
        QuestConfig questConfig = QuestConfigHolder.INSTANCE.getConfig();
        if (questConfig == null) {
            throw new IllegalStateException(("Trying to get progress of quest " + questId + " but QuestConfig is not initialized").toString());
        }
        QuestConfig config2 = questConfig;
        VisitQuest visitQuest = config2.getVisitQuests().get(questId);
        if (visitQuest == null) {
            throw new IllegalStateException(("Trying to get progress of quest " + questId + " but it does not exist in the QuestConfig").toString());
        }
        VisitQuest visitQuest2 = visitQuest;
        QuestData questData = this.getQuestData(player);
        int totalLocations = visitQuest2.getLocations().size();
        if (totalLocations == 0) {
            return TuplesKt.to((Object)0, (Object)0);
        }
        Iterable $this$count$iv = visitQuest2.getLocations();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                LocationData locationData = (LocationData)element$iv;
                boolean bl = false;
                if (!questData.getVisitedLocations().contains(locationData.getName()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int visitedLocations = n;
        return TuplesKt.to((Object)visitedLocations, (Object)totalLocations);
    }

    public final boolean isVisitQuestCompleted(@NotNull String questId, @NotNull QuestConfig config2, @NotNull QuestData questData) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)questId, (String)"questId");
            Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
            Intrinsics.checkNotNullParameter((Object)questData, (String)"questData");
            VisitQuest visitQuest = config2.getVisitQuests().get(questId);
            if (visitQuest == null) {
                return false;
            }
            VisitQuest visitQuest2 = visitQuest;
            Iterable $this$all$iv = visitQuest2.getLocations();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    LocationData locationData = (LocationData)element$iv;
                    boolean bl2 = false;
                    if (questData.getVisitedLocations().contains(locationData.getName())) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean isKillQuestCompleted(@NotNull String questId, @NotNull QuestConfig config2, @NotNull QuestData questData) {
        Intrinsics.checkNotNullParameter((Object)questId, (String)"questId");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)questData, (String)"questData");
        return false;
    }

    public final boolean isFetchQuestCompleted(@NotNull String questId, @NotNull QuestConfig config2, @NotNull QuestData questData) {
        Intrinsics.checkNotNullParameter((Object)questId, (String)"questId");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)questData, (String)"questData");
        return false;
    }

    public final boolean isQuestCompleted(@NotNull Player player, @NotNull String questId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)questId, (String)"questId");
        QuestConfig questConfig = QuestConfigHolder.INSTANCE.getConfig();
        if (questConfig == null) {
            throw new IllegalStateException(("Trying to check completion of quest " + questId + " but QuestConfig is not initialized").toString());
        }
        QuestConfig config2 = questConfig;
        QuestData questData = this.getQuestData(player);
        Set<String> activeQuests = questData.getActiveQuests();
        if (!activeQuests.contains(questId)) {
            return false;
        }
        return this.isVisitQuestCompleted(questId, config2, questData) || this.isKillQuestCompleted(questId, config2, questData) || this.isFetchQuestCompleted(questId, config2, questData);
    }

    public final void checkAndCompleteQuest(@NotNull Player player, @NotNull String questId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)questId, (String)"questId");
        if (this.isQuestCompleted(player, questId)) {
            this.completeQuest(player, questId);
        } else {
            LoggingKt.error((CommandSender)((CommandSender)player), (Object)"You haven't completed this quest yet!");
        }
    }

    public final boolean playerHasUnlockedQuest(@NotNull Player player, @NotNull String questId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)questId, (String)"questId");
        QuestData questData = this.getQuestData(player);
        return questData.getActiveQuests().contains(questId);
    }

    public final boolean playerHasCompletedQuest(@NotNull Player player, @NotNull String questId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)questId, (String)"questId");
        QuestData questData = this.getQuestData(player);
        return questData.getCompletedQuests().contains(questId);
    }

    /*
     * WARNING - void declaration
     */
    public final void resetQuests(@NotNull Player player) {
        void kClass$iv$iv;
        void component$iv$iv;
        void this_$iv$iv;
        void $this$setPersisting_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Entity entity = ConversionKt.toGeary((org.bukkit.entity.Entity)((org.bukkit.entity.Entity)player));
        QuestData component$iv = new QuestData(null, null, null, 7, null);
        KClass kClass$iv = Reflection.getOrCreateKotlinClass(QuestData.class);
        boolean noEvent$iv = false;
        boolean $i$f$setPersisting = false;
        void var7_7 = $this$setPersisting_u24default$iv;
        QuestData questData = component$iv;
        KClass kClass = kClass$iv;
        boolean noEvent$iv$iv = noEvent$iv;
        boolean $i$f$set = false;
        this_$iv$iv.set-z13BHRw((Object)component$iv$iv, EngineHelpersKt.componentId((Geary)this_$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv)), noEvent$iv$iv);
        $this$setPersisting_u24default$iv.setRelation-x53JL5M(((SerializableComponentsModule)$this$setPersisting_u24default$iv.getWorld().getAddon(SerializableComponentsKt.getSerializableComponents())).getPersists-s-VKNKU(), EngineHelpersKt.componentId((Geary)$this$setPersisting_u24default$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv)), (Object)new Persists(0, 1, null), noEvent$iv);
    }

    private static final QuestData addVisitedLocation$lambda$0(String $locationName, QuestData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return QuestData.copy$default(data, SetsKt.plus(data.getVisitedLocations(), (Object)$locationName), null, null, 6, null);
    }

    private static final QuestData addQuest$lambda$0(String $questId, QuestData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return QuestData.copy$default(data, null, null, SetsKt.plus(data.getActiveQuests(), (Object)$questId), 3, null);
    }

    private static final QuestData completeQuest$lambda$0(String $questId, QuestData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Set set = SetsKt.minus(data.getActiveQuests(), (Object)$questId);
        Set set2 = SetsKt.plus(data.getCompletedQuests(), (Object)$questId);
        return QuestData.copy$default(data, null, set2, set, 1, null);
    }

    private static final Unit giveQuestReward$lambda$3(List $nodes, User lpUser) {
        Iterable $this$forEach$iv = $nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScopedNode it = (ScopedNode)element$iv;
            boolean bl = false;
            lpUser.data().add((Node)it);
        }
        return Unit.INSTANCE;
    }

    private static final void giveQuestReward$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

