/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.features.npc;

import androidx.compose.runtime.internal.StabilityInferred;
import com.mineinabyss.features.npc.Npc;
import com.mineinabyss.features.npc.NpcEntity;
import com.mineinabyss.features.npc.NpcsConfig;
import com.mineinabyss.features.npc.action.DialogData;
import com.mineinabyss.features.npc.action.DialogsConfig;
import com.mineinabyss.features.npc.action.QuestDialogData;
import com.mineinabyss.features.npc.shopkeeping.ListenerSingleton;
import com.mineinabyss.geary.datatypes.Entity;
import com.mineinabyss.geary.helpers.EngineHelpersKt;
import com.mineinabyss.geary.modules.Geary;
import com.mineinabyss.geary.papermc.tracking.entities.ConversionKt;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import org.bukkit.World;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001c\u001a\u00020\u001dJ\f\u0010\u001e\u001a\u00020\u001d*\u00020\u001fH\u0007J\f\u0010 \u001a\u00020\u001d*\u00020!H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R#\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lcom/mineinabyss/features/npc/NpcManager;", "Lorg/bukkit/event/Listener;", "npcsConfig", "Lcom/mineinabyss/features/npc/NpcsConfig;", "world", "Lorg/bukkit/World;", "dialogsConfig", "Lcom/mineinabyss/features/npc/action/DialogsConfig;", "<init>", "(Lcom/mineinabyss/features/npc/NpcsConfig;Lorg/bukkit/World;Lcom/mineinabyss/features/npc/action/DialogsConfig;)V", "getNpcsConfig", "()Lcom/mineinabyss/features/npc/NpcsConfig;", "getWorld", "()Lorg/bukkit/World;", "getDialogsConfig", "()Lcom/mineinabyss/features/npc/action/DialogsConfig;", "npcEntities", "", "Lcom/mineinabyss/features/npc/NpcEntity;", "getNpcEntities", "()Ljava/util/List;", "setNpcEntities", "(Ljava/util/List;)V", "npcMap", "", "", "getNpcMap", "()Ljava/util/Map;", "initNpc", "", "handleNpcSpawn", "Lorg/bukkit/event/world/ChunkLoadEvent;", "handleNpcInteraction", "Lorg/bukkit/event/player/PlayerInteractEntityEvent;", "mineinabyss-features"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nNpcManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NpcManager.kt\ncom/mineinabyss/features/npc/NpcManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Entity.kt\ncom/mineinabyss/geary/datatypes/Entity\n*L\n1#1,82:1\n1915#2,2:83\n147#3,5:85\n147#3,5:90\n147#3,5:95\n*S KotlinDebug\n*F\n+ 1 NpcManager.kt\ncom/mineinabyss/features/npc/NpcManager\n*L\n48#1:83,2\n56#1:85,5\n67#1:90,5\n69#1:95,5\n*E\n"})
public final class NpcManager
implements Listener {
    @NotNull
    private final NpcsConfig npcsConfig;
    @NotNull
    private final World world;
    @NotNull
    private final DialogsConfig dialogsConfig;
    @NotNull
    private List<NpcEntity> npcEntities;
    @NotNull
    private final Map<Long, List<NpcEntity>> npcMap;
    public static final int $stable = 8;

    public NpcManager(@NotNull NpcsConfig npcsConfig, @NotNull World world, @NotNull DialogsConfig dialogsConfig) {
        Intrinsics.checkNotNullParameter((Object)npcsConfig, (String)"npcsConfig");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)dialogsConfig, (String)"dialogsConfig");
        this.npcsConfig = npcsConfig;
        this.world = world;
        this.dialogsConfig = dialogsConfig;
        this.npcEntities = CollectionsKt.emptyList();
        this.npcMap = new LinkedHashMap();
    }

    @NotNull
    public final NpcsConfig getNpcsConfig() {
        return this.npcsConfig;
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @NotNull
    public final DialogsConfig getDialogsConfig() {
        return this.dialogsConfig;
    }

    @NotNull
    public final List<NpcEntity> getNpcEntities() {
        return this.npcEntities;
    }

    public final void setNpcEntities(@NotNull List<NpcEntity> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.npcEntities = list;
    }

    @NotNull
    public final Map<Long, List<NpcEntity>> getNpcMap() {
        return this.npcMap;
    }

    public final void initNpc() {
        for (Npc npc : this.npcsConfig.getNpcs().values()) {
            NpcEntity npcEntity = new NpcEntity(npc, this.world, this.dialogsConfig, null, null, 24, null);
            this.npcEntities = CollectionsKt.plus((Collection)this.npcEntities, (Object)npcEntity);
            long chunkKey = npc.getLocation().getChunk().getChunkKey();
            this.npcMap.put(chunkKey, CollectionsKt.plus((Collection)this.npcMap.getOrDefault(chunkKey, CollectionsKt.emptyList()), (Object)npcEntity));
            if (!npc.getLocation().isWorldLoaded() || !npc.getLocation().isChunkLoaded()) continue;
            npcEntity.createBaseNpc();
        }
        ListenerSingleton.INSTANCE.setBstgth(this.npcMap);
    }

    @EventHandler
    public final void handleNpcSpawn(@NotNull ChunkLoadEvent $this$handleNpcSpawn) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$handleNpcSpawn, (String)"<this>");
            List<NpcEntity> list = ListenerSingleton.INSTANCE.getBstgth().get($this$handleNpcSpawn.getChunk().getChunkKey());
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NpcEntity p0 = (NpcEntity)element$iv;
                boolean bl = false;
                p0.createBaseNpc();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void handleNpcInteraction(@NotNull PlayerInteractEntityEvent $this$handleNpcInteraction) {
        void this_$iv$iv;
        Entity this_$iv$iv2;
        Entity gearyEntity;
        Intrinsics.checkNotNullParameter((Object)$this$handleNpcInteraction, (String)"<this>");
        org.bukkit.entity.Entity entity = $this$handleNpcInteraction.getRightClicked();
        ItemDisplay itemDisplay = entity instanceof ItemDisplay ? (ItemDisplay)entity : null;
        if (itemDisplay == null) {
            return;
        }
        ItemDisplay entity2 = itemDisplay;
        Entity entity3 = ConversionKt.toGearyOrNull((org.bukkit.entity.Entity)((org.bukkit.entity.Entity)entity2));
        if (entity3 == null) {
            return;
        }
        Entity this_$iv = gearyEntity = entity3;
        boolean $i$f$get = false;
        Entity entity4 = this_$iv;
        KClass kClass$iv$iv = Reflection.getOrCreateKotlinClass(Npc.class);
        boolean $i$f$get2 = false;
        Object object = this_$iv$iv2.get-VKZWuLQ(EngineHelpersKt.componentId((Geary)this_$iv$iv2.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv)));
        if (!(object instanceof Npc)) {
            object = null;
        }
        Npc npc = (Npc)object;
        if (npc == null) {
            return;
        }
        Npc npcData = npc;
        this_$iv = gearyEntity;
        $i$f$get = false;
        this_$iv$iv2 = this_$iv;
        kClass$iv$iv = Reflection.getOrCreateKotlinClass(DialogData.class);
        $i$f$get2 = false;
        Object object2 = this_$iv$iv2.get-VKZWuLQ(EngineHelpersKt.componentId((Geary)this_$iv$iv2.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv)));
        if (!(object2 instanceof DialogData)) {
            object2 = null;
        }
        DialogData dialogData = (DialogData)object2;
        String dialogId = npcData.getDialogId();
        Entity this_$iv2 = gearyEntity;
        boolean $i$f$get3 = false;
        Entity $i$f$get22 = this_$iv2;
        KClass kClass$iv$iv2 = Reflection.getOrCreateKotlinClass(QuestDialogData.class);
        boolean $i$f$get4 = false;
        Object object3 = this_$iv$iv.get-VKZWuLQ(EngineHelpersKt.componentId((Geary)this_$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv2)));
        if (!(object3 instanceof QuestDialogData)) {
            object3 = null;
        }
        QuestDialogData questDialogData = (QuestDialogData)object3;
        if (dialogData == null) {
            $this$handleNpcInteraction.getPlayer().sendMessage("dialog data missing for npc " + npcData.getId());
        } else if (dialogId != null && questDialogData != null) {
            Player player = $this$handleNpcInteraction.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            npcData.defaultInteraction(player, dialogId, dialogData, questDialogData);
        } else if (dialogId != null) {
            $this$handleNpcInteraction.getPlayer().sendMessage("This NPC is missing dialog data for ID: " + dialogId);
            Player player = $this$handleNpcInteraction.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            npcData.fallbackInteraction(player);
        }
    }
}

