/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.features.npc;

import androidx.compose.runtime.internal.StabilityInferred;
import com.mineinabyss.features.AbyssContextKt;
import com.mineinabyss.features.npc.Npc;
import com.mineinabyss.features.npc.NpcAction.DialogData;
import com.mineinabyss.features.npc.NpcAction.DialogsConfig;
import com.mineinabyss.features.npc.NpcAction.QuestDialogData;
import com.mineinabyss.features.npc.shopkeeping.Trade;
import com.mineinabyss.geary.datatypes.Entity;
import com.mineinabyss.geary.helpers.EngineHelpersKt;
import com.mineinabyss.geary.modules.Geary;
import com.mineinabyss.geary.papermc.WorldManagerKt;
import com.mineinabyss.geary.papermc.tracking.entities.ConversionKt;
import com.mineinabyss.geary.papermc.tracking.items.ItemTrackingKt;
import com.mineinabyss.geary.papermc.tracking.items.ItemTrackingModule;
import com.mineinabyss.geary.prefabs.PrefabKey;
import com.mineinabyss.idofront.messaging.LoggingKt;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.view.MerchantView;
import org.bukkit.inventory.view.builder.MerchantInventoryViewBuilder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010\u001c\u001a\u00020\u0017J\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/mineinabyss/features/npc/NpcEntity;", "", "config", "Lcom/mineinabyss/features/npc/Npc;", "mainWorld", "Lorg/bukkit/World;", "dialogsConfig", "Lcom/mineinabyss/features/npc/NpcAction/DialogsConfig;", "dialogData", "Lcom/mineinabyss/features/npc/NpcAction/DialogData;", "questDialog", "<init>", "(Lcom/mineinabyss/features/npc/Npc;Lorg/bukkit/World;Lcom/mineinabyss/features/npc/NpcAction/DialogsConfig;Lcom/mineinabyss/features/npc/NpcAction/DialogData;Lcom/mineinabyss/features/npc/NpcAction/DialogData;)V", "getConfig", "()Lcom/mineinabyss/features/npc/Npc;", "getMainWorld", "()Lorg/bukkit/World;", "getDialogsConfig", "()Lcom/mineinabyss/features/npc/NpcAction/DialogsConfig;", "getDialogData", "()Lcom/mineinabyss/features/npc/NpcAction/DialogData;", "getQuestDialog", "createBaseNpc", "", "createTypedNpc", "createDialogueNpc", "createQuestGiverNpc", "createGondolaUnlockerNpc", "createTraderNpc", "createMerchantRecipes", "", "Lorg/bukkit/inventory/MerchantRecipe;", "trades", "Lcom/mineinabyss/features/npc/shopkeeping/Trade;", "mineinabyss-features"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nNpcEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NpcEntity.kt\ncom/mineinabyss/features/npc/NpcEntity\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Entity.kt\ncom/mineinabyss/geary/datatypes/Entity\n*L\n1#1,160:1\n13472#2,2:161\n71#3,5:163\n71#3,5:168\n71#3,5:173\n*S KotlinDebug\n*F\n+ 1 NpcEntity.kt\ncom/mineinabyss/features/npc/NpcEntity\n*L\n41#1:161,2\n63#1:163,5\n65#1:168,5\n71#1:173,5\n*E\n"})
public final class NpcEntity {
    @NotNull
    private final Npc config;
    @NotNull
    private final World mainWorld;
    @NotNull
    private final DialogsConfig dialogsConfig;
    @Nullable
    private final DialogData dialogData;
    @Nullable
    private final DialogData questDialog;
    public static final int $stable = 8;

    public NpcEntity(@NotNull Npc config2, @NotNull World mainWorld, @NotNull DialogsConfig dialogsConfig, @Nullable DialogData dialogData, @Nullable DialogData questDialog) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)mainWorld, (String)"mainWorld");
        Intrinsics.checkNotNullParameter((Object)dialogsConfig, (String)"dialogsConfig");
        this.config = config2;
        this.mainWorld = mainWorld;
        this.dialogsConfig = dialogsConfig;
        this.dialogData = dialogData;
        this.questDialog = questDialog;
    }

    public /* synthetic */ NpcEntity(Npc npc, World world, DialogsConfig dialogsConfig, DialogData dialogData, DialogData dialogData2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            dialogData = dialogsConfig.getConfigs().get(npc.getDialogId());
        }
        if ((n & 0x10) != 0) {
            dialogData2 = dialogsConfig.getConfigs().get(npc.getQuestEndId());
        }
        this(npc, world, dialogsConfig, dialogData, dialogData2);
    }

    @NotNull
    public final Npc getConfig() {
        return this.config;
    }

    @NotNull
    public final World getMainWorld() {
        return this.mainWorld;
    }

    @NotNull
    public final DialogsConfig getDialogsConfig() {
        return this.dialogsConfig;
    }

    @Nullable
    public final DialogData getDialogData() {
        return this.dialogData;
    }

    @Nullable
    public final DialogData getQuestDialog() {
        return this.questDialog;
    }

    public final void createBaseNpc() {
        Entity $this$iv;
        Object element$iv2;
        Location location = this.config.getLocation();
        Chunk chunk = location.getChunk();
        Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"getChunk(...)");
        Chunk chunk2 = chunk;
        org.bukkit.entity.Entity[] entityArray = chunk2.getEntities();
        Intrinsics.checkNotNullExpressionValue((Object)entityArray, (String)"getEntities(...)");
        Object[] $this$forEach$iv = entityArray;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            org.bukkit.entity.Entity it = (org.bukkit.entity.Entity)element$iv2;
            boolean bl = false;
            if (it.getScoreboardTags().contains(this.config.getId())) {
                System.out.println((Object)("removed old npc entity with id " + this.config.getId()));
                it.remove();
                continue;
            }
            System.out.println((Object)("dialog config is " + this.dialogsConfig.getConfigs().keySet()));
            System.out.println((Object)("no old npc entity with id " + this.config.getId() + " found"));
        }
        org.bukkit.entity.Entity entity = location.getWorld().spawn(location, ItemDisplay.class);
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"spawn(...)");
        ItemDisplay entity2 = (ItemDisplay)entity;
        ModeledEntity modeledEntity = ModelEngineAPI.createModeledEntity((org.bukkit.entity.Entity)((org.bukkit.entity.Entity)entity2));
        ActiveModel activeModel = ModelEngineAPI.createActiveModel((String)this.config.getBbModel());
        modeledEntity.addModel(activeModel, true);
        entity2.addScoreboardTag(this.config.getId());
        entity2.setCustomName(this.config.getDisplayName());
        entity2.setCustomNameVisible(true);
        entity2.setPersistent(false);
        entity2.teleport(location);
        Entity entity3 = ConversionKt.toGearyOrNull((org.bukkit.entity.Entity)((org.bukkit.entity.Entity)entity2));
        if (entity3 == null) {
            return;
        }
        Entity gearyEntity = entity3;
        element$iv2 = gearyEntity;
        Object component$iv = this.config;
        KClass kClass$iv = Reflection.getOrCreateKotlinClass(Npc.class);
        boolean noEvent$iv = false;
        boolean $i$f$set = false;
        $this$iv.set-z13BHRw(component$iv, EngineHelpersKt.componentId((Geary)$this$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv)), noEvent$iv);
        if (this.dialogData != null) {
            $this$iv = gearyEntity;
            component$iv = this.dialogData;
            kClass$iv = Reflection.getOrCreateKotlinClass(DialogData.class);
            noEvent$iv = false;
            $i$f$set = false;
            $this$iv.set-z13BHRw(component$iv, EngineHelpersKt.componentId((Geary)$this$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv)), noEvent$iv);
            System.out.println((Object)"dialogg data set");
        } else {
            System.out.println((Object)("couldnt set dialog data for npc " + this.config.getId()));
        }
        if (this.questDialog != null) {
            $this$iv = gearyEntity;
            component$iv = new QuestDialogData(this.questDialog);
            kClass$iv = Reflection.getOrCreateKotlinClass(QuestDialogData.class);
            noEvent$iv = false;
            $i$f$set = false;
            $this$iv.set-z13BHRw(component$iv, EngineHelpersKt.componentId((Geary)$this$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv)), noEvent$iv);
        }
    }

    public final void createTypedNpc() {
        switch (this.config.getType()) {
            case "trader": {
                this.createTraderNpc();
                break;
            }
            case "gondola_unlocker": {
                this.createGondolaUnlockerNpc();
                break;
            }
            case "quest_giver": {
                this.createQuestGiverNpc();
                break;
            }
            case "dialogue": {
                this.createDialogueNpc();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + this.config.getType());
            }
        }
    }

    public final void createDialogueNpc() {
    }

    public final void createQuestGiverNpc() {
    }

    public final void createGondolaUnlockerNpc() {
    }

    public final void createTraderNpc() {
        if (!((Collection)this.config.getTradeTable().getTrades()).isEmpty()) {
            Location location = this.config.getLocation();
            Chunk chunk = location.getChunk();
            Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"getChunk(...)");
            Chunk chunk2 = chunk;
            for (org.bukkit.entity.Entity entity : chunk2.getEntities()) {
                Intrinsics.checkNotNull((Object)entity);
                org.bukkit.entity.Entity e = entity;
                if (!e.getScoreboardTags().contains(this.config.getId())) continue;
                e.remove();
            }
            org.bukkit.entity.Entity entity = location.getWorld().spawn(location, Interaction.class);
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"spawn(...)");
            Interaction entity2 = (Interaction)entity;
            List<MerchantRecipe> recipes = this.createMerchantRecipes(this.config.getTradeTable().getTrades());
            Merchant merchant = Bukkit.createMerchant();
            Intrinsics.checkNotNullExpressionValue((Object)merchant, (String)"createMerchant(...)");
            Merchant merchant2 = merchant;
            merchant2.setRecipes(recipes);
            entity2.setCustomName("a");
            entity2.addScoreboardTag("custom trade ig");
            entity2.addScoreboardTag(this.config.getId());
            Bukkit.getPluginManager().registerEvents(new Listener(entity2, this, merchant2){
                final /* synthetic */ Interaction $entity;
                final /* synthetic */ NpcEntity this$0;
                final /* synthetic */ Merchant $merchant;
                {
                    this.$entity = $entity;
                    this.this$0 = $receiver;
                    this.$merchant = $merchant;
                }

                @EventHandler
                public final void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Player player = event.getPlayer();
                    Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
                    Player player2 = player;
                    LoggingKt.info((CommandSender)((CommandSender)player2), (Object)"bleh bleh bleh");
                    if (Intrinsics.areEqual((Object)event.getRightClicked(), (Object)this.$entity)) {
                        LoggingKt.info((CommandSender)((CommandSender)player2), (Object)"bla bla bla");
                        event.setCancelled(true);
                        List<MerchantRecipe> new_recipe = this.this$0.createMerchantRecipes(this.this$0.getConfig().getTradeTable().getTrades());
                        this.$merchant.setRecipes(new_recipe);
                        ((MerchantView)((MerchantInventoryViewBuilder)MenuType.MERCHANT.builder()).merchant(this.$merchant).build((HumanEntity)player2)).open();
                    }
                }
            }, (Plugin)AbyssContextKt.getAbyss().getPlugin());
        }
    }

    @NotNull
    public final List<MerchantRecipe> createMerchantRecipes(@NotNull List<Trade> trades) {
        Intrinsics.checkNotNullParameter(trades, (String)"trades");
        ItemTrackingModule gearyItems = (ItemTrackingModule)WorldManagerKt.toGeary((World)this.mainWorld).getAddon(ItemTrackingKt.getItemTracking());
        List recipes = new ArrayList();
        for (Trade trade : trades) {
            ItemStack outputItem;
            ItemStack inputItem;
            if (ItemTrackingModule.createItem$default((ItemTrackingModule)gearyItems, (PrefabKey)PrefabKey.Companion.of(trade.getInput().getPrefab()), null, (int)2, null) == null) {
                throw new IllegalStateException(("Incorrect prefab key: " + trade.getInput().getPrefab()).toString());
            }
            inputItem.setAmount(trade.getInput().getAmount());
            if (ItemTrackingModule.createItem$default((ItemTrackingModule)gearyItems, (PrefabKey)PrefabKey.Companion.of(trade.getOutput().getPrefab()), null, (int)2, null) == null) {
                throw new IllegalStateException(("Incorrect prefab key: " + trade.getOutput().getPrefab()).toString());
            }
            outputItem.setAmount(trade.getOutput().getAmount());
            MerchantRecipe recipe = new MerchantRecipe(outputItem, 99999);
            recipe.addIngredient(inputItem);
            recipes.add(recipe);
        }
        return recipes;
    }
}

