/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.features.gondolas;

import androidx.compose.runtime.internal.StabilityInferred;
import com.mineinabyss.components.gondolas.Gondola;
import com.mineinabyss.components.gondolas.UnlockedGondolas;
import com.mineinabyss.features.gondolas.GondolaData;
import com.mineinabyss.features.gondolas.GondolaType;
import com.mineinabyss.features.gondolas.GondolasHelpersKt;
import com.mineinabyss.features.gondolas.LoadedGondolas;
import com.mineinabyss.geary.datatypes.Entity;
import com.mineinabyss.geary.helpers.EngineHelpersKt;
import com.mineinabyss.geary.modules.Geary;
import com.mineinabyss.geary.papermc.tracking.entities.ConversionKt;
import com.mineinabyss.idofront.messaging.LoggingKt;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u0010*\u00020\u0014H\u0007J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bJ,\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\t2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\bH\u0002R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/mineinabyss/features/gondolas/GondolasListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "playerZoneEntry", "", "Ljava/util/UUID;", "Lkotlin/Pair;", "", "", "justWarped", "", "lastErrorTime", "errorCooldown", "", "handleGondola", "", "player", "Lorg/bukkit/entity/Player;", "onPlayerMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "showError", "gondola", "Lcom/mineinabyss/components/gondolas/Gondola;", "now", "startCooldownDisplayTask", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "handleWarpCooldown", "data", "Lcom/mineinabyss/features/gondolas/GondolaData;", "gondolaId", "mineinabyss-features"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGondolasListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GondolasListener.kt\ncom/mineinabyss/features/gondolas/GondolasListener\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Entity.kt\ncom/mineinabyss/geary/datatypes/Entity\n*L\n1#1,102:1\n183#2,2:103\n147#3,5:105\n*S KotlinDebug\n*F\n+ 1 GondolasListener.kt\ncom/mineinabyss/features/gondolas/GondolasListener\n*L\n35#1:103,2\n41#1:105,5\n*E\n"})
public final class GondolasListener
implements Listener {
    @NotNull
    private final Map<UUID, Pair<String, Long>> playerZoneEntry = new LinkedHashMap();
    @NotNull
    private final Set<UUID> justWarped = new LinkedHashSet();
    @NotNull
    private final Map<UUID, Long> lastErrorTime = new LinkedHashMap();
    private final int errorCooldown;
    public static final int $stable = 8;

    public GondolasListener() {
        this.errorCooldown = 5000;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleGondola(Player player) {
        void this_$iv$iv;
        Object v0;
        Object element$iv2;
        long now;
        block6: {
            void $this$firstOrNull$iv;
            Map<String, Gondola> gondolas = LoadedGondolas.INSTANCE.getLoaded();
            now = System.currentTimeMillis();
            Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)gondolas.entrySet()), arg_0 -> GondolasListener.handleGondola$lambda$0(player, arg_0));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                GondolaData it = (GondolaData)element$iv2;
                boolean bl = false;
                if (!(it.getType() != GondolaType.NONE)) continue;
                v0 = element$iv2;
                break block6;
            }
            v0 = null;
        }
        GondolaData gondolaData = v0;
        if (gondolaData == null) {
            GondolasListener $this$handleGondola_u24lambda_u242 = this;
            boolean bl = false;
            $this$handleGondola_u24lambda_u242.playerZoneEntry.remove(player.getUniqueId());
            $this$handleGondola_u24lambda_u242.justWarped.remove(player.getUniqueId());
            return;
        }
        GondolaData nearbyGondolaData = gondolaData;
        Entity this_$iv = ConversionKt.toGeary((org.bukkit.entity.Entity)((org.bukkit.entity.Entity)player));
        boolean $i$f$get = false;
        element$iv2 = this_$iv;
        KClass kClass$iv$iv = Reflection.getOrCreateKotlinClass(UnlockedGondolas.class);
        boolean $i$f$get2 = false;
        Object object = this_$iv$iv.get-VKZWuLQ(EngineHelpersKt.componentId((Geary)this_$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv)));
        if (!(object instanceof UnlockedGondolas)) {
            object = null;
        }
        UnlockedGondolas unlockedGondolas = (UnlockedGondolas)object;
        if (unlockedGondolas == null) {
            return;
        }
        UnlockedGondolas unlockedGondolas2 = unlockedGondolas;
        if (!unlockedGondolas2.getKeys().contains(nearbyGondolaData.getId())) {
            this.showError(player, nearbyGondolaData.getGondola(), now);
            return;
        }
        if (this.justWarped.contains(player.getUniqueId())) {
            return;
        }
        this.handleWarpCooldown(player, nearbyGondolaData, now, nearbyGondolaData.getId());
    }

    @EventHandler
    public final void onPlayerMove(@NotNull PlayerMoveEvent $this$onPlayerMove) {
        Intrinsics.checkNotNullParameter((Object)$this$onPlayerMove, (String)"<this>");
        if (!$this$onPlayerMove.hasExplicitlyChangedBlock()) {
            return;
        }
        Player player = $this$onPlayerMove.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.handleGondola(player);
    }

    private final void showError(Player player, Gondola gondola, long now) {
        long lastTime;
        Long l = this.lastErrorTime.get(player.getUniqueId());
        long l2 = lastTime = l != null ? l : 0L;
        if (now - lastTime >= (long)this.errorCooldown) {
            LoggingKt.error((CommandSender)((CommandSender)player), (Object)gondola.getRawNoAccessMessage());
            this.lastErrorTime.put(player.getUniqueId(), now);
        }
    }

    public final void startCooldownDisplayTask(@NotNull JavaPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, () -> GondolasListener.startCooldownDisplayTask$lambda$3(this, plugin), 1L, 1L);
    }

    private final void handleWarpCooldown(Player player, GondolaData data, long now, String gondolaId) {
        Pair<String, Long> entry = this.playerZoneEntry.get(player.getUniqueId());
        Pair<String, Long> pair = entry;
        if (!Intrinsics.areEqual((Object)(pair != null ? (String)pair.getFirst() : null), (Object)data.getId())) {
            this.playerZoneEntry.put(player.getUniqueId(), (Pair<String, Long>)TuplesKt.to((Object)data.getId(), (Object)now));
        } else if (now - ((Number)entry.getSecond()).longValue() >= data.getGondola().getWarpCooldown()) {
            GondolasHelpersKt.gondolaWarp(data.getGondola(), player, data.getType(), gondolaId);
            this.playerZoneEntry.remove(player.getUniqueId());
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            this.justWarped.add(uUID);
        }
    }

    static /* synthetic */ void handleWarpCooldown$default(GondolasListener gondolasListener, Player player, GondolaData gondolaData, long l, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        gondolasListener.handleWarpCooldown(player, gondolaData, l, string);
    }

    private static final GondolaData handleGondola$lambda$0(Player $player, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String id = (String)entry.getKey();
        Gondola gondola = (Gondola)entry.getValue();
        Location location = $player.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        return GondolasHelpersKt.getClosestGondolaData(gondola, location, id);
    }

    private static final void startCooldownDisplayTask$lambda$3(GondolasListener this$0, JavaPlugin $plugin) {
        long now = System.currentTimeMillis();
        for (Map.Entry<UUID, Pair<String, Long>> entry : this$0.playerZoneEntry.entrySet()) {
            Player player;
            Gondola gondolaData;
            UUID uuid = entry.getKey();
            Pair<String, Long> entry2 = entry.getValue();
            if ($plugin.getServer().getPlayer(uuid) == null || LoadedGondolas.INSTANCE.getLoaded().get(entry2.getFirst()) == null) continue;
            long remaining = gondolaData.getWarpCooldown() - (now - ((Number)entry2.getSecond()).longValue());
            if (remaining == gondolaData.getWarpCooldown()) {
                Key soundKey;
                Intrinsics.checkNotNullExpressionValue((Object)Key.key((String)"minecraft:ambient.cave.cave_18"), (String)"key(...)");
                player.playSound(Sound.sound((Key)soundKey, (Sound.Source)Sound.Source.AMBIENT, (float)1.0f, (float)1.0f));
            }
            if (remaining > 0L) {
                long seconds = remaining / (long)1000;
                player.sendActionBar("Warping in " + seconds + " seconds...");
                continue;
            }
            this$0.handleGondola(player);
        }
    }
}

