/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.features.helpers;

import com.mineinabyss.components.PlayerData;
import com.mineinabyss.components.curse.AscensionEffect;
import com.mineinabyss.components.curse.PlayerCurseEvent;
import com.mineinabyss.components.layer.Layer;
import com.mineinabyss.features.helpers.LayerUtilsKt;
import com.mineinabyss.features.helpers.api.API;
import com.mineinabyss.features.helpers.api.APIDiscordSRV;
import com.mineinabyss.geary.datatypes.Entity;
import com.mineinabyss.geary.helpers.EngineHelpersKt;
import com.mineinabyss.geary.modules.Geary;
import com.mineinabyss.geary.papermc.tracking.entities.ConversionKt;
import com.mineinabyss.geary.serialization.SerializableComponentsKt;
import com.mineinabyss.geary.serialization.SerializableComponentsModule;
import com.mineinabyss.geary.serialization.components.Persists;
import com.mineinabyss.idofront.textcomponents.MiniMessageHelpersKt;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0015\u0010\u0013\u001a\u00020\u0014*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\u00a8\u0006\u0016"}, d2={"simpleLayerName", "", "Lorg/bukkit/entity/Player;", "getSimpleLayerName", "(Lorg/bukkit/entity/Player;)Ljava/lang/String;", "getLayerWhistleForHud", "recentlyMovedPlayers", "", "Ljava/util/UUID;", "handleCurse", "", "player", "from", "Lorg/bukkit/Location;", "to", "linkedDiscordAccount", "Lorg/bukkit/OfflinePlayer;", "getLinkedDiscordAccount", "(Lorg/bukkit/OfflinePlayer;)Ljava/lang/String;", "isInventoryFull", "", "(Lorg/bukkit/entity/Player;)Z", "mineinabyss-features"})
@SourceDebugExtension(value={"SMAP\nHelperFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelperFunctions.kt\ncom/mineinabyss/features/helpers/HelperFunctionsKt\n+ 2 PlayerData.kt\ncom/mineinabyss/components/PlayerDataKt\n+ 3 Entity.kt\ncom/mineinabyss/geary/datatypes/Entity\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 EntitySerializationExtensions.kt\ncom/mineinabyss/geary/serialization/EntitySerializationExtensionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n53#2,2:68\n55#2:75\n56#2:78\n57#2:88\n147#3,5:70\n75#3:85\n1869#4,2:76\n17#5,6:79\n23#5,2:86\n1#6:89\n*S KotlinDebug\n*F\n+ 1 HelperFunctions.kt\ncom/mineinabyss/features/helpers/HelperFunctionsKt\n*L\n45#1:68,2\n45#1:75\n45#1:78\n45#1:88\n45#1:70,5\n45#1:85\n53#1:76,2\n45#1:79,6\n45#1:86,2\n*E\n"})
public final class HelperFunctionsKt {
    @NotNull
    private static final Set<UUID> recentlyMovedPlayers = new HashSet();

    @NotNull
    public static final String getSimpleLayerName(@NotNull Player $this$simpleLayerName) {
        Intrinsics.checkNotNullParameter((Object)$this$simpleLayerName, (String)"<this>");
        PlainTextComponentSerializer plainTextComponentSerializer = PlainTextComponentSerializer.plainText();
        Location location = $this$simpleLayerName.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        Object object = LayerUtilsKt.getLayer(location);
        if (object == null || (object = object.getName()) == null || (object = MiniMessageHelpersKt.miniMsg$default((String)object, null, (int)1, null)) == null) {
            TextComponent textComponent = Component.empty();
            Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"empty(...)");
            object = (Component)textComponent;
        }
        String string = plainTextComponentSerializer.serialize((Component)object);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialize(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return StringsKt.replace$default((String)string2, (String)" ", (String)"_", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String getLayerWhistleForHud(@NotNull Player $this$getLayerWhistleForHud) {
        Intrinsics.checkNotNullParameter((Object)$this$getLayerWhistleForHud, (String)"<this>");
        return switch (HelperFunctionsKt.getSimpleLayerName($this$getLayerWhistleForHud)) {
            case "orth" -> "\uebaf";
            case "edge_of_the_abyss" -> "\uebb0";
            case "forest_of_temptation" -> "\uebb1";
            case "the_goblets_of_giants", "great_fault" -> "\uebb2";
            case "sea_of_corpses" -> "\uebb3";
            default -> "";
        };
    }

    /*
     * WARNING - void declaration
     */
    public static final void handleCurse(@NotNull Player player, @NotNull Location from, @NotNull Location to) {
        void $this$setPersisting_u24default$iv$iv;
        PlayerData playerData$iv;
        void this_$iv$iv$iv;
        Entity entity$iv;
        block13: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)from, (String)"from");
                Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                if (from.distanceSquared(to) > 1024.0) {
                    return;
                }
                if (recentlyMovedPlayers.remove(player.getUniqueId())) break block12;
                World world = player.getWorld();
                Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
                if (LayerUtilsKt.isAbyssWorld(world)) break block13;
            }
            return;
        }
        double changeY = to.getY() - from.getY();
        Player $this$editPlayerData$iv = player;
        boolean $i$f$editPlayerData = false;
        Entity this_$iv$iv = entity$iv = ConversionKt.toGeary((org.bukkit.entity.Entity)((org.bukkit.entity.Entity)$this$editPlayerData$iv));
        boolean $i$f$get = false;
        Entity entity = this_$iv$iv;
        KClass kClass$iv$iv$iv = Reflection.getOrCreateKotlinClass(PlayerData.class);
        boolean $i$f$get2 = false;
        Object object = this_$iv$iv$iv.get-VKZWuLQ(EngineHelpersKt.componentId((Geary)this_$iv$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv$iv)));
        if (!(object instanceof PlayerData)) {
            object = null;
        }
        PlayerData playerData = (PlayerData)object;
        PlayerData playerData2 = playerData;
        if (playerData == null) {
            playerData2 = new PlayerData(false, 0.0, 0.0, false, false, false, false, 0, 0, false, false, false, null, false, 16383, null);
        }
        PlayerData $this$handleCurse_u24lambda_u241 = playerData$iv = playerData2;
        boolean bl = false;
        if (player.isInvulnerable()) {
            $this$handleCurse_u24lambda_u241.setCurseAccrued(0.0);
        } else if ($this$handleCurse_u24lambda_u241.isAffectedByCurse()) {
            Layer layer = LayerUtilsKt.getLayer(to);
            if (layer == null) {
                return;
            }
            Layer layer2 = layer;
            double dist = $this$handleCurse_u24lambda_u241.getCurseAccrued();
            $this$handleCurse_u24lambda_u241.setCurseAccrued(RangesKt.coerceAtLeast((double)(dist + changeY), (double)0.0));
            if (dist >= 10.0 && new PlayerCurseEvent(player, layer2.getAscensionEffects()).callEvent()) {
                Iterable $this$forEach$iv = layer2.getAscensionEffects();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AscensionEffect it = (AscensionEffect)element$iv;
                    boolean bl2 = false;
                    it.clone().applyEffect(player, 10);
                }
                $this$handleCurse_u24lambda_u241.setCurseAccrued($this$handleCurse_u24lambda_u241.getCurseAccrued() - (double)10);
            }
        }
        Unit returned$iv = Unit.INSTANCE;
        this_$iv$iv = entity$iv;
        PlayerData component$iv$iv = playerData$iv;
        KClass kClass$iv$iv = Reflection.getOrCreateKotlinClass(PlayerData.class);
        boolean noEvent$iv$iv = false;
        boolean $i$f$setPersisting = false;
        void this_$iv$iv$iv2 = $this$setPersisting_u24default$iv$iv;
        boolean $i$f$set = false;
        this_$iv$iv$iv2.set-z13BHRw((Object)component$iv$iv, EngineHelpersKt.componentId((Geary)this_$iv$iv$iv2.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv)), noEvent$iv$iv);
        $this$setPersisting_u24default$iv$iv.setRelation-x53JL5M(((SerializableComponentsModule)$this$setPersisting_u24default$iv$iv.getWorld().getAddon(SerializableComponentsKt.getSerializableComponents())).getPersists-s-VKNKU(), EngineHelpersKt.componentId((Geary)$this$setPersisting_u24default$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv)), (Object)new Persists(0, 1, null), noEvent$iv$iv);
    }

    @Nullable
    public static final String getLinkedDiscordAccount(@NotNull OfflinePlayer $this$linkedDiscordAccount) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$linkedDiscordAccount, (String)"<this>");
        APIDiscordSRV aPIDiscordSRV = API.INSTANCE.getDiscordSRV();
        if (aPIDiscordSRV != null && (aPIDiscordSRV = aPIDiscordSRV.getPlugin()) != null) {
            Object object;
            APIDiscordSRV aPIDiscordSRV2 = aPIDiscordSRV;
            try {
                APIDiscordSRV $this$_get_linkedDiscordAccount__u24lambda_u242 = aPIDiscordSRV2;
                boolean bl = false;
                User user = $this$_get_linkedDiscordAccount__u24lambda_u242.getJda().getUserById($this$_get_linkedDiscordAccount__u24lambda_u242.getAccountLinkManager().getDiscordId($this$linkedDiscordAccount.getUniqueId()));
                object = Result.constructor-impl((Object)(user != null ? user.getName() : null));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object2 = object;
            string = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
        } else {
            string = null;
        }
        return string;
    }

    public static final boolean isInventoryFull(@NotNull Player $this$isInventoryFull) {
        Intrinsics.checkNotNullParameter((Object)$this$isInventoryFull, (String)"<this>");
        return $this$isInventoryFull.getInventory().firstEmpty() == -1;
    }
}

